/*****************************************************************************************
 do-file used to create an homogeneous serie of estate at death between 1984 and 2000
******************************************************************************************/


set more off, permanently
clear

*******************************************************************************************
* Creation of the homogeneous serie of estate at death between 1984 and 2000
	
	* I) Homogeneization of the MTG files (84, 87, 94 and 2000)
		if $casd==0 {
			do "$doDMTG/DMTG/dodmtg8487.do"
			do "$doDMTG/DMTG/dodmtg1994.do"
			do "$doDMTG/DMTG/dodmtg2000.do"
		}
		if $casd==1 {
			do "$doDMTG/DMTG/dodmtg2006.do"
			do "$doDMTG/DMTG/dodmtg2010.do"
		}

foreach year of global yearlistdmtg {
	global year=`year'
	use "${wfDMTG}/MTG/wf${year}succ.dta",clear

	* Add the tax allowance of 20% for housing assets in 2000 (if the spouse is living in the same house than the decedents)
		*replace pat_exo=pat_exo+(patfon_brut_exo+patfon_brut)*0.25*(mat=="M") if year==2000
		*replace patfon_brut_exo=patfon_brut_exo+(patfon_brut_exo+patfon_brut)*0.25*(mat=="M") if year==2000
			
	* Wealth at death taking into account the taxable bequest and the declared tax exempt assets
		if $year<2010 {
			gen pat=actnet+pat_exo
		}
		if $year==2010 {
			gen pat=actnet
			foreach var of varlist pat_exo patfon_brut_exo patpro_exo patfin_div_exo patfin_int_exo patfin_liqu_exo patfin_av_exo {
				replace `var'=0
			}
		}
			
		
		#delimit;
		keep year idsucc  pondn  yeardec birth age sexe nenf nenf01 mat 
			pat actbrut passif actnet pat_exo patfon_brut patpro patfin_div patfin_int patfin_liqu patfin_av 
			 patfon_brut_exo patpro_exo patfin_div_exo patfin_int_exo patfin_liqu_exo patfin_av_exo
			donations dons10moins dons10plus donsman ;
			
		order year idsucc  pondn  yeardec birth
			age sexe nenf nenf01 mat /* nher nenf nenf01 pcs pcs_d   regmat */
			pat  actbrut passif actnet pat_exo 
			 patfon_brut patpro patfin_div patfin_int patfin_liqu patfin_av 
			 patfon_brut_exo patpro_exo patfin_div_exo patfin_int_exo patfin_liqu_exo patfin_av_exo
			donations dons10moins dons10plus donsman /*nb_donant date_dons1 date_dons2 date_dons3 date_dons4 */;
		#delimit cr
			save "${wfDMTG}/MTG/wf${year}succ.dta", replace
}


