******************************************************************************************************
* Do-file used to estimate the demographic structure of the decedents (entire population) 1984-2010  *
******************************************************************************************************

* Compute the number of decedents by year, age, gender, marital status and dummy for having a child in 1984, 1987, 1994, 2000, 2006 and 2010
	* Note :  Proportion of decedents by marital status + proportion of decendets having a child for 1984-1994 comes from Piketty(2011) using the survey EHF99/BullDcs20002004 

set more off
clear


*1) Merge all the data
*************************
	
	* Demographic structure of the decedents for years 1998/2002 2006 and 2010 using INSEE data  (Donnes de l'Etat civil)Period 1998/2010
		* Launch only one time: saved as demofile`year'.dta
		* do "$param/Decedents/demofile19982010.do"

	use "$param/Decedents/demofile19841994.dta", clear
	drop if age<20
	foreach num of numlist 2000 2006 2010 {
		merge 1:1 age using  "$param/Decedents/demofile`num'.dta"
		drop _merge
	}
	
	* More than 100 years old
		foreach var of newlist h f {
			foreach num of numlist 2000 2006 2010 {
				egen temp`var'`num' = sum(ndec`var'`num'*(age>=100))
				replace ndec`var'`num'=temp`var'`num' if age==100
				drop temp`var'`num'
			}
		}
		drop if age>100
		drop penf0?????
	
* 2) Number of decedents by demographic parameters 
******************************************************
	* Adjustment of the data
		reshape long ndech ndecf  pCh pCf pMh pMf pVh pVf pDh pDf,i(age) j(year)
		sort year age
		reshape long ndec pC pM pV pD,i(year age) j(sex) string
		gen sexe=0 if sex=="h"
		replace sexe=1 if sex=="f"
		gen aged=10*int(age/10)
		replace aged=90 if aged>90
		
		keep year sexe aged age ndec pC pM pV pD penf0
		collapse pC pM pV pD penf0 aged (sum) ndec, by(year sexe age)
		order year sexe aged age ndec
		sort year sexe age
		
	* By year and gender
		bys year sexe : egen ndecsexe = sum(ndec)
	
	* By year, gender, age groups
		bys year sexe age : egen ndecage=sum(ndec)
		bys year sexe aged : egen ndecaged=sum(ndec)
		bys year : egen ndecyear=sum(ndec)
		order year sexe aged age ndec*
		sort year sexe age
		tempfile temp
		save "`temp'", replace

* 3) Creation of the demographic file wfdemofile 
*************************************************
	* one line by year, gender, age (0 to 100 y.o), marital status and children dummy
	
	* Marital status
		gen mat="C"
		foreach var of newlist M V D {
			append using "`temp'"
			replace mat="`var'" if mat==""
		}
	* Children dummy
		erase "`temp'"
		tempfile temp
		save "`temp'", replace
		gen nenf01=0
		append using "`temp'"
		replace nenf01=1 if nenf01==.
		
	sort year sexe aged age mat nenf01
	order year sexe aged age mat nenf01
	save "$wfDMTG/demodec/wfdemofile.dta", replace

