**********************************************************************************************************************************
* Do file used to change the formatting of the xls file rawdata_byyear_originalThomas in order to use with wid.world/gpinter 	 *
**********************************************************************************************************************************

* Creation of rawdata_byyear from rawdata_byyear_originalThomas
	
clear
set more off


*cap ssc install sxpose

* Step 1: Rawdata_byyeartemp = Table C6 from Appendix C
*********************************************************

	**** Years and averages 
		import excel "$projsimul/rawdata_byyear_originalThomas.xlsx", sheet("RawDatatemp") cellrange(A1:FI2)  clear
		rename * v(#), renumber
		forval i = 1 4 to 163{
		preserve
		local j=`i'+1
		keep v`i' v`j'
		sxpose, clear firstnames force
		gen obs=_n
		save average_`i', replace
		restore
		}

	*** thr, p and b
		import excel "$projsimul/rawdata_byyear_originalThomas.xlsx", sheet("RawDatatemp") cellrange(A4:FI20)  clear
		rename * v(#), renumber
		br
		forval i = 1 4 to 163{
		preserve
		local j=`i'+1
		local z=`i'+2
		keep v`i' v`j' v`z'
		drop if missing(v`i')
		replace v`z'=. if v`z'==0
		rename v`i' thr
		rename v`j' p
		rename v`z' b
		gen obs=_n
		save thr_p_b_`i', replace
		restore
		}

		
	*** Creating final Excel file
		forval i = 1 4 to 163{
			use thr_p_b_`i', replace
			merge m:m obs using average_`i', nogen
			destring year average, replace
			qui summ year if !missing(year)
			local year = r(mean)
			replace year= year[_n-1] if missing(year)
			replace average= average[_n-1] if missing(average)
			drop obs
			sort p
			drop if p==0 & thr ==0 & missing(b) & p[_n-1]==0 & thr[_n-1]==0 & missing(b[_n-1])
			order year average p thr  b
			export excel "$projsimul/rawdata_byyeartemp.xlsx", sheet("`year'") firstrow(variables) nolabel sheetmodify
		}

	*** Suppressing temporary files 
		forval i = 1 4 to 163{
			erase average_`i'.dta
			erase thr_p_b_`i'.dta
		}
		
* Step 2 : Apply gpinter to rawdata_byyeartemp
************************************************

* Step 3: Compute Table C7 Bottom wealth ratios and shares in France 
**********************************************************************
	foreach year in 1807 1817 1827 1837 1847 1857 1867 1877 1887 1902 1903 1904 1905 1907 1909 1910 1911 1912 1913 1925 1926 1927 1929 1930 1931 1932 1933 1935 1936 1937 1938 1939 1940 1941 1942 1943 1944 1945 1946 1947 1948 1949 1950 1951 1952 1953 1954 1955 1956 1957 1958 1959 1960 1962 1964{
		insheet using "$projsimulres/temp/`year'.csv",clear 
		replace b="" if b=="Inf"
		destring b,replace
		rename topavg ytop
		drop average 
		replace year=`year'
		replace p=p*100
		if `year'>1807 {
			append using "`temp'"
			erase "`temp'"
		}
		tempfile temp
		save "`temp'",replace	
	}
	
	sort year p
	bys year : egen average=sum(ytop*(p==0))
	keep if p==50 | p==90 | p==99
	replace topsh=topsh-topsh[_n+1] if p==50
	replace thr=thr/average
	drop ytop average
	reshape wide thr topsh b,i(year) j(p)
	order year topsh* thr* b*
	save "$projdirfiles/tables/TableC7.dta", replace
	export excel using "$projdirfiles/tables/TableC7.xlsx", firstrow(variables) replace

* Step 4: Rawdata_byyear = Table C8 from Appendix C
*********************************************************

	**** Years and averages 
		import excel "$projsimul/rawdata_byyear_originalThomas.xlsx", sheet("RawData") cellrange(A1:FI2)  clear
		rename * v(#), renumber
		forval i = 1 4 to 163{
		preserve
		local j=`i'+1
		keep v`i' v`j'
		sxpose, clear firstnames force
		gen obs=_n
		save average_`i', replace
		restore
		}

	*** thr, p and b
		import excel "$projsimul/rawdata_byyear_originalThomas.xlsx", sheet("RawData") cellrange(A4:FI20)  clear
		rename * v(#), renumber
		br
		forval i = 1 4 to 163{
		preserve
		local j=`i'+1
		local z=`i'+2
		keep v`i' v`j' v`z'
		drop if missing(v`i')
		replace v`z'=. if v`z'==0
		rename v`i' thr
		rename v`j' p
		rename v`z' b
		gen obs=_n
		save thr_p_b_`i', replace
		restore
		}

		
	*** Creating final Excel file
		forval i = 1 4 to 163{
			use thr_p_b_`i', replace
			merge m:m obs using average_`i', nogen
			destring year average, replace
			qui summ year if !missing(year)
			local year = r(mean)
			replace year= year[_n-1] if missing(year)
			replace average= average[_n-1] if missing(average)
			drop obs
			order year average p thr  b
			export excel "$projsimul/rawdata_byyear.xlsx", sheet("`year'") firstrow(variables) nolabel sheetmodify
		}

	*** Suppressing temporary files 
		forval i = 1 4 to 163{
			erase average_`i'.dta
			erase thr_p_b_`i'.dta
		}
		
* Step 5 : Apply gpinter to rawdata_byyear
******************************************

