/********************************************************
 Do-file used to harmonize the wealht survey 1998	*
*********************************************************/

set more off
clear

local year=1998
use "$datapat/EP 97-98/Stata/individu.dta",clear
merge 1:1 idnum using "$datapat/EP 97-98/Stata/revenu.dta"
drop _merge
gen year=1998

* A) Socio-demographic variables 
**********************************
			
	* Identifier
		* Household: ident, individual : idnum
	* Weigt
		gen pondn=pond
	* Age
		*age
	* Decenial age 
		gen aged=real(t10age)
	* lien avec la personne de reference (PR)
		* lien
	* Number of children living in the household
		bys ident : egen nbenftemp=sum(lien=="3")
		gen nenf=0
		replace nenf=nbenftemp if lien=="1" | lien=="2"
		drop nbenftemp

	* Marital status
		*matri (1: single (C), 2: married (M), 3: widow (V), 4: divorced (D))
		gen mat="C" if matri=="1"
		replace mat="M" if matri=="2"
		replace mat="V" if matri=="3"
		replace mat="D" if matri=="4"
		replace mat="C" if matri==""
		drop matri

	* Sex (1 :M, 2 :F)
		gen sexetemp=sexe
		drop sexe
		gen sexe=0 if sexetemp=="1"
		replace sexe=1 if sexetemp=="2"
	* PCS
		* harmonisation avec enqutes DMTG
			gen pcs_ind=int(real(cs)/10)
			replace pcs_ind=9 if cs=="31"
			replace pcs_ind=8 if real(cs)==0
			
keep year ident idnum sexe age aged lien nenf mat pondn pcs_ind rri5 rsi1 rsi3 rci1 rnsi1
order year ident idnum pondn sexe age aged lien nenf mat pcs_ind rri5 rsi1 rsi3 rci1 rnsi1

	* Merge with table household
		merge m:m ident using "$datapat/EP 97-98/Stata/menage.dta",keepusing(mrtot hod_nb rmcap2 rmcap2b rmcap4 rmtra psim cheque patimm patprof passpers passprof patfisom resmtm)
		drop _merge
	
	* Total number of children (in and utside the household)			
		destring hod_nb,replace
		replace nenf=nenf+hod_nb if lien=="1" | lien=="2"
		gen nenf01=0
		replace nenf01=1 if nenf>0	
		
	* Income at the household level
		* Note: There is no no consistency between total income and its components
		* Total income
			gen rev_tot=max(0,mrtot/6.55957*12)
		
		* Financial income
			gen rfin_irpp_foy=rmcap4/6.55957
			replace rfin_irpp_foy=0 if rmcap4<0 | rmcap4>=9999998
			summ rfin_irpp_foy
		
		* Rental income
			gen rfon_irpp_foy = rmcap2 /6.55957
			replace rfon_irpp_foy = 0 if (rmcap2 <0 | rmcap2 >=9999998)
			summ rfon_irpp_foy
		
		* Labor income: wages+self-employed income+pensions
			* RRI5: Monthly pensions, RSI1: Monthly wages, RSI3: Annual wage complment, RCI1: monthly unemployment benfits, RNSI1: Annual self-employed income 
			foreach var of varlist rri5 rci1  {
				replace `var'=0 if `var'==. | `var'<0 | `var'==999998 | `var'==999999
				replace `var'=`var'*12/6.55957 if `var'==. | `var'<0 | `var'==999998 | `var'==999999
				sum `var',d
			}
			foreach var of varlist  rsi1  {
				replace `var'=0 if `var'==. | `var'<0 | `var'==9999998 | `var'==9999999
				replace `var'=`var'*12/6.55957 
				sum `var',d
			}
			foreach var of varlist   rsi3  rnsi1 {
				replace `var'=0 if `var'==. | `var'<0 | `var'==99999998 | `var'==99999999
				replace `var'=`var'/6.55957 
				sum `var',d
			}
			gen rev_act_pens=0
			foreach var of varlist rri5 rci1 rsi1 rsi3  rnsi1 {
				replace rev_act_pens=rev_act_pens+`var'
			}
			bys ident : egen temp=sum(rev_act_pens)
			replace rev_act_pens=temp
			drop temp
			
			* Correction for non response
				replace rev_act_pens=max(0,rev_tot-rfin_irpp_foy-rfon_irpp_foy) if rev_act_pens==0
			
* C) Composition of wealth by asset
**************************************
			
	* Au niveau mnage : 
		* PSIM : Montant de patrimoine total menage 
		* Il n'est pas gal aux composantes du patrimoines PATIMM (patrimoine immobilier)+PATFISOM (patrimoine fi)+PATPROF(patr prof)
		* Endettement : paspers(endettement personnel) et passprof(endettement prof)
		* A la fin du dofile : somme des composantes = patrimoine total
		
	* patrimoine global simul par l'INSEE ne correspond pas  la somme des composantes
		gen patrimoine_simul=psim/6.55957
		
	* Compte cheque: Deposits To add to patfin_liqu 
				gen ccheque=cheque/6.55957
				replace ccheque=0 if ccheque<0
				
	tempfile temp
	save "`temp'",replace
				
	* Wealth composition :
		
			* Financial assets:
				* patfin_div: Equities and mutual funds 
				* patfin_int: Bonds and loans 
				* patfin_liqu: Deposits and savings accounts
				* patfin_av: Life insurance and pension funds	
					
			 * Non-Financial assets:
				* patfon_owner: Owner-occupied housing assets
				* patfon_rent: Tenant-occupied housing assets
				* patpro: Business assets
				
		
		* 1) Financial assets (au niveau mnage)
		
			use mtsimul nature ident using  "$datapat/EP 97-98/Stata/produit.dta" ,clear 
			destring nature, replace
					* Table par produit. variables d'intrt = mtsimul, nature (type d'actifs), numero (au cas o plusieurs mmes types d'actifs dtenus)
						/* Code nature du produit
							00 Compte-chques : non calcul
							01 Livret Jeune
							02 Livret A
							03 Livret Bleu
							04 Codevi
							05 LEP (livret d'pargne populaire)
							06 Livret B
							07 Livret Orange
							08 Autre livret bancaire
							09 PEL (plan d'pargne-logement)
							10 CEL (compte pargne-logement)
							11 PEA (plan d'pargne en actions)
							12 Valeurs mobilires hors PEA
							13 Obligations, emprunts d'Etat
							14 Actions cotes
							15 Sicav, FCP court terme
							16 Autres Sicav, FCP
							17 Autres valeurs mobilires, non prcises
							18 SCPI (parts de Socit)
							19 Actions non cotes
							20 PEP (plan d'pargne populaire)
							21 Assurance-dcs, rente ducation
							22 Assurance-vie
							23 Retraite complmentaire
							24 Autre pargne retraite
							25 Bons de capitalisation
							26 Bons d'pargne
							27 Compte  terme
							28 Epargne en entreprise
							29 Retraite surcomplmentaire
							30 Compte courant d'associ
						Note :  Code 11+12= agrgation des numros 13-19
						Note : pas de mtsimul pour les codes 21 (utiliser mtvente) et 29 ( supprimer)
						
						*/
					
				
			drop if nature==0 | nature==29
			replace mtsimul=0 if mtsimul==-9999999 | mtsimul==.
			
			* Deposits and savings accounts: 
				* Placement  vue et numraire (AF21+AF22+AF291)
				gen patfin_liqu=mtsimul/6.55957 if (nature>0 & nature<=8) | nature==10  
				
			* Bonds, loans: 
				* Placement  chance (AF292), pargne contractuelle (AF293), Obligations (AF3) titres de creances (AF4) 
				gen patfin_int=mtsimul/6.55957 if  nature==9 | nature==13 | nature==17 | nature==20 | nature==26 | nature==27 | nature==28 | nature==30
			
			* Equities and investment fund shares
				gen patfin_div=mtsimul/6.55957 if nature==14 | nature==15 | nature==16 | nature==18 | nature==19
				* incl. Mututal funds (AF52)
					gen patfin_div_mut=mtsimul/6.55957 if nature==15 | nature==16 | nature==18
				* incl. private equities (AF512+AF519)
					gen patfin_div_priv=mtsimul/6.55957 if nature==14
				* incl. public equities (AF511)
					gen patfin_div_pub=mtsimul/6.55957 if nature==19
					
			* Life insurance and pension funds	
				gen patfin_av = mtsimul/6.55957 if  nature>=22 & nature<=25 
		
			
			/*	gen verif =mtsimul/6.55957 if nature==11 | nature==12
				gen verif2=mtsimul/6.55957 if (nature>12 & nature<=19)
				gen verif3=0
				replace verif3=verif3+mtsimul/6.55957 if (nature>12 & nature<=19)
				replace verif3=verif3-mtsimul/6.55957 if nature==1
		*/
			
			foreach var of varlist patfin_liqu-patfin_av {
				replace `var'=0 if `var'==.
				replace `var'=0 if `var'<0 & nature~=11 
			}

			collapse (sum) patfin_liqu-patfin_av ,by(ident)
			merge 1:m ident using "`temp'"
			drop _merge
			
			foreach var of varlist patfin_liqu-patfin_av {
						replace `var'=0 if `var'==.
			}
			replace  patfin_liqu= patfin_liqu+ccheque
			
			* Total financial assets 
			gen patfin= patfin_liqu+ patfin_int+patfin_div+patfin_av
			
			
	/* Module verif 
		* Comparaison patfin avec patfisom : ok
			gen patfisomtemp=max(0,patfisom/6.55957)
			gen diff =patfin-patfisomtemp
			sum diff if lien=="1",d
			drop diff 
	*/	
			
			
			
	* Housing assets (au niveau mnage)
		gen patfon_owner=resmtm/6.55957
		replace patfon_owner=0 if patfon_owner<0
		
		gen patfon_rent=max(0,patimm/6.55957-patfon_owner)
		gen patfon=patfon_owner+patfon_rent
	
	* Non housing assets (au niveau mnage)
		gen patpro =patprof/6.55957
		replace patpro=0 if patpro<0
		
		
		/* Comparaison patrimoine brut patrimoine avec somme des composantes du patrimoine: diffrent mais c'est normal (dans l'enqute le patrimoine global et ses composantes ne sont pas harmoniss)
			gen pat_brut=patfin+ patfon+patpro
			gen diff =pat_brut-patrimoine_simul
			sum diff if lien=="1",d
			drop diff 
			*/
			
		* Patrimoine net et passif
			tempfile temp 
			save "`temp'",replace
			
			use ident simkdu kdu detobj3 using "$datapat/EP 97-98/Stata/dettes.dta", clear
			keep if detobj3=="1" |  detobj3=="2"
			collapse simkdu,by(ident)
			merge 1:m ident using "`temp'"
			
			gen passif_owner=0
			replace passif_owner= simkdu/6.55957 if simkdu~=.
			replace passif_owner=min(passif_owner,patfon_owner)
			foreach var of varlist passpers passprof {
				replace `var'=0 if `var'==9999999
				replace `var'=-`var'/6.55957 
			}
			gen temp=patfin+patfon
			replace passpers=min(passpers,temp)
			replace passprof=min(passprof, patpro)
			gen passif=passpers
			replace patpro=patpro-passprof
			gen pat=patfon+patfin+patpro-passif
			drop temp

			
* C) Retraitement de la population 
							
	* Suppression des moins de 20 ans qui ne sont pas la personne de rfrence ou le conjoint ou qui sont seuls dans le mnage ou qui sont en mnage avec des moins de 20 ans
		gen prob=1 if (lien=="1" | lien=="2") &(aged<=2)
		bys ident : egen probis=sum(prob==1)
		replace probis=1 if probis~=0
		*bys ident : egen verif=sum(aged>2)
		drop if (aged <=2 & prob~=1)
		drop prob probis 
		replace age=20 if age<20
		replace aged=3 if aged==2

	/* Retraitement des pondrations
		quiet sum pondn
		replace pondn=pondn*${pondn`year'}*1000/r(sum)		*/		

	* Identifiants mnages et individuels
		sort ident lien idnum
		gen temp=1 if lien=="1"
		replace temp=0 if temp==.
		gen id_men=sum(temp)
		
		

* D) Sauvergarde du fichier mnage
			tempfile tabmen
			save "`tabmen'",replace
			keep if lien=="1"
	
			scalar drop _all
			keep year id_men  pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut   rev_act_pens rfin_irpp_foy rfon_irpp_foy rev_tot
			order year id_men pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut   rev_act_pens rfin_irpp_foy rfon_irpp_foy rev_tot	
			* Arrondi des valeurs montaires
				foreach var of varlist pat-patfin_av {
					replace `var'=round(`var')
				}
				
save "$wfpat/wfEP98.dta",replace			
			

	* F) FIchier individuel
	
		use "`tabmen'",clear
		
		* identifiant individuel	
			sort id_men lien idnum
			gen id_indiv=_n
			sort id_men id_indiv
			drop temp ident idnum
			
		*Indicatrice de couple (presence de lien=2 dans le menage)
			bys id_men : egen marie=sum(lien=="2")
			gen pac=0
			replace pac=1 if (lien~="1" & lien~="2")
			
			keep year id_men id_indiv  pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut
			order year id_men id_indiv pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut 
		
			* Patrimoine individuel
			foreach var of varlist pat-patfin_div_mut{
				replace `var'=`var'/2 if (lien=="1" | lien=="2") & marie==1
				replace `var' =0 if (lien~="1" & lien~="2") 
			}
			
			
			* Arrondi des valeurs montaires
				foreach var of varlist pat-patfin_div_mut {
					replace `var'=round(`var')
				}
				
save "$wfpat/wfEP98_ind.dta",replace
			
	
		
						 
		
						
