/********************************************************
 Do-file used to harmonize the wealht survey 2003-2004	*
*********************************************************/


* Il existe deux versions de l'enqute patrimoine 2004 : lil0250 et lil0250b (version production et recherche
* La version production et recherche dispose de deux tables supplmentaires : montant_men et montant_prod pour lesquelles une imputation des montants de patrimoine a t faite.
	

set more off
clear

set seed 646261
local year=2004
use "$datapat/EP 03-04/Stata/individu.dta",clear
gen year=2004

		
* A) Caracteristiques socio-dmo des individus
					
	* Identifiant
		* menage : ident, individuel : identind
		rename identind idnum
	* Ponderation
		gen pondn=pond
	* age
		*age
	* age decenal
		gen aged=real(t10age)

	* lien avec la personne de reference (PR)
		* lien
	
	* nbenf de chaque individu vivant dans le menage
		bys ident : egen nbenftemppr=sum(enf=="2")
		bys ident : egen nbenftempconj=sum(enf=="3")
		bys ident : egen nbenftempcouple=sum(enf=="1")

		gen nenf=0
		replace nenf=nbenftemppr+nbenftempcouple if lien=="1" 
		replace nenf=nbenftempconj+nbenftempcouple if lien=="2" 
		drop nbenftemp*

	*Statut matrimonial
		*matri (1 : celibataire/ 2 : M/ 3 : V, 4 : D)
		gen mat="C" if matri=="1"
		replace mat="M" if matri=="2"
		replace mat="V" if matri=="3"
		replace mat="D" if matri=="4"
		replace mat="C" if matri==""
		drop matri

	* sexe (1 :M, 2 :F)
		gen sexetemp=sexe
		drop sexe
		gen sexe=0 if sexetemp=="1"
		replace sexe=1 if sexetemp=="2"
	* PCS
		* harmonisation avec enqutes DMTG
			gen pcs_ind=int(real(cs)/10)
			replace pcs_ind=9 if cs=="31"
			replace pcs_ind=8 if real(cs)==0
			replace pcs_ind=0 if pcs_ind==.
			
	keep year ident idnum sexe age aged lien nenf mat pondn pcs_ind noi
	order year ident idnum pondn sexe age aged lien nenf mat pcs_ind noi
	
	* Merge avec table menage
		merge m:m ident using "$datapat/EP 03-04/Stata/menage.dta", keepusing(rmaut revactfi rmfonc rminter rminter hodnb rmtra) force
		drop _merge
		
	* Nbre d'enfants = nbre d'enfants dans le mnage + nbre d'enfans hors domicile
			replace nenf=nenf+hodnb if lien=="1" | lien=="2"
			gen nenf01=0
			replace nenf01=1 if nenf>0
			drop hodnb
		
	* Income at the household level
		
		* Financial income
			gen uni=uniform()
			gen rfin_irpp_foy = 0
			/* rmaut : "autres revenus" : on double donc avec l'info sur la perception de revenus financiers */
			replace rfin_irpp_foy = uni*750 if /*rmaut=="01" &*/ revactfi=="1" /*sans condition sur remaut, on alloue un petit montant  ceux qui ont dclar percevoir des revenus financiers mais n'ont pas dclar les montants*/
			replace rfin_irpp_foy = (2500-1500)/2 if rmaut=="02" & revactfi=="1"
			replace rfin_irpp_foy = (5000-2500)/2 if rmaut=="03" & revactfi=="1"
			replace rfin_irpp_foy = (9500-5000)/2 if rmaut=="04" & revactfi=="1"
			replace rfin_irpp_foy = (20000-9500)/2 if rmaut=="05" & revactfi=="1"
			*Pareto de coeff 2 pour la dernire
			replace rfin_irpp_foy=20000*(uni^(-1/2)) if (rmaut=="06" & revactfi=="1")   
			drop uni
			
		* Rental income
			gen uni=uniform()
			gen rfon_irpp_foy = 0
			replace rfon_irpp_foy = uni*1500 if rmfonc=="01"
			replace rfon_irpp_foy = 3000+uni*(7500-3000) if rmfonc=="02" 
			replace rfon_irpp_foy = 7500+uni*(15000-7500) if rmfonc=="03" 
			replace rfon_irpp_foy = 15000+uni*(30000-15000) if rmfonc=="04" 
			*Pareto de coeff 2 pour la dernire
			replace rfon_irpp_foy=30000*(uni^(-1/2)) if (rmfonc=="05")   
			drop uni
		
		* Labor income: wages+self-employed income+pensions 
			gen uni=uniform()
			gen rev_act_pens = 0
			replace rev_act_pens = uni*1250 if rminter=="01"
			replace rev_act_pens = 2500+uni*(5000-2500) if rminter=="02"
			replace rev_act_pens = 5000+uni*(7500-5000) if rminter=="03" 
			replace rev_act_pens = 7500+uni*(9500-7500) if rminter=="04" 
			replace rev_act_pens = 9500+uni*(12000-9500) if rminter=="05" 
			replace rev_act_pens = 12000+uni*(14500-12000) if rminter=="06" 
			replace rev_act_pens = 14500+uni*(20000-14500) if rminter=="07" 
			replace rev_act_pens = 20000+uni*(25000-20000) if rminter=="08" 
			replace rev_act_pens = 25000+uni*(30000-25000) if rminter=="09" 
			replace rev_act_pens = 30000+uni*(36000-30000) if rminter=="10" 
			replace rev_act_pens = 36000+uni*(48000-36000) if rminter=="11" 
			replace rev_act_pens = 48000+uni*(72000-48000) if rminter=="12" 
			*Pareto de coeff 2 pour la dernire
			replace rev_act_pens=72000*(uni^(-1/2)) if (rminter=="13")   
			drop uni
			
		* Total income
			gen uni=uniform()
			gen rev_tot = 0
			replace rev_tot = uni*200 if rmtra=="02"
			replace rev_tot = 200+uni*(400-200) if rmtra=="03"
			replace rev_tot = 400+uni*(600-400) if rmtra=="04" 
			replace rev_tot = 600+uni*(800-600) if rmtra=="05" 
			replace rev_tot = 800+uni*(1000-800) if rmtra=="06" 
			replace rev_tot = 1000+uni*(1200-1000) if rmtra=="07" 
			replace rev_tot = 1200+uni*(1500-1200) if rmtra=="08" 
			replace rev_tot = 1500+uni*(2000-1500) if rmtra=="09" 
			replace rev_tot = 2000+uni*(2500-2000) if rmtra=="10" 
			replace rev_tot = 2500+uni*(3000-2500) if rmtra=="11" 
			replace rev_tot = 3000+uni*(4000-3000) if rmtra=="12" 
			replace rev_tot = 4000+uni*(6000-4000) if rmtra=="13" 
			*Pareto de coeff 2 pour la dernire
			replace rev_tot=6000*(uni^(-1/2)) if (rmtra=="14")   
			replace rev_tot=rev_tot*12
			drop uni
			* Non response
			replace rev_tot=rev_act_pens+rfon_irpp_foy+rfin_irpp_foy if rev_tot==0
			
* B) Caractristiques du patrimoine des invidus	

	* Au niveau mnage : 
			* patsom : Montant de patrimoine total menage = PATIMM (patrimoine immobilier)+PATFISOM (patrimoine fi)+PATPROFNX + valact1 + valact2
			
	
	merge m:m ident using "$datapat/EP 03-04/Stata/montant_men.dta",keepusing(patimm patfisom patprofnx patsom valact*)
	drop _merge
	foreach var of varlist patimm patfisom patprofnx patsom valact* {
		replace `var'=0 if `var'==.
	}
	keep year-pcs_ind rev_act_pens rfin_irpp_foy rfon_irpp_foy rev_tot  nenf01 patimm patfisom patprofnx patsom noi valact* 


tempfile temp
save "`temp'",replace
							
	* Wealth composition :
	
		* Financial assets:
			* patfin_div: Equities and mutual funds 
			* patfin_int: Bonds and loans 
			* patfin_liqu: Deposits and savings accounts
			* patfin_av: Life insurance and pension funds	
				
		 * Non-Financial assets:
			* patfon_owner: Owner-occupied housing assets
			* patfon_rent: Tenant-occupied housing assets
			* patpro: Business assets
			
	
	
		* Financial assets
			use ident identprod identpos nature finna logna natemp detqua kdu montcla parmen parhm using "$datapat/EP 03-04/Stata/produit.dta" ,clear 
			merge m:m identprod using "$datapat/EP 03-04/Stata/montant_prod.dta"
			drop if _merge==2 /* Une observation de moins de 5000 euros */
			drop _merge
			destring nature, replace
			destring finna,replace
			destring logna,replace
			destring natemp,replace
			destring detqua,replace


	* Table par produits classs en fonction de nature puis dcompos en sous-catgorie (fina, logna...) 
	* Le montant est disponible dans la table montant_prod = mt_simul
					
		/* Code nature du produit
				1 Actif financier
				2 Actif immobilier
				3 Terre ou autre bien professionnel non exploit professionnellement par le mnage
				4 Terre ou autre bien professionnel exploit professionnellement par le mnage
				5 Prt
				6 Endettement
			
			fina
				01. Compte-chques
				02. Livret A
				03. Livret bleu
				04. CODEVI
				05. LEP
				06. Livret Jeune
				07. Livret soumis  limpt
				08. PEL
				09. CEL
				10. pargne salariale sous forme dargent plac sur un compte courant bloqu
				11. pargne salariale sous forme de titres de lentreprise
				12. pargne salariale sous forme de parts de Sicav ou FCPE
				13. pargne salariale non prcise
				14. PEP
				15. Retraite surcomplmentaire
				16. Retraite complmentaire volontaire
				17. Assurance-vie
				18. Bon de capitalisation
				19. PEA
				20. Actions cotes (hors PEA)
				21. Actions non cotes de rapport
				22. Obligations
				23. Sicav ou FCP (hors PEA)
				24. Parts sociales de banque
				25. Parts de SCPI
				26. Valeurs mobilires non prcises
				27. Bon (autre que capitalisation)
				28. Compte  terme
				29. Compte courant dassoci
				30. Livret dpargne en entreprise
				31. Produits divers
			*/
			
		* Financial assets (diffrent pour chaque individu)
				replace mtsimul=0 if mtsimul==. & nature==1
				
				* Deposits and savings accounts: 
					* Placement  vue et numraire (AF21+AF22+AF291)
					gen patfin_liqu=mtsimul if finna<=7   | finna==9 
					* incl. Deposits (Compte cheque dans patfin_liqu (AF21+AF22))
						gen ccheque=mtsimul if finna==1
						
				* Bonds, loans: 
					* Placement  chance (AF292), pargne contractuelle (AF293), Obligations (AF3) titres de creances (AF4) 
					gen patfin_int=mtsimul if  finna==8  | finna==10 | finna==13 | finna==14  | finna==22 | (finna>=26 & finna<=31)  
				
				* Equities and investment fund shares
					gen patfin_div=mtsimul if finna==11 | finna==12 | finna==19 | finna==20 | finna==21 | finna==23 | finna==24 | finna==25   
					* incl. Mututal funds (AF52)
						gen patfin_div_mut=mtsimul if finna==12 | finna==23 | finna==25
					* incl. private equities (AF512+AF519)
						gen patfin_div_priv=mtsimul if finna==21 | finna==24 
					* incl. public equities (AF511)
						gen patfin_div_pub=mtsimul if finna==11 | finna==19 | finna==20 
				
				* Life insurance and pension funds	
					gen patfin_av = mtsimul if finna==15 | finna==16 | finna==17 | finna==18
			
				
		* Actifs financiers au niveau du mnage : patfisom
				
		* Endettement prof et person au niveau du mnage (kdu : capital restant d. On utilise montcla (endettement avant remboursement quand kdu =999999999)
				* Reclassmeent de certains emprunts non reports dans natemp en endettement prof ou endettement priv
					replace natemp=5 if nature==6 & natemp==. & detqua>=7 & detqua~=.
					replace natemp=1 if nature==6 & natemp==. & detqua<7 & detqua~=.
				
				gen passif=kdu if kdu <=999999997 & nature==6
				replace passif=montcla if montcla <= 999999997 & kdu >999999997 & nature==6 & passif==.
				replace passif= 0 if passif==.
				
				gen passpers=passif  if nature==6 & natemp<=4 
				gen passprof=passif if nature==6 & natemp>4 
				replace passpers=0 if passpers==.
				replace passprof=0 if passprof==.
		 * owner-occupied housing assets 		
			* Debts on owner-occupied housing 
				gen passif_owner=kdu if kdu <=999999997 & nature==6 & detqua==1
				replace passif_owner=montcla if montcla <= 999999997 & kdu >999999997 & nature==6 & passif_owner==. & detqua==1
				replace passif_owner=0 if passif_owner<0 | passif_owner==.
			* owner-occupied housing assets 
				gen patfon_owner=mtsimul*(1-parhm) if logna==1
				replace patfon_owner=mtsimul if logna==1 & parhm==.
				replace patfon_owner=0 if  patfon_owner<0 | patfon_owner==.
		
		foreach var of varlist patfin_liqu-patfon_owner  {
			replace `var'=0 if `var'==.
		}
					
		* dtenteur de l'actif ou du passif
			gen noi=substr(identpos,-2,2)
			replace noi="00" if noi=="ME"
			
			collapse (sum)patfin_liqu-patfon_owner  ,by(ident noi)
			merge 1:m ident noi using "`temp'"
			
			foreach var of varlist patfin_liqu-patfon_owner   {
				replace `var'=0 if _merge==2
			}
		

		* Reclassement des actifs de la table produit dtenue au niveau mnage
			bys ident : egen pac_adult=sum((lien=="3")*(age>=20 & age<=26))
			replace pac_adult=1 if pac_adult>1
			bys ident : egen patfin_liqu_pac=sum(patfin_liqu*(lien=="3")*(age>=20 & age<=26))
			foreach var of varlist patfin_liqu-patfon_owner  {
				bys ident : egen `var'_men=sum(`var')
				drop `var'
				rename `var'_men `var'
			}
							
			drop if noi=="00"
			drop _merge noi
			
		* Business assets: patprofnx+valacti1+valacti2+valacti3 (Household level)
			gen patpro=patprofnx+valacti1+valacti2+valacti3
			replace patpro=0 if patpro<0

		* Total Financial assets
			gen patfin= patfin_liqu+ patfin_int+patfin_div+patfin_av					
			/* verif
				gen temp=patfin-patfisom
				sum temp,d
				drop temp */
		
		* Housing assets 
			gen patfon=patimm
			gen patfon_rent=patfon-patfon_owner
				
		* Passif
			replace passif_owner=min(passif_owner,patfon_owner)
			gen temp=patfin+patfon
			replace passif=min(passpers,temp)
			replace passprof=min(passprof, patpro)
			replace patpro=patpro-passprof
			gen pat=patfon+patfin+patpro-passif	
			drop temp 
			
			
			/* Module verif 
				* Comparaison patrimoine brut patrimoine avec somme des composantes du patrimoine: c'est bon
					gen diff =patpro+passprof+patfon+patfin-patsom
					sum diff,d 
					drop diff
	*/

* C) Retraitement de la population 
					
		* Suppression des moins de 20 ans qui ne sont pas la personne de rfrence ou le conjoint ou qui sont seuls dans le mnage ou qui sont en mnage avec des moins de 20 ans
			gen prob=1 if (lien=="1" | lien=="2") &(aged<=2)
			bys ident : egen probis=sum(prob==1)
			replace probis=1 if probis~=0
			*bys ident : egen verif=sum(aged>2)
			drop if (aged <=2 & prob~=1)
			drop prob probis 
			replace age=20 if age<20
			replace aged=3 if aged==2
		
		/* Retraitement des pondrations
			quiet sum pondn
			replace pondn=pondn*${pondn`year'}*1000/r(sum) */
				
		* Attribution d'un nouvel identifiant mnage
			sort ident lien
			gen temp=1 if lien=="1"
			replace temp=0 if temp==.
			gen id_men=sum(temp)
			

* E) Sauvergarde du fichier mnage
		tempfile tabmen
		save "`tabmen'",replace
		keep if lien=="1"
		
		scalar drop _all
		keep year  id_men pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif  patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av patfin_liqu_pac ccheque patfin_div_pub patfin_div_priv patfin_div_mut rev_act_pens rfin_irpp_foy rfon_irpp_foy rev_tot pac_adult
		order year id_men pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif  patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av patfin_liqu_pac ccheque patfin_div_pub patfin_div_priv patfin_div_mut rev_act_pens rfin_irpp_foy rfon_irpp_foy rev_tot pac_adult
			
		* Arrondi des valeurs montaires
			foreach var of varlist pat-rfon_irpp_foy {
				replace `var'=round(`var')
			}
				
				
save "$wfpat/wfEP04.dta",replace

* E) FIchier individuel
	
		use "`tabmen'",clear
		
		* identifiant individuel	
			sort id_men lien idnum
			gen id_indiv=_n
			sort id_men id_indiv
			drop temp ident idnum
			
		*Indicatrice de couple (presence de lien=2 dans le menage)
			bys id_men : egen marie=sum(lien=="2")
			gen pac=0
			replace pac=1 if (lien~="1" & lien~="2")
			
			keep year id_men id_indiv pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind  pat passif  patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut
			order year id_men id_indiv pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind pat passif  patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut
	
		* Patrimoine individuel
			foreach var of varlist pat-patfin_div_mut {
				replace `var'=`var'/2 if (lien=="1" | lien=="2") & marie==1
				replace `var' =0 if (lien~="1" & lien~="2") 
			}
			
			* Arrondi des valeurs montaires
				foreach var of varlist pat-patfin_div_mut {
					replace `var'=round(`var')
				}
				
save "$wfpat/wfEP04_ind.dta",replace
			
