**************************************************
* Do file used to imputa life insurance assets	*
**************************************************


* I) Importation of parameters 
********************************

	* Wealth and its components from National Accounts 
		import excel using "$resultsDMTG/RawResults_ApD.xlsx",first clear sheet("stataDMTG") cellrange(A4:N31) 
		gen patfon_netNA=patfon_owner_netNA +patfon_rent_netNA
		gen patNA=patfin_liquNA	+patfon_netNA +	patfin_avNA+	patfin_divNA+	patfin_intNA+	patproNA
		* Transform all parameters into global 
			foreach num of numlist 1984 1987 1994 2000 2006 2010 {
				foreach var of varlist patfin_avNA patNA  {
					quiet sum `var' if year==`num'
					global `var'`num'=r(mean)
				}
			}


* II) Imputation    
*********************
	* Imputation of life insurance only made for the top 50% because the bottom 50% wealth and its components was already imputed at the previous step (doimputnontafiler)

foreach year of global yearlistdmtg {
global year=`year'
	foreach onglet of newlist diff olddiff sansdiff {
	global onglet="`onglet'"	
	set seed 1942354
	
	* 1) Load the data
	**********************
		use "$wfDMTG/wealthwithntf/wfwealthntf${year}${onglet}.dta",clear
		* Bottom 50% wealth in DMTG living already imputed
			*py_${onglet}
			
			
		* Expand 
			expand 10 if py_${onglet}   == 0
			replace pondn${onglet}=pondn${onglet}/10 if py_${onglet}   == 0 
			
		* New identifier
			sort year idsucc
			gen a =1
			bys year : gen idindiv=sum(a)
			drop a

	* 2) Variables used for imputations
	**************************************

		* Tangible assets
			gen pat_reel=patfon_net +patpro

		* Financial assets excl. life insurance 
			gen patfitemp= patfin_div +patfin_int +patfin_liqu

		* Age groups
			gen q_age_pr = 2
			replace q_age_pr = 3 if age >=40
			replace q_age_pr = 4 if age >=50
			replace q_age_pr = 5 if age >=60
			replace q_age_pr = 6 if age >=70

		* Age.groups of financial assets
			sort year q_age_pr patfitemp
			gen pondvr=round(10000*pondn${onglet}) 
			bys year q_age_pr : cumul patfitemp [w=pondvr], gen (p100)
			replace p100=p100*100
			gen q_age_fin   = 0
			replace q_age_fin= 50   if p100 >=50 & p100 <75 & q_age_fin==0
			replace q_age_fin= 75   if p100 >=75 & p100 <90 & q_age_fin==0
			replace q_age_fin= 90   if p100 >=90 & p100 <95 & q_age_fin==0
			replace q_age_fin= 95   if p100 >=95 & p100 <99 & q_age_fin==0
			replace q_age_fin= 99   if p100 >=99 & q_age_fin==0
			drop p100 pondvr
				
		* Age.groups of financial assets. groups of tangible assets
			sort year q_age_pr q_age_fin pat_reel
			gen pondvr=round(10000*pondn${onglet}) 
			bys year q_age_pr q_age_fin : cumul pat_reel [w=pondvr], gen (p100)
			replace p100=p100*100
			gen q_age_fin_immo  = 0
			replace q_age_fin_immo=25  if p100 >=25 & p100 <50 & q_age_fin_immo==0
			replace q_age_fin_immo= 50   if p100 >=50 & p100 <75 & q_age_fin_immo==0
			replace q_age_fin_immo= 75   if p100 >=75 & p100 <90 & q_age_fin_immo==0
			replace q_age_fin_immo= 90   if p100 >=90 & p100 <100 & q_age_fin_immo==0
			* Adjusments
				* for the top 5% of financial assets (not enough observation to split into groups of tangible asset)
				replace q_age_fin_immo= 0   if q_age_fin== 95 | q_age_fin== 99
			drop p100  pondvr
							
	* 2) Merge imputations parameters of each groups
	***************************************************		
		if ${year}<1992 {
			tempfile temp
			save "`temp'"
			use "$param/clef_life_DMTG.dta",clear
			keep if year==1992
			drop year
			tempfile cleftemp
			save "`cleftemp'",replace
			use "`temp'",clear
			merge m:1 q_age_pr q_age_fin q_age_fin_immo using "`cleftemp'"
			erase "`cleftemp'"
			erase "`temp'"
		}
		
		if (${year}>=1992) {
			merge m:1 year q_age_pr q_age_fin q_age_fin_immo using "$param/clef_life_DMTG.dta"
		}			
		drop if _merge==2
		drop pat_reel patfitemp _merge
			
	* 3) Imputation of life insurance
	*************************************
		gen group=10000*q_age_pr+100* q_age_fin +q_age_fin_immo
		replace patfin_av=0 if py_${onglet}==0
		gen owner_avie=0
		* Amount of life insurance to impute to top 50
			bys year : egen patfin_avNA=sum(patfin_av*pondn${onglet})
			replace patfin_avNA=${patfin_avNA${year}}*1000000000-patfin_avNA
		
		* Extensive margin: life-insurance ownership	
			sort year idindiv
			bys year group: gen uni=runiform()
			gen pondvr=round(10000*pondn${onglet}) 
			sort year group uni
			bys year group : cumul uni [w=pondvr], gen (p100)			
			replace owner_avie=1 if prop_avie>=p100
			* life insurance detention
				/*verif
				bys year group : egen tot=sum(pondn${onglet})
				bys year group : egen verif=sum(owner_avie*pondn${onglet}/tot)
				gen diff=verif-prop_avie
				drop tot diff verif
				*/
		* Intensive margin: Amount of life insurance assets
			bys year group : egen pondtemp=sum(pondn${onglet}) if owner_avie==1
			replace patfin_av=share_avie*patfin_avNA/100/pondtemp if owner_avie==1 & py_${onglet}==0	
			sum patfin_av [aw=pondn${onglet}] if py_${onglet}==0
			replace patfin_av=patfin_av*patfin_avNA/r(sum) if py_${onglet}==0
		drop q_age_pr q_age_fin q_age_fin_immo prop_avie share_avie patfin_avNA group uni pondvr p100 owner_avie  pondtemp 
	
		replace patfin=patfin_div +patfin_int +patfin_liqu+ patfin_av
		replace pat=patpro +patfin +patfon_net
						

		order year idindiv
		save "$wfDMTG/wealthwithavie/wfwealth${year}avie${onglet}.dta",replace
		

	}		
}
macro drop patfin_avNA* patNA* onglet
		
						
						
	
