**********************************************
* Wealth share and wealth composition (DMTG) *
**********************************************

* I)  Wealth share without adjustment but consistent demo structure
* II) Wealth share with imputation of non-tax filer wealth
* III)Wealth share with imputation of non-tax filer wealth + imputation of life insurance
* IV) Wealth share with imputation of non-tax filer wealth + imputation of life insurance + consistent with NA
* V)  Aggregate composition of wealth 
* VI) Composition of wealth by groups (bottom90, top10-1, top1-0.1, top01) with new mortality parameters (diff)
* VII)Number of observations and sampling rates (total and for each wealth groups)
		
* I) Wealth share without any adjustment depending on different differential mortality paramaters
*****************************************************************************************************
	* Local pour exportations sur xls
		local linea = 0
		local lineb = 4
		
	foreach year of global yearlistdmtg {
				
		if `year'==2006 {
			local lineb=8
		}		
		global year=`year'

		foreach type of newlist dec sansdiff olddiff diff {
			use "$wfDMTG/wealth/wfwealth${year}.dta",clear
	
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				egen patmin10=max(pat*(p10<=10))
				drop p10 p100 pondvr			
			* Wealth share and threshold and other stats (total population, fraction of tax filer, average wealth)
				gen patmin=pat
				foreach var of varlist pat  {
					replace `var'=`var'*pondn`type'
				}
				gen pop_decl=pondn`type'*(idsucc<10000)
				collapse (sum) pat pondn`type' pop_decl (min) patmin patmin10 ,by(year py)
				bys year : egen tot=sum(pat)
				bys year : egen pop=sum(pondn`type')
				bys year : egen frac_decl=sum(pop_decl/pop)
				gen patmean=tot/pop
				foreach var of varlist pat  {
					replace `var' =`var'/tot
				}
				drop tot pondn`type' pop_decl
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				reshape wide pat patmin , i(year) j(py) string
				foreach var of newlist pat  {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				
				order year pop frac_decl patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01     
				keep year pop frac_decl patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01      
				local line=`linea'*10+`lineb'
				dis $year
				dis `line'
				export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("exportdmtg")  sheetmodify cell(B`line') 	
				local linea = `linea'+1				
		}		
			local linea = 0
			local lineb=`lineb'+1
		}
	
* II) Wealth share with with non-tax filer wealth imputation
**************************************************************
	* Local pour exportations sur xls
		local linea = 1
		local lineb = 4
		
	foreach year of global yearlistdmtg {				
		if `year'==2006 {
			local lineb=8
		}		
		global year=`year'
		foreach type of newlist sansdiff olddiff diff {
			use "$wfDMTG/wealthwithntf/wfwealthntf${year}`type'.dta",clear
			
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				egen patmin10=max(pat*(p10<=10))
				drop p10 p100 pondvr			

			* Wealth share and threshold and other stats (total population, fraction of tax filer, average wealth)
				gen patmin=pat
				foreach var of varlist pat  {
					replace `var'=`var'*pondn`type'
				}
				gen pop_decl=pondn`type'*(idsucc<10000)
				
				collapse (sum) pat pondn`type' pop_decl (min) patmin patmin10 ,by(year py)
				bys year : egen tot=sum(pat)
				bys year : egen pop=sum(pondn`type')
				bys year : egen frac_decl=sum(pop_decl/pop)
				gen patmean=tot/pop
				foreach var of varlist pat  {
					replace `var' =`var'/tot
				}
				drop tot pondn`type' pop_decl
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				reshape wide pat patmin , i(year) j(py) string
				foreach var of newlist pat  {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				
				order  patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01     
				keep  patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01      
				local line=`linea'*10+`lineb'
				export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("exportdmtg")  sheetmodify cell(S`line') 	
				local linea = `linea'+1
				
		}
			local linea = 1
			local lineb=`lineb'+1
		}
						
			
			
			
			
* III) Wealth share with ntf wealth and life insurance
***********************************************************************
	* Local pour exportations sur xls
		local linea = 1
		local lineb = 4
		
	foreach year of global yearlistdmtg {			
		if `year'==2006 {
			local lineb=8
		}		
		global year=`year'
		foreach type of newlist sansdiff olddiff diff {
			use "$wfDMTG/wealthwithavie/wfwealth${year}avie`type'.dta",clear
		
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				egen patmin10=max(pat*(p10<=10))
				drop p10 p100 pondvr			

			* Wealth share and threshold and other stats (total population, fraction of tax filer, average wealth)
				gen patmin=pat
				foreach var of varlist pat  {
					replace `var'=`var'*pondn`type'
				}
				gen pop_decl=pondn`type'*(idsucc<10000)
				
				collapse (sum) pat pondn`type' pop_decl (min) patmin patmin10 ,by(year py)
				bys year : egen tot=sum(pat)
				bys year : egen pop=sum(pondn`type')
				bys year : egen frac_decl=sum(pop_decl/pop)
				gen patmean=tot/pop
				foreach var of varlist pat  {
					replace `var' =`var'/tot
				}
				drop tot pondn`type' pop_decl
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				reshape wide pat patmin , i(year) j(py) string
				foreach var of newlist pat  {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				
				order  patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01     
				keep  patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01      
				local line=`linea'*10+`lineb'
				export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("exportdmtg")  sheetmodify cell(AG`line') 	
				local linea = `linea'+1
				
		}
			local linea = 1
			local lineb=`lineb'+1
		}
						

* IV) Wealth share with ntf wealth + life insurance + consitent with national accounts
****************************************************************************************
	* Local pour exportations sur xls
		local linea = 1
		local lineb = 4
		
	foreach year of global yearlistdmtg {		
		if `year'==2006 {
			local lineb=8
		}		
		global year=`year'
		foreach type of newlist sansdiff olddiff diff {
			use "$wfDMTG/wealthcn/wfwealthcn${year}`type'.dta",clear
			
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				egen patmin10=max(pat*(p10<=10))
				drop p10 p100 pondvr			

			* Wealth share and threshold and other stats (total population, fraction of tax filer, average wealth)
				gen patmin=pat
				foreach var of varlist pat  {
					replace `var'=`var'*pondn`type'
				}
				gen pop_decl=pondn`type'*(idsucc<10000)
				
				collapse (sum) pat pondn`type' pop_decl (min) patmin patmin10 ,by(year py)
				bys year : egen tot=sum(pat)
				bys year : egen pop=sum(pondn`type')
				bys year : egen frac_decl=sum(pop_decl/pop)
				gen patmean=tot/pop
				foreach var of varlist pat  {
					replace `var' =`var'/tot
				}
				drop tot pondn`type' pop_decl
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				reshape wide pat patmin , i(year) j(py) string
				foreach var of newlist pat  {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				
				order  patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01     
				keep  patmean  patbot90 pattop10 pattop1 pat01 pat50  pat40  pat9  pat09 patmin10 patmin40 patmin9 patmin09 patmin01      
				local line=`linea'*10+`lineb'
				export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("exportdmtg")  sheetmodify cell(AU`line') 	
				local linea = `linea'+1
				
		}
			local linea = 1
			local lineb=`lineb'+1
		}

		
		

* V) Aggregate composition of wealth 
***************************************
	* Sans retraitement
		local i=4
		foreach year of global yearlistdmtg {
			if `year'==2006 {
				local i=8
			}		
			local i=`i'+1
			foreach type of newlist diff olddiff sansdiff {
				use "$wfDMTG/wealth/wfwealth`year'.dta",clear
					replace patfin_int=patfin_int+patfin_liqu
					keep year  pondn`type' pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av 
					foreach var of varlist pat-patfin_av {
						replace `var'=`var'*pondn`type'/1000000000
					}
					collapse (sum) pat-patfin_av,by(year)
					dis $year
					dis "`type'"
					dis `i'
					if "`type'"=="diff" {
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(A`i') 			
					}
					if "`type'"=="olddiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(I`i') 			
					}
					if "`type'"=="sansdiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(P`i') 			
					}
			}
		}
	* Avec bottom 50
		local i=24
		foreach year of global yearlistdmtg {
			if `year'==2006 {
				local i=28
			}		
			local i=`i'+1
			foreach type of newlist diff olddiff sansdiff {
				use "$wfDMTG/wealthwithntf/wfwealthntf`year'`type'.dta",clear
					replace patfin_int=patfin_int+patfin_liqu
					keep year  pondn`type' pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av 
					foreach var of varlist pat-patfin_av {
						replace `var'=`var'*pondn`type'/1000000000
					}
					collapse (sum) pat-patfin_av,by(year)
					dis $year
					dis "`type'"
					dis `i'
					if "`type'"=="diff" {
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(A`i') 			
					}
					if "`type'"=="olddiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(I`i') 			
					}
					if "`type'"=="sansdiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(P`i') 			
					}
			}
		}

	* Avec bottom 50 et assurance-vie
		local i=44
		foreach year of global yearlistdmtg {
			if `year'==2006 {
				local i=48
			}		
			local i=`i'+1
			foreach type of newlist diff olddiff sansdiff {
				use "$wfDMTG/wealthwithavie/wfwealth`year'avie`type'.dta",clear
					replace patfin_int=patfin_int+patfin_liqu
					keep year  pondn`type' pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av 
					foreach var of varlist pat-patfin_av {
						replace `var'=`var'*pondn`type'/1000000000
					}
					collapse (sum) pat-patfin_av,by(year)
					dis $year
					dis "`type'"
					dis `i'
					if "`type'"=="diff" {
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(A`i') 			
					}
					if "`type'"=="olddiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(I`i') 			
					}
					if "`type'"=="sansdiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(P`i') 			
					}
			}
		}
	* Avec bottom 50 et assurance-vie et consistent with NA
		local i=64
		foreach year of global yearlistdmtg {
			if `year'==2006 {
				local i=68
			}		
			local i=`i'+1
			foreach type of newlist diff olddiff sansdiff {
				use "$wfDMTG/wealthcn/wfwealthcn`year'`type'.dta",clear
					replace patfin_int=patfin_int+patfin_liqu
					keep year  pondn`type' pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av 
					foreach var of varlist pat-patfin_av {
						replace `var'=`var'*pondn`type'/1000000000
					}
					collapse (sum) pat-patfin_av,by(year)
					dis $year
					dis "`type'"
					dis `i'
					if "`type'"=="diff" {
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(A`i') 			
					}
					if "`type'"=="olddiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(I`i') 			
					}
					if "`type'"=="sansdiff" {
						drop year
						export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("agregat")  sheetmodify cell(P`i') 			
					}
			}
		}

			
* VI) Composition of wealth by groups (bottom90, top10-1, top1-0.1, top01) with new mortality parameters (diff)
******************************************************************************************************************				

* Sans retraitement
	local i=5
	foreach year of global yearlistdmtg {
		global year=`year'
		if `year'==2006 {
			local i=9
		}
		local i=`i'+1
		foreach type of newlist diff {
			use "$wfDMTG/wealth/wfwealth${year}.dta",clear
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				drop p10 p100 pondvr		
				
				replace patfin_int=patfin_int+patfin_liqu
				drop patfin_liqu patfon_brut passif
				rename pondn`type' pondn
				order year pondn py  pat patfon_net   patpro patfin patfin_div patfin_int  patfin_av
				foreach var of varlist pat-patfin_av  {
					replace `var'=`var'*pondn
				}
				
				collapse (sum) pat-patfin_av ,by(year py)
				bys year : egen tot=sum(pat)
				foreach var of varlist pat-patfin_av   {
					replace `var' =`var'/tot
				}
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				order year py pat patfon_net patpro patfin patfin_div patfin_int  patfin_av
				reshape wide pat-patfin_av, i(year tot) j(py) string
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				order *50 *40 *9  ,last
				order *09 tot ,last
				order year *bot90 *top10 *top1  *01
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo")  sheetmodify cell(A`i') 			
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'_tot=`var'bot90+`var'top10
				}
				order year pat*
				order  patfon* patpro* patfin*,last
				order patfin_div* patfin_int*  patfin_av* tot,last
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo2")  sheetmodify cell(A`i') 			
		}
	}
* Avec bottom 50
	local i=15
	foreach year of global yearlistdmtg {
		global year=`year'
		if `year'==2006 {
			local i=19
		}
		local i=`i'+1
		foreach type of newlist diff {
			use "$wfDMTG/wealthwithntf/wfwealthntf`year'`type'.dta",clear
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				drop p10 p100 pondvr		
				
				replace patfin_int=patfin_int+patfin_liqu
				drop patfin_liqu patfon_brut passif
				rename pondn`type' pondn
				order year pondn py  pat patfon_net   patpro patfin patfin_div patfin_int  patfin_av
				foreach var of varlist pat-patfin_av  {
					replace `var'=`var'*pondn
				}
				
				collapse (sum) pat-patfin_av ,by(year py)
				bys year : egen tot=sum(pat)
				foreach var of varlist pat-patfin_av   {
					replace `var' =`var'/tot
				}
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				order year py pat patfon_net patpro patfin patfin_div patfin_int  patfin_av
				reshape wide pat-patfin_av, i(year tot) j(py) string
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				order *50 *40 *9  ,last
				order *09 tot ,last
				order year *bot90 *top10 *top1  *01
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo")  sheetmodify cell(A`i') 			
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'_tot=`var'bot90+`var'top10
				}
				order year pat*
				order  patfon* patpro* patfin*,last
				order patfin_div* patfin_int*  patfin_av* tot,last
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo2")  sheetmodify cell(A`i') 			
		}
	}
	dis $year
* Avec bottom 50 + life insurance
	local i=25
	foreach year of global yearlistdmtg {
		global year=`year'
		if `year'==2006 {
			local i=29
		}
		local i=`i'+1
		foreach type of newlist diff {
			use "$wfDMTG/wealthwithavie/wfwealth`year'avie`type'.dta",clear
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				drop p10 p100 pondvr		
				
				replace patfin_int=patfin_int+patfin_liqu
				drop patfin_liqu patfon_brut passif
				rename pondn`type' pondn
				order year pondn py  pat patfon_net   patpro patfin patfin_div patfin_int  patfin_av
				foreach var of varlist pat-patfin_av  {
					replace `var'=`var'*pondn
				}
				
				collapse (sum) pat-patfin_av ,by(year py)
				bys year : egen tot=sum(pat)
				foreach var of varlist pat-patfin_av   {
					replace `var' =`var'/tot
				}
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				order year py pat patfon_net patpro patfin patfin_div patfin_int  patfin_av
				reshape wide pat-patfin_av, i(year tot) j(py) string
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				order *50 *40 *9  ,last
				order *09 tot ,last
				order year *bot90 *top10 *top1  *01
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo")  sheetmodify cell(A`i') 			
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'_tot=`var'bot90+`var'top10
				}
				order year pat*
				order  patfon* patpro* patfin*,last
				order patfin_div* patfin_int*  patfin_av* tot,last
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo2")  sheetmodify cell(A`i') 			
		}
	}
	
* Avec bottom 50 + life insurance + consistent with NA
	local i=35
	foreach year of global yearlistdmtg {
		global year=`year'
		if `year'==2006 {
			local i=39
		}
		local i=`i'+1
		foreach type of newlist diff {
			use "$wfDMTG/wealthcn/wfwealthcn`year'`type'.dta",clear
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				sort year pat
				gen pondvr=round(10000*pondn`type') 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				drop p10 p100 pondvr		
				
				replace patfin_int=patfin_int+patfin_liqu
				drop patfin_liqu 
				rename pondn`type' pondn
				order year pondn py  pat patfon_net   patpro patfin patfin_div patfin_int  patfin_av
				foreach var of varlist pat-patfin_av  {
					replace `var'=`var'*pondn
				}
				
				collapse (sum) pat-patfin_av ,by(year py)
				bys year : egen tot=sum(pat)
				foreach var of varlist pat-patfin_av   {
					replace `var' =`var'/tot
				}
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				order year py pat patfon_net patpro patfin patfin_div patfin_int  patfin_av
				reshape wide pat-patfin_av, i(year tot) j(py) string
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'bot90=`var'50+`var'40
					gen `var'top1=`var'09+`var'01
					gen `var'top10=`var'top1+`var'9
				}
				order *50 *40 *9  ,last
				order *09 tot ,last
				order year *bot90 *top10 *top1  *01
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo")  sheetmodify cell(A`i') 			
				dis $year
				foreach var of newlist pat patfon_net  patpro patfin patfin_div patfin_int  patfin_av {
					gen `var'_tot=`var'bot90+`var'top10
				}
				order year pat*
				order  patfon* patpro* patfin*,last
				order patfin_div* patfin_int*  patfin_av* tot,last
				export 	excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statawealthcompo2")  sheetmodify cell(A`i') 			
		}
	}
	
* VII) Number of observations and sampling rates (total and for each wealth groups)
*************************************************************************************		
* Local pour exportations sur xls
		local linea = 4
		local lineb = 4
		
	foreach year of global yearlistdmtg {		
		if `year'==2006 {
			local lineb=8
		}		
		global year=`year'
		foreach type of newlist dec sansdiff olddiff diff {
			use "$wfDMTG/wealth/wfwealth${year}.dta",clear	
			rename pondn`type' temppondn
			drop pond*
			rename temppondn pondn
			
			* Groupe de richesse
				* dec : defunts, sans diff : vivants sans differential mortality, olddiff : old diff mort, diff : diff mort
				
				sort year pat idsucc
				gen pondvr=round(10000*pondn) 
				bys year : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9  & py==0
				drop p10 p100 pondvr
				
				bys year : egen pop=sum(pondn)
				replace age=age*pondn
				bys year : egen agemean=sum(age)
				replace agemean=agemean/pop
				sort year py pat idsucc
				gen obs=0
				replace obs=1 if _n==1 | idsucc[_n]~=idsucc[_n-1] 
				bys year : egen obstot=sum(obs)
				* Pour le nombre d'observations par groupe on doit ajouter la condition supplementaire: & py[_n]~=py[_n-1])
				replace obs=1 if _n==1 | idsucc[_n]~=idsucc[_n-1] | (idsucc[_n]==idsucc[_n-1] & py[_n]~=py[_n-1])

				collapse (mean) obstot agemean pop (sum) obs age pondn   ,by(year py)
				replace age=age/pondn	
				gen py2= string(py)
				drop py
				rename py2 py
				replace py="40" if py=="50"
				replace py="50" if py=="0"
				replace py="9" if py=="90"
				replace py="09" if py=="99"
				replace py="01" if py=="999"
				reshape wide obs age pondn , i(year) j(py) string
				order year pop pondn50 pondn40 pondn9 pondn09 pondn01 obstot obs50 obs40 obs9 obs09 obs01 agemean age50 age40 age9 age09 age01				
				local line=`linea'*10+`lineb'
				dis $year
				dis `line'
				export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("exportdmtg")  sheetmodify cell(B`line') 	
				local linea = `linea'+1
				
		}	
		
			local linea = 4
			local lineb=`lineb'+1
		}
			
/*
* VIII) Mu ratio
******************

local i=3
foreach year of global yearlistdmtg {
	global year=`year'
	if ${year}==2006{
		local i=7
	}
	local i=`i'+1
	foreach wgt of newlist sansdiff olddiff diff {
		use "$wfDMTG/wealth/wfwealth${year}.dta",clear
		gen living =pat*pondn`wgt'
		gen decedent=pat*pondndec
		collapse (sum) living decedent pondn`wgt' pondndec
		gen tx_mort=pondndec/pondn`wgt'
		gen mu`wgt'= decedent/(living*tx_mort)
		keep mu`wgt'
		dis `i'
		dis "`wgt'"
		if "`wgt'"=="sansdiff" {
			export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("muratio")  sheetmodify cell(C`i') 
		}
		if "`wgt'"=="olddiff" {
			export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("muratio")  sheetmodify cell(D`i') 
		}
		if "`wgt'"=="diff" {
			export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("muratio")  sheetmodify cell(E`i') 
		}
		
	}
}
*/
