*******************************************************************************************************
* Do-file used to impute life insurance in estate multiplier approach based on wealth wealth surveys  *
*******************************************************************************************************

* Imputation based on age groups.groups of financial assets.groups of tangible assets



* I) Organize the data
***************************

	* Load the data
		use "$wfpat/wfEP04.dta",clear
		append using "$wfpat/wfEP10.dta"
		append using "$wfpat/wfEP98.dta"
		append using "$wfpat/wfEP92.dta"

	* Variables used for imputations
		
		* Tangible assets
			gen pat_reel=max(patfon+ patpro - passif,0)

		* Financial assets excl. life insurance 
			drop patfin
			gen patfi= patfin_div+ patfin_int+ patfin_liqu
		
		* Age groups
			capture drop q_age_pr
			gen q_age_pr = 2
			replace q_age_pr = 3 if age >=40
			replace q_age_pr = 4 if age >=50
			replace q_age_pr = 5 if age >=60
			replace q_age_pr = 6 if age >=70
			tab q_age_pr

		* Age.groups of financial assets
			sort year q_age_pr patfi
			gen u=uniform()
			replace patfi=u if patfi==0
			
			gen pondvr=round(100*pondn) 
			bys year q_age_pr : cumul patfi [w=pondvr], gen (p100)
			replace p100=p100*100
			gen q_age_fin   = 0
			replace q_age_fin= 50   if p100 >=50 & p100 <75 & q_age_fin==0
			replace q_age_fin= 75   if p100 >=75 & p100 <90 & q_age_fin==0
			replace q_age_fin= 90   if p100 >=90 & p100 <95 & q_age_fin==0
			replace q_age_fin= 95   if p100 >=95 & p100 <99 & q_age_fin==0
			replace q_age_fin= 99   if p100 >=99 & q_age_fin==0
			drop p100 pondvr u
		
		* Age.groups of financial assets. groups of tangible assets
			sort year q_age_pr q_age_fin pat_reel
			gen u=uniform()
			replace pat_reel=u if pat_reel==0
			
			gen pondvr=round(100*pondn) 
			bys year q_age_pr q_age_fin : cumul pat_reel [w=pondvr], gen (p100)
			replace p100=p100*100
			gen q_age_fin_immo  = 0
			replace q_age_fin_immo=25  if p100 >=25 & p100 <50 & q_age_fin_immo==0
			replace q_age_fin_immo= 50   if p100 >=50 & p100 <75 & q_age_fin_immo==0
			replace q_age_fin_immo= 75   if p100 >=75 & p100 <90 & q_age_fin_immo==0
			replace q_age_fin_immo= 90   if p100 >=90 & p100 <100 & q_age_fin_immo==0
			* Adjusments
				* for the top 5% of financial assets (not enough observation to split into groups of tangible asset)
				replace q_age_fin_immo= 0   if q_age_fin== 95 | q_age_fin== 99
			drop p100  pondvr u	
				
	
* II) Statistics for the imputation
*************************************

	* Proportion of life insurance owner
		gen prop_avie =0 
		replace prop_avie =pondn if patfin_av>0
		
	* Weighted amounts
		replace patfin_av=patfin_av*pondn
		
	bys year q_age_pr q_age_fin q_age_fin_immo : egen tot=sum(pondn)
	gen a =1
	bys year q_age_pr q_age_fin q_age_fin_immo : egen obs=sum(a)
	drop a
	collapse (sum)  patfin_av prop_avie (mean) obs tot,by(year q_age_pr q_age_fin q_age_fin_immo)
	
	* Proportion of life insurance owner by groups
		replace prop_avie=prop_avie/tot
	
	* Share of total life insurance assets accruing to each group
		bys year :egen patfin_av_tot=sum(patfin_av) 
		gen share_avie=100*patfin_av/patfin_av_tot
	
	/* To see average life insurance assets for the owners by groups 	
		replace patfin_av=patfin_av/tot/prop_avie  if prop_avie~=0
		drop tot  */
		
	keep year q* share* prop* share*
	
* III) Harmonization and correction
*************************************
	tempfile base
	save "`base'",replace
	
	* Interpolation for missing years
		
		* Add missing years
		keep if year==1998
		foreach var of varlist year prop_avie share_avie  {
			replace `var'=.
		}
		tempfile temp
		save "`temp'",replace
		use "`base'",clear
		foreach num of numlist 1993/1997 1999/2003 2005/2009 {
			append using "`temp'"
			replace year=`num' if year==.
		}
		sort year
		
		* Years 1992, 1998, 2004 and 2010
		erase "`temp'"
		erase "`base'"
		tempfile newbase
		save "`newbase'",replace
		tempfile temp
		save "`temp'",replace
		foreach num of numlist 1992 1998 2004 2010 {
			use "`temp'",clear
			keep if year==`num'
			foreach var of varlist prop_avie share_avie {
				rename `var' `var'`num'
			}
			drop year
			merge m:m q_age_pr q_age_fin q_age_fin_immo using "`newbase'"
			drop _merge
			erase "`newbase'"
			tempfile newbase
			save "`newbase'",replace
		}
		erase "`temp'"
		sort year q_age_pr q_age_fin q_age_fin_immo
	
	* Interpolation
					
		* Period 1993-1997
			local i =1992
			local j=1998
			foreach var of varlist  prop_avie share_avie  {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 1999-2003
			local i =1998
			local j=2004
			foreach var of varlist prop_avie share_avie    {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 2005-2009
			local i =2004
			local j=2010
			foreach var of varlist  prop_avie share_avie  {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			drop *2010 *2004 *1998 *1992 
			order year q_age_pr q_age_fin q_age_fin_immo
			sort year q_age_pr q_age_fin q_age_fin_immo
			keep if year==1992 | year==1994 | year==2000 | year==2006 | year==2010
save "$param/clef_life_DMTG.dta",replace
			

	
	
	
	
	
	
	
	
	
	
	


