***********************************************************************************************************************************
* Dofile used to compute differential mortality rate by year, decenial age and gender based on mortality table of Blampain (2016) *
***********************************************************************************************************************************

* A) Load the data
********************

	* Total living population by year, age and gender 
		import excel using "$param/DemoData.xlsx", first clear sheet("men")  cellrange(A2:AP103)
		keep age annee1975 annee1982 annee1990 annee1999 annee2008
		foreach num of numlist 1975 1982 1990 1999 2008  {
			rename annee`num' annee`num'h				
		}
		tempfile temp
		save "`temp'", replace
		import excel using "$param/DemoData.xlsx", first clear sheet("women")  cellrange(A2:AP103)
		keep age annee1975 annee1982 annee1990 annee1999 annee2008
		foreach num of numlist 1975 1982 1990 1999 2008 {
			rename annee`num' annee`num'f
		}
		merge 1:1 age using "`temp'"
		erase "`temp'"
		drop _merge
		* Age during the year
			replace age=age+1
			foreach var of varlist annee????? {
				replace `var'=`var'+`var'[_n+1] if age==100
			}
			drop if age==101
		tempfile temp
		save "`temp'", replace
	
	* Mortality rate for 100 000 individuals by year, age, gender and occupation
		import excel using "$param/Quotient mortalite.xlsx",first clear sheet("A1") cellrange(A7:CC78) 
		keep age pcs0* pcs3* pcs4*
		*drop ?????76
		merge 1:1 age using "`temp'"
		erase "`temp'"
		drop if age<30
		drop _merge

*B) Compute Differential mortality by year, age and wealth groups
********************************************************************
	
	* Mortality rate by decenial age
		gen aged=int(age/10)
		replace aged=9 if aged==10
		
	* Number of living by year, decenial aged and gender
		foreach num of numlist 1975 1982 1990 1999 2008 {
			foreach sex of newlist h f {
				bys aged: egen tot`num'`sex'=sum(annee`num'`sex')
			}
		}
	* Mortality rate by year, aged, sex and occupation
		foreach year of numlist 75 82 90 99  {
			local year2=`year'+1900
			foreach num of numlist 0 3 4 {
				foreach sex of newlist h f {
			  rename  pcs`num'`sex'`year' pcs`num'`sex'`year2' 
				}
			}
		}	
			
		foreach year of numlist 1975 1982 1990 1999 2008 {
			foreach num of numlist 0 3 4 {
				foreach sex of newlist h f {
					bys aged : egen pcs`num'`sex'`year'_mean=sum(pcs`num'`sex'`year'*annee`year'`sex'/tot`year'`sex')
				}
			}
		}
		keep aged *_mean 
		collapse (mean) *_mean,by(aged)
		
	* Mortality rate for bottom 50%
		foreach year of numlist 1975 1982 1990 1999 2008 {
				foreach sex of newlist h f {
					gen pcs5`sex'`year'_mean=(pcs0`sex'`year'_mean-0.1*pcs3`sex'`year'_mean-0.4*pcs4`sex'`year'_mean)/0.5
				}
			}
	* Differential mortality rate
		foreach year of numlist 1975 1982 1990 1999 2008 {
			foreach num of numlist 5 3 4 {
				foreach sex of newlist h f {
					replace pcs`num'`sex'`year'_mean=pcs`num'`sex'`year'_mean/pcs0`sex'`year'_mean
				}
			}
		}
* C) Exportation of the parameters	
*************************************
	
	* Rename the variables
		foreach year of numlist 1975 1982 1990 1999 2008 {
				foreach sex of newlist h f {
					rename pcs5`sex'`year'_mean diff_mortbot`sex'`year'
				}
			}
		foreach year of numlist 1975 1982 1990 1999 2008 {
			foreach sex of newlist h f {
				rename pcs4`sex'`year'_mean diff_mortmid`sex'`year'
			}
		}
		foreach year of numlist 1975 1982 1990 1999 2008 {
			foreach sex of newlist h f {
				rename pcs3`sex'`year'_mean diff_morttop`sex'`year'
			}
		}
		foreach year of numlist 1975 1982 1990 1999 2008 {
			foreach sex of newlist h f {
				rename pcs0`sex'`year'_mean  mort_rate`sex'`year'						
			}
		}
	* Organize the data
		keep aged diff_mort* mort_rate*
		reshape long diff_morttoph diff_morttopf diff_mortmidh mort_rateh mort_ratef diff_mortmidf diff_mortboth diff_mortbotf, i(aged) j(year)
		reshape long  diff_morttop diff_mortmid  diff_mortbot mort_rate, i(aged year) j(sexe) string
		replace mort_rate=mort_rate/100000
		sort year aged sexe
		order year aged sexe
		
		tempfile temp
		save "`temp'", replace
		keep aged year sexe diff_mort*
		save "$param/diffmort.dta",replace
		use "`temp'", clear
		erase "`temp'"
		
		order year aged  mort_rate diff_mortbot diff_mortmid diff_morttop
		reshape wide diff_morttop diff_mortmid diff_mortbot mort_rate, i(year aged) j(sexe)  string
		order year aged  mort_rateh diff_mortboth diff_mortmidh diff_morttoph
		export excel using "$resultsDMTG/RawResults_ApD.xlsx", sheet("statadiffmort")  sheetmodify cell(A4) firstrow(variable)

