******************************************************************************
* Dofiles used to export alternative wealth series for robustness checks     *
******************************************************************************

* Robustness checks on wealth imputation:
	* I) Capitalize separately interest and dividends from 1988 to 2012
	* II) Alternative imputation for life insurance, un vs plusieurs rdts fnanciers
	* III) Alternative imputation for for owner-occupied housing
				
	* For each alternative series, synthetic files of wealth series with wealth share and wealth composition
	* columns: year, gperc,  n, thr, ytop, b, y0 + wealth share (share_dperc) and wealth composition (by decile except in top deciles that is more detailed)
	*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)

*****************************************************************************
* I) Capitalize separately interests and dividends during 1988-2012 period  *
*****************************************************************************
	* a) gpercentile 
		foreach pas of global yearliste {
			global year=`pas'
			if ${year}>1984 {
			use year idindiv pondn pat*  using "$wfrobust/corTS/revcapwealthcn${year}_corTS.dta",clear
				rename pat_corTS pat_cn
				* Definition of the percentile par importance de patrimoine
					sort year pat_cn
					gen pondvr=round(1000*pondn) 
					bys year  : cumul pat_cn [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen pat2=pondn*pat_cn
					collapse (min)thr=pat_cn (sum)pat2 n=pondn,by(year  gperc)
					gsort + year  - gperc
					gen cumulpat=sum(pat2)
					gen cumulpond=sum(n)
					gen ytop=cumulpat/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					keep year gperc   n thr  ytop b
					order year gperc   n thr  ytop b
					dis $year
					if (${casd}==0 & $year>1988)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}
				}
					erase "`temp'"
					sort year  gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/wealth/gperc/gperctemp_corTS1.dta",replace
				
	* b) Add wealth share and wealth composition by decile to gperc
		
		foreach pas of global yearliste {
			global year=`pas'
			if ${year}>1984 {
			use "$wfrobust/corTS/revcapwealthcn${year}_corTS.dta",clear
			merge 1:1 year idindiv using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keepusing(patfon_brut_cn patfon_owner_brut_cn patfon_rent_brut_cn patpro_cn patfin_liqu_cn patfin_av_cn passif_cn)
			drop _merge
			foreach var of newlist pat patfin_int patfin_div {
				rename `var'_corTS `var'_cn
			}
			gen patnonfi_cn=patfon_brut_cn+patpro_cn
			gen patfin_liquint_cn=patfin_int_cn+ patfin_liqu_cn
			gen patfin_cn =patfin_av_cn+patfin_div_cn+patfin_int_cn+patfin_liqu_cn
			#delimit;
			order year pondn  pat_cn patnonfi_cn patfon_brut_cn patfon_owner_brut_cn patfon_rent_brut_cn patpro_cn 
				patfin_cn patfin_liquint_cn patfin_liqu_cn patfin_int_cn patfin_div_cn patfin_av_cn passif_cn;
			#delimit cr
			keep year-passif_cn
			
			* Definition of the percentile par importance de patrimoine
				* Wealth groups
					sort year  pat_cn
					gen pondvr=round(100*pondn) 
					bys year  : cumul pat_cn [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
					
					rename pat_cn pat
					foreach var of newlist 	patnonfi patfon_brut patfon_owner_brut patfon_rent_brut	patpro patfin patfin_liquint patfin_liqu patfin_int patfin_div	patfin_av passif {
						rename `var'_cn sh_`var'
					}
					gen pat2=pat
					foreach var of varlist pat-sh_passif  {
						replace `var'=`var'*pondn
					}
					bys year  : egen pop=sum(pondn)
					bys year : egen patot=sum(pondn*pat2)
					gen patmean=patot/pop
					collapse (sum) pat-sh_passif (mean) patmean pop,by(year  dperc)
					bys year  : egen tot=sum(pat)
					foreach var of varlist sh_patnonfi-sh_passif  {
						replace `var' =`var'/pat
					}
					gen share_dperc=pat/tot
					drop tot pat
					sort year  dperc
					order year  patmean pop dperc share_dperc
					dis $year
					if (${casd}==0 & $year>1988)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}
				}
					erase "`temp'"
					sort year  dperc
	save  "$resexp/wealth/gperc/gperctemp_corTS2.dta",replace
	merge 1:m year dperc using "$resexp/wealth/gperc/gperctemp_corTS1.dta" 
	sort year  gperc
	drop _merge
	order dperc- sh_passif,last
	save "$resexp/wealth/gperc/gperc_corTS.dta",replace
	erase "$resexp/wealth/gperc/gperctemp_corTS2.dta"
	erase "$resexp/wealth/gperc/gperctemp_corTS1.dta"
	import excel using "$resexp/wealth/CASD/gperc_corTS.xlsx", first clear sheet("Feuil1")  cellrange(A2:V2415)
	append using "$resexp/wealth/gperc/gperc_corTS.dta"
	sort year  gperc
	save "$resexp/wealth/gperc/gperc_corTS.dta",replace
	
*************************************************
* II) Alternative imputations of life insurance *
*************************************************

	* a) gpercentile 
		foreach loop of newlist A B C {
			foreach pas of global yearliste {
			global year=`pas'
			
			use year idindiv pondn pat_`loop'  using "$wfrobust/Life insurance/robustnesswealthcn${year}.dta",clear
			
				* Definition of the percentile par importance de patrimoine
					sort year pat_`loop'
					gen pondvr=round(1000*pondn) 
					bys year  : cumul pat_`loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen pat2=pondn*pat_`loop'
					collapse (min)thr=pat_`loop' (sum)pat2 n=pondn,by(year  gperc)
					gsort + year  - gperc
					gen cumulpat=sum(pat2)
					gen cumulpond=sum(n)
					gen ytop=cumulpat/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					keep year gperc   n thr  ytop b
					order year gperc   n thr  ytop b
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year  gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/wealth/gperc/gperctemp_avie`loop'1.dta",replace
			}	
	* b) Add wealth share and wealth composition by decile to gperc
	foreach loop of newlist A B C {
		foreach pas of global yearliste {
			global year=`pas'

			use "$wfrobust/Life insurance/robustnesswealthcn${year}.dta",clear
			merge 1:1 year idindiv using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keepusing(patfon_brut_cn patfon_owner_brut_cn patfon_rent_brut_cn passif_cn )
			foreach var of newlist patfon_brut patfon_owner_brut patfon_rent_brut passif  {
				rename `var' `var'_`loop'
			}
			gen patnonfi_`loop'=patfon_brut_`loop'+patpro_`loop'
			#delimit;
			order year pondn  pat_`loop' patnonfi_`loop' patfon_brut_`loop' patfon_owner_brut_`loop' patfon_rent_brut_`loop' patpro_`loop' 
				patfin_`loop'  passif_`loop';
			#delimit cr
			keep year-passif_`loop'
			
			* Definition of the percentile par importance de patrimoine
				* Wealth groups
					sort year  pat_`loop'
					gen pondvr=round(100*pondn) 
					bys year  : cumul pat_`loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
					
					rename pat_`loop' pat
					foreach var of newlist patnonfi	 patfon_brut patfon_owner_brut patfon_rent_brut	patpro patfin passif {
						rename `var'_`loop' sh_`var'
					}
					gen pat2=pat
					foreach var of varlist pat-sh_passif  {
						replace `var'=`var'*pondn
					}
					bys year  : egen pop=sum(pondn)
					bys year : egen patot=sum(pondn*pat2)
					gen patmean=patot/pop
					collapse (sum) pat-sh_passif (mean) patmean pop,by(year  dperc)
					bys year  : egen tot=sum(pat)
					foreach var of varlist sh_patnonfi-sh_passif  {
						replace `var' =`var'/pat
					}
					gen share_dperc=pat/tot
					drop tot pat
					sort year  dperc
					order year  patmean pop dperc share_dperc
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year  dperc
	save  "$resexp/wealth/gperc/gperctemp_avie`loop'2.dta",replace
	merge 1:m year dperc using "$resexp/wealth/gperc/gperctemp_avie`loop'1.dta" 
	sort year  gperc
	drop _merge
	order dperc- sh_passif,last
	save "$resexp/wealth/gperc/gperc_avie`loop'.dta",replace
	erase "$resexp/wealth/gperc/gperctemp_avie`loop'2.dta"
	erase "$resexp/wealth/gperc/gperctemp_avie`loop'1.dta"
	import excel using "$resexp/wealth/CASD/gperc_avie`loop'.xlsx", first clear sheet("Feuil1")  cellrange(A2:Q2415)
	append using "$resexp/wealth/gperc/gperc_avie`loop'.dta"
	sort year  gperc
	save "$resexp/wealth/gperc/gperc_avie`loop'.dta",replace

}
*****************************************************************
* III) Alternative imputations of owner-occupied housing assets *
*****************************************************************

	* a) gpercentile 
		foreach loop of newlist ENL EPrevtot {
			foreach pas of global yearliste {
			global year=`pas'  
			if "`loop'"=="ENL" | ${year}>=1992 {
			use year idindiv pondn pat_`loop'   using "$wfrobust/Housing/robust_hous${year}.dta",clear
			
				* Definition of wealth groups
					sort year pat_`loop'
					gen pondvr=round(1000*pondn) 
					bys year  : cumul pat_`loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen pat2=pondn*pat_`loop'
					collapse (min)thr=pat_`loop' (sum)pat2 n=pondn,by(year  gperc)
					gsort + year  - gperc
					gen cumulpat=sum(pat2)
					gen cumulpond=sum(n)
					gen ytop=cumulpat/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					keep year gperc   n thr  ytop b
					order year gperc   n thr  ytop b
					dis $year
					if (${casd}==0 & $year>1970 & "`loop'"=="ENL") | (${casd}==0 & $year>1992 & "`loop'"=="EPrevtot" ) {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}
				}
					erase "`temp'"
					sort year  gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/wealth/gperc/gperctemp_hous`loop'1.dta",replace
			}	
	* b) Add wealth share and wealth composition by decile to gperc
	
	foreach loop of newlist ENL EPrevtot {
		foreach pas of global yearliste {
			global year=`pas'	
			if ("`loop'"=="ENL" | $year>=1992) {
			use year idindiv pondn *_`loop'   using "$wfrobust/Housing/robust_hous${year}.dta",clear
			merge 1:1 year idindiv using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keepusing(passif_rent_cn patfon_rent_brut_cn patpro_cn patfin_cn )
			drop _merge
			foreach var of newlist passif_rent patfon_rent_brut patpro patfin  {
				rename `var' `var'_`loop'
			}
			gen patfon_brut_`loop'=patfon_owner_brut_`loop'+patfon_rent_brut_`loop'
			gen passif_`loop'=passif_owner_`loop'+passif_rent_`loop'
			#delimit;
			order year pondn  pat_`loop'  patfon_brut_`loop' patfon_owner_brut_`loop' patfon_rent_brut_`loop' patpro_`loop' 
				patfin_`loop' passif_owner_`loop'  passif_`loop';
			#delimit cr
			keep year-passif_`loop'
			
			* Definition of the percentile par importance de patrimoine
				* Wealth groups
					sort year  pat_`loop'
					gen pondvr=round(100*pondn) 
					bys year  : cumul pat_`loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
					
					rename pat_`loop' pat
					foreach var of newlist patfon_brut patfon_owner_brut patfon_rent_brut	patpro patfin passif_owner passif {
						rename `var'_`loop' sh_`var'
					}
					gen pat2=pat
					foreach var of varlist pat-sh_passif  {
						replace `var'=`var'*pondn
					}
					bys year  : egen pop=sum(pondn)
					bys year : egen patot=sum(pondn*pat2)
					gen patmean=patot/pop
					collapse (sum) pat-sh_passif (mean) patmean pop,by(year  dperc)
					bys year  : egen tot=sum(pat)
					foreach var of varlist sh_patfon_brut-sh_passif  {
						replace `var' =`var'/pat
					}
					gen share_dperc=pat/tot
					drop tot pat
					sort year  dperc
					order year  patmean pop dperc share_dperc
					dis $year
					if (${casd}==0 & $year>1970 & "`loop'"=="ENL") | (${casd}==0 & $year>1992 & "`loop'"=="EPrevtot" ) {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}
				}
					erase "`temp'"
					sort year  dperc
	save  "$resexp/wealth/gperc/gperctemp_hous`loop'2.dta",replace
	merge 1:m year dperc using "$resexp/wealth/gperc/gperctemp_hous`loop'1.dta" 
	sort year  gperc
	drop _merge
	order dperc- sh_passif,last
	save "$resexp/wealth/gperc/gperc_hous`loop'.dta",replace
	erase "$resexp/wealth/gperc/gperctemp_hous`loop'2.dta"
	erase "$resexp/wealth/gperc/gperctemp_hous`loop'1.dta"
	import excel using "$resexp/wealth/CASD/gperc_hous`loop'.xlsx", first clear sheet("Feuil1")  cellrange(A2:Q2415)
	append using "$resexp/wealth/gperc/gperc_hous`loop'.dta"
	sort year  gperc
	save "$resexp/wealth/gperc/gperc_hous`loop'.dta",replace

}
