*****************************************
* DINA: Exportation of DINA results    *
*****************************************

* Dofiles used to create synthetic micro-files of income distribution     
	* By income concept and Population type:
		* Total vs capital vs Labor income
		* Fiscal vs Pre-tax vs Factor income
		* Tax units vs equal-split adults vs individualistic adults
	* Series broken down by percentile, age, gender and income categories

* Part A: DINA income
	* A.I) Pretax and Factor income (all, labor and capital) among individualistic adults
	* A.II) Pretax income (all and labor) among equal-split adults 
	* A.III) Pre-tax income at the tax unit level
* Part B: Fiscal income            	
	* B.I) Fiscal income (all, labor, capital) among individualistic adults
	* B.II) Fiscal income at the tax unit level
	* B.III) Fiscal income among equal-split adults															*
*Part C: DINA income by age and gender (Pretax income or labor pretax income at the individual level)   * 
	* C.I)  Pretax income among equal-split adults by decenial aged and broad income groups
	* C.II) Pretax income by age and sex (equal-split adults vs individualistic adults)  
	* C.III)Pretax income by decenial age and sex (equal-split adults vs individualistic adults)
	* C.IV) Pretax income by broad age groups and broad income groups among equal-split adults 
	* C.V) Income inequality by gender (Pre-tax labor income among individualistic adults)
	
	
set more off
clear 


******************************************************************************************************************************************
* Part A: DINA income (Pre-tax vs Factor income, individualistic adults vs tax units vs equal-split adults ; labor vs capital vs total)  *
******************************************************************************************************************************************
	
* gpercentile by gender and year + income share and income composition by decile
	

	* A.I) Pretax and Factor income (all, labor and capital) among individualistic adults
	**************************************************************************************
		*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)
		*(sex =0,1,2) (n = number of individuals in cell)
		
		* a) gpercentile by gender
		****************************
		foreach loop of newlist r_pretaxCN  rcap rtrav_pretaxCN r_FICN rtrav_FICN {
			foreach pas of global yearliste {
				dis `pas'
				global year=`pas'
				dis "`loop'"
				use year idindiv pondn rcap_cn factorcapital age using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN rtrav_FICN)
					drop  _merge
					gen sex=0
					gen sextemp=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
					rename sexe sex
					drop _merge 
					drop if sex==.
					append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keep(year idindiv pondn rcap_cn factorcapital age)
					merge m:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN rtrav_FICN)
					drop _merge
					gen sextemp=0
					if "`loop'" == "rtrav_pretaxCN" | "`loop'" == "rtrav_FICN" {
						merge m:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
						replace sextemp = sexe if sex==.
						drop _merge
					}
				}
				if "`loop'" == "rtrav_FICN" {
					drop if age<25 | age>59
				}
					drop  idindiv
					replace sex=0 if sex==.
				
				gen r_FICN=rcap_cn*factorcapital+rtrav_FICN
				gen r_pretaxCN=rcap_cn+rtrav_pretaxCN
				rename rcap_cn rcap
				* Definition of the percentile by level of considered income
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen `loop'2=pondn*`loop'
					replace age=age*pondn
					bys year sex : egen y0=sum(pondn*(`loop'==0))
					gen prop_w=pondn*(sextemp==2)*(sex==0)
					gen prop_tot=pondn*(sextemp~=.)*(sex==0)
					collapse (min) y0 thr=`loop' (sum)`loop'2 n=pondn prop_w prop_tot age,by(year sex gperc)
					replace prop_w=prop_w/prop_tot
					replace age=age/n
					gsort + year sex - gperc
					bys year sex : gen cumul`loop'=sum(`loop'2)
					bys year sex : gen cumulpond=sum(n)
					gen ytop=cumul`loop'/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					bys year sex: egen tot=sum(n)
					replace y0=y0/tot
					drop tot prop_tot
					order year gperc sex  n thr  ytop b y0 prop_w age
					keep year gperc sex  n thr  ytop b y0 prop_w age
					if "`loop'" ~= "rtrav_pretaxCN" & "`loop'" ~= "rtrav_FICN" {
						keep year gperc sex  n thr  ytop b y0 age
					}
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/DINA/gperc`loop'temp1.dta",replace
		}				
		* b) Add income share and income composition by decile to gperc
		****************************************************************
		clear
		foreach loop of newlist r_pretaxCN r_FICN rcap rtrav_pretaxCN rtrav_FICN {
			foreach pas of global yearliste {
				global year=`pas'
				dis `pas'
				dis "`loop'"
				use year idindiv pondn age rcap_cn- rfin_av_cn factorcapital using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
					merge 1:1 year idindiv using "$wfrevtravcn/revtravcn${year}.dta"
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
					rename sexe sex
					drop _merge
					drop if sex==.
					append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta"
					drop idfoy- passif_rent_cn
					merge m:1 year idindiv using "$wfrevtravcn/revtravcn${year}.dta"
					replace sex=0 if sex==.
				}
				if "`loop'" == "rtrav_FICN" {
					drop if age<25 | age >59
				}
				keep year sex pondn  rcap_cn - rfin_av_cn rtrav_FICN- nonsal_pretaxCN factorcapital
				sort year sex 
				gen r_FICN=rcap_cn*factorcapital+rtrav_FICN
				gen r_pretaxCN=rcap_cn+rtrav_pretaxCN
				gen rfin_cn=rfin_div_cn+ rfin_int_cn+ rfin_liqu_cn+ rfin_av_cn
				replace sal_pretaxCN = sal_pretaxCN +chom_pretaxCN
				drop chom_pretaxCN
				rename rcap_cn rcap

				#delimit;
				order year sex pondn 
				r_FICN rtrav_FICN r_pretaxCN rtrav_pretaxCN rcap sal_FICN nonsal_labor_FICN  sal_pretaxCN pension_pretaxCN nonsal_labor_pretaxCN
				 rfon_cn rfon_owner_cn rfon_rent_cn nonsal_capital_cn 
				rfin_cn rfin_div_cn rfin_int_cn rfin_liqu_cn rfin_av_cn  ;
				#delimit cr
				order factorcapital,last
				
				* Definition of the percentile by level of considered income
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
				
				foreach var of newlist rfon  rfon_owner rfon_rent nonsal_capital rfin rfin_div rfin_int rfin_liqu rfin_av	{
					rename `var'_cn sh_`var'
				}
				rename rcap sh_rcap
				foreach var of varlist *_FICN *_pretaxCN	{
					rename `var' sh_`var'
				}
				gen `loop'2=sh_`loop'
				foreach var of varlist sh_r_FICN- sh_nonsal_pretaxCN {
					replace `var'=`var'*pondn
				}
				bys year sex : egen pop=sum(pondn)
				bys year sex: egen `loop'tot=sum(pondn*`loop'2)
				gen ymean=`loop'tot/pop
				collapse (sum) sh_r_FICN- sh_nonsal_pretaxCN  (mean) ymean pop factorcapital,by(year sex dperc)
				
				if "`loop'"=="r_FICN" | "`loop'"=="rtrav_FICN" {
					bys year sex : egen tot=sum(sh_r_FICN)
					drop *_pretaxCN
					foreach var of newlist  rcap rfon rfon_owner rfon_rent nonsal_capital rfin rfin_div rfin_int rfin_liqu rfin_av {
						replace sh_`var'=sh_`var'*factorcapital
					}
					replace sh_nonsal_FICN=sh_nonsal_labor_FICN+ sh_nonsal_capital
					drop factorcapital
				}
				
				
				if "`loop'"=="rcap" | "`loop'"=="rtrav_pretaxCN" | "`loop'"=="r_pretaxCN"  {
					drop *_FICN factorcapital
					bys year sex : egen tot=sum(sh_r_pretaxCN)
				}
				foreach var of varlist sh* {
						replace `var'=`var'/tot
				}
				drop tot 
				sort year sex dperc
				order year sex ymean pop dperc 
				dis $year
				if (${casd}==0 & $year>1970)  {
					append  using "`temp'"
					erase "`temp'"
				}
				
				if (${casd}==1 & $year>1994) {
					append using "`temp'"
					erase "`temp'"
				}
				tempfile temp
				save "`temp'",replace
			}	
			erase "`temp'"
			sort year sex dperc
		save  "$resexp/DINA/gperc`loop'temp2.dta",replace
		merge 1:m year sex dperc using "$resexp/DINA/gperc`loop'temp1.dta" 
		sort year sex gperc
		drop _merge
		order year gperc sex n-b y0 age
		if "`loop'" == "rtrav_pretaxCN" | "`loop'" == "rtrav_FICN" {
			order year gperc sex n-b y0 prop_w age
		}
		save "$resexp/DINA/gperc`loop'.dta",replace 
		erase"$resexp/DINA/gperc`loop'temp1.dta"
		erase "$resexp/DINA/gperc`loop'temp2.dta"
		if "`loop'"=="r_FICN"  {
			import excel using "$resexp/DINA/CASD/gperc`loop'.xlsx", first clear sheet("Feuil1")  cellrange(A2:AA7241)
		}
		if "`loop'"=="r_pretaxCN" | "`loop'"=="rcap" | "`loop'"=="rtrav_FICN" {
			import excel using "$resexp/DINA/CASD/gperc`loop'.xlsx", first clear sheet("Feuil1")  cellrange(A2:AB7241)
		}
		if "`loop'" == "rtrav_pretaxCN" {
			import excel using "$resexp/DINA/CASD/gperc`loop'.xlsx", first clear sheet("Feuil1")  cellrange(A2:AC7241)
		}
		append using "$resexp/DINA/gperc`loop'.dta" 
		sort year sex gperc
		save "$resexp/DINA/gperc`loop'.dta",replace 
		
	}


	* A.II) Pretax income (all and labor) among equal-split adults 
	*************************************************************
		*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)
		*(sex =0,1,2) (n = number of individuals in cell)
		
		* a) gpercentile by gender
		***************************
			clear
			foreach loop of newlist r_pretaxCN rtrav_pretaxCN {
			foreach pas of global yearliste {
				dis `pas'
				global year=`pas'
				dis "`loop'"

				use year idindiv idfoy pondn rcap_cn pac ndecl age using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN)
					drop  _merge
					gen sex=0
					gen a =1
					gen sextemp=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
					rename sexe sex
					drop _merge 
					gen a =1
					drop if sex==.
					append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keep(year idindiv pondn rcap_cn idfoy pac ndecl age)
					merge m:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN)
					gen sextemp=0
					if "`loop'" == "rtrav_pretaxCN" {
						drop _merge
						merge m:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
						replace sextemp = sexe if sex==.
					}
					drop _merge idindiv
					replace sex=0 if sex==.
					replace a=2 if a==.
				}
				
			* Income equally split among couples
				foreach var of varlist rtrav_pretaxCN  {
					bys a idfoy: egen `var'tot=sum(`var'*(pac==0))
					replace `var'=`var'tot/2 if pac==0 & ndecl==2
					drop `var'tot
				}
				gen r_pretaxCN=rcap_cn+rtrav_pretaxCN
				rename rcap_cn rcap
				
				* Definition of the percentile par importance de revenu
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen `loop'2=pondn*`loop'
					replace age=age*pondn
					bys year sex : egen y0=sum(pondn*(`loop'==0))
					gen prop_w=pondn*(sextemp==2)*(sex==0)
					gen prop_tot=pondn*(sextemp~=.)*(sex==0)
					collapse (min)y0 thr=`loop' (sum)`loop'2 n=pondn prop_w prop_tot age,by(year sex gperc)
					replace prop_w=prop_w/prop_tot
					replace age=age/n
					gsort + year sex - gperc
					bys year sex : gen cumul`loop'=sum(`loop'2)
					bys year sex : gen cumulpond=sum(n)
					gen ytop=cumul`loop'/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					bys year sex: egen tot=sum(n)
					replace y0=y0/tot
					drop tot prop_tot
					keep year gperc sex  n thr  ytop b y0 prop_w age
					order year gperc sex  n thr  ytop b y0 prop_w age
					if "`loop'" ~= "rtrav_pretaxCN" {
						keep year gperc sex  n thr  ytop b y0 age
					}
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/DINA/gperc`loop'_equaltemp1.dta",replace
		}		
		* b) Add income share and income composition by decile to gperc
		******************************************************************
		clear
			foreach loop of newlist r_pretaxCN rtrav_pretaxCN {
			foreach pas of global yearliste {
				global year=`pas'
				dis `pas'
				dis "`loop'"
				use year idindiv pondn rcap_cn- rfin_av_cn idfoy pac ndecl using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
					gen a=1
					merge 1:1 year idindiv using "$wfrevtravcn/revtravcn${year}.dta"
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
					rename sexe sex
					drop _merge 
					gen a =1
					drop if sex==.
					append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta"
					drop idnum- passif_rent_cn factorcapital
					merge m:1 year idindiv using "$wfrevtravcn/revtravcn${year}.dta"
					replace sex=0 if sex==.
					replace a=2 if a ==.
				}
				keep year idfoy pac ndecl a  sex pondn  rcap_cn - rfin_av_cn rtrav_FICN- nonsal_pretaxCN
				replace sal_pretaxCN = sal_pretaxCN +chom_pretaxCN
			* Income equally split among couples
				foreach var of varlist rtrav_pretaxCN sal_pretaxCN nonsal_labor_pretaxCN pension_pretaxCN  {
					bys a idfoy: egen `var'tot=sum(`var'*(pac==0))
					replace `var'=`var'tot/2 if pac==0 & ndecl==2
					drop `var'tot
				}
				drop *FICN chom_pretaxCN a idfoy pac ndecl
				sort year sex 
				gen r_pretaxCN=rcap_cn+rtrav_pretaxCN
				gen rfin_cn=rfin_div_cn+ rfin_int_cn+ rfin_liqu_cn+ rfin_av_cn
				rename rcap_cn rcap
				#delimit;
					order year sex pondn 
					 r_pretaxCN rtrav_pretaxCN rcap   sal_pretaxCN pension_pretaxCN nonsal_labor_pretaxCN
					 rfon_cn rfon_owner_cn rfon_rent_cn nonsal_capital_cn 
					rfin_cn rfin_div_cn rfin_int_cn rfin_liqu_cn rfin_av_cn  ;
				#delimit cr
				
				* Definition of the percentile par importance de revenu
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
				
				foreach var of newlist rfon  rfon_owner rfon_rent nonsal_capital rfin rfin_div rfin_int rfin_liqu rfin_av	{
					rename `var'_cn sh_`var'
				}
				rename rcap sh_rcap
				foreach var of varlist *_pretaxCN	{
					rename `var' sh_`var'
				}
				gen `loop'2=sh_`loop'
				foreach var of varlist sh_r_pretaxCN- sh_nonsal_pretaxCN {
					replace `var'=`var'*pondn
				}
				bys year sex : egen pop=sum(pondn)
				bys year sex: egen `loop'tot=sum(pondn*`loop'2)
				gen ymean=`loop'tot/pop
				collapse (sum) sh_r_pretaxCN- sh_nonsal_pretaxCN  (mean) ymean pop,by(year sex dperc)
				bys year sex : egen tot=sum(sh_r_pretaxCN)
				foreach var of varlist sh* {
					replace `var'=`var'/tot
				}
				
				drop tot 
				sort year sex dperc
				order year sex ymean pop dperc 
				dis $year
				if (${casd}==0 & $year>1970)  {
					append  using "`temp'"
					erase "`temp'"
				}
				
				if (${casd}==1 & $year>1994) {
					append using "`temp'"
					erase "`temp'"
				}
				tempfile temp
				save "`temp'",replace
			}	
			erase "`temp'"
			sort year sex dperc
		save  "$resexp/DINA/gperc`loop'_equaltemp2.dta",replace
		merge 1:m year sex dperc using "$resexp/DINA/gperc`loop'_equaltemp1.dta" 
		sort year sex gperc
		drop _merge
		order year gperc sex n-b y0 age
		if "`loop'" == "rtrav_pretaxCN" {
			order year gperc sex n-b y0 prop_w age
		}
		save "$resexp/DINA/gperc`loop'_equal.dta",replace 
		erase"$resexp/DINA/gperc`loop'_equaltemp1.dta"
		erase "$resexp/DINA/gperc`loop'_equaltemp2.dta"
		if "`loop'"=="r_pretaxCN"  {
			import excel using "$resexp/DINA/CASD/gperc`loop'_equal.xlsx", first clear sheet("Feuil1")  cellrange(A2:AB7241)
		}
		if "`loop'" == "rtrav_pretaxCN" {
			import excel using "$resexp/DINA/CASD/gperc`loop'_equal.xlsx", first clear sheet("Feuil1")  cellrange(A2:AC7241)
		}
		append using "$resexp/DINA/gperc`loop'_equal.dta" 
		sort year sex gperc
		save "$resexp/DINA/gperc`loop'_equal.dta",replace 
	}

	* A.III) Pre-tax income at the tax unit level
	*********************************************
		*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)
		*(sex =0,1,2) (n = number of tax units in cell)
		
		* a) gpercentile by gender
		****************************
			clear
			foreach pas of global yearliste {
				dis `pas'
				global year=`pas'
				local loop="r_pretaxCN_foy"
				dis "`loop'"
				use year idindiv idfoy idnum  pondn rcap_cn pac using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
				merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN)
				drop  _merge
				gen sex=0
				drop if idnum==1 & pac==1
				
			* Tax unit income 
				rename rcap_cn rcap
				foreach var of varlist rtrav_pretaxCN rcap  {
					bys idfoy: egen `var'_foy=sum(`var')
					drop `var'
				}
				gen r_pretaxCN_foy=rcap_foy+rtrav_pretaxCN_foy
				keep if idnum==1
				keep year pondn idfoy r_pretaxCN_foy sex
				* Definition of the percentile par importance de revenu
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen `loop'2=pondn*`loop'
					bys year sex : egen y0=sum(pondn*(`loop'==0))
					collapse (min)y0 thr=`loop' (sum)`loop'2 n=pondn,by(year sex gperc)
					gsort + year sex - gperc
					bys year sex : gen cumul`loop'=sum(`loop'2)
					bys year sex : gen cumulpond=sum(n)
					gen ytop=cumul`loop'/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					bys year sex: egen tot=sum(n)
					replace y0=y0/tot
					drop tot
					keep year gperc sex  n thr  ytop b y0
					order year gperc sex  n thr  ytop b y0
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/DINA/gpercr_pretaxCN_foytemp1.dta",replace
				
		* b) Add income share and income composition by decile to gperc
		******************************************************************
		clear
			foreach pas of global yearliste {
				global year=`pas'
				dis `pas'
				local loop="r_pretaxCN_foy"
				dis "`loop'"
				use year idindiv idnum pondn rcap_cn- rfin_av_cn idfoy pac ndecl using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
				merge 1:1 year idindiv using "$wfrevtravcn/revtravcn${year}.dta"
				gen sex=0
				drop if idnum==1 & pac==1
				
				keep year idfoy idnum sex pondn  rcap_cn - rfin_av_cn rtrav_FICN- nonsal_pretaxCN
				replace sal_pretaxCN = sal_pretaxCN +chom_pretaxCN
				gen r_pretaxCN=rcap_cn+rtrav_pretaxCN
				gen rfin_cn=rfin_div_cn+ rfin_int_cn+ rfin_liqu_cn+ rfin_av_cn
				drop *FICN chom_pretaxCN
				
			* Tax unit income 
				foreach var of newlist rcap rfon  rfon_owner rfon_rent nonsal_capital rfin rfin_div rfin_int rfin_liqu rfin_av  {
					bys idfoy: egen `var'_foy=sum(`var'_cn)
					drop `var'_cn
				}
				foreach var of varlist nonsal_pretaxCN r_pretaxCN rtrav_pretaxCN sal_pretaxCN nonsal_labor_pretaxCN pension_pretaxCN  {
					bys idfoy: egen `var'_foy=sum(`var')
					drop `var'
				}
				keep if idnum==1
				keep year pondn sex *_foy
				sort year sex 
				#delimit;
					order year sex pondn 
					 r_pretaxCN_foy rtrav_pretaxCN_foy rcap_foy   sal_pretaxCN_foy pension_pretaxCN_foy nonsal_labor_pretaxCN_foy
					 rfon_foy rfon_owner_foy rfon_rent_foy nonsal_capital_foy 
					rfin_foy rfin_div_foy rfin_int_foy rfin_liqu_foy rfin_av_foy  ;
				#delimit cr
				
				* Definition of the percentile par importance de revenu
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
				
				foreach var of newlist rcap rfon  rfon_owner rfon_rent nonsal_capital rfin rfin_div rfin_int rfin_liqu rfin_av	{
					rename `var'_foy sh_`var'
				}
				foreach var of newlist rtrav_pretaxCN sal_pretaxCN pension_pretaxCN nonsal_labor_pretaxCN nonsal_pretaxCN	{
					rename `var'_foy sh_`var'
				}
				rename r_pretaxCN_foy sh_r_pretaxCN_foy
				gen `loop'2=sh_`loop'
				foreach var of varlist sh_r_pretaxCN_foy- sh_nonsal_pretaxCN {
					replace `var'=`var'*pondn
				}
				bys year sex : egen pop=sum(pondn)
				bys year sex: egen `loop'tot=sum(pondn*`loop'2)
				gen ymean=`loop'tot/pop
				collapse (sum) sh_r_pretaxCN_foy- sh_nonsal_pretaxCN  (mean) ymean pop,by(year sex dperc)
				bys year sex : egen tot=sum(sh_`loop')
				foreach var of varlist sh* {
					replace `var'=`var'/tot
				}
				
				drop tot 
				sort year sex dperc
				order year sex ymean pop dperc 
				dis $year
				if (${casd}==0 & $year>1970)  {
					append  using "`temp'"
					erase "`temp'"
				}
				
				if (${casd}==1 & $year>1994) {
					append using "`temp'"
					erase "`temp'"
				}
				tempfile temp
				save "`temp'",replace
			}	
			erase "`temp'"
			sort year sex dperc
		save  "$resexp/DINA/gpercr_pretaxCN_foytemp2.dta",replace
		merge 1:m year sex dperc using "$resexp/DINA/gpercr_pretaxCN_foytemp1.dta" 
		sort year sex gperc
		drop _merge
		order year gperc sex n-b y0
		save "$resexp/DINA/gpercr_pretaxCN_foy.dta",replace 
		erase"$resexp/DINA/gpercr_pretaxCN_foytemp1.dta"
		erase "$resexp/DINA/gpercr_pretaxCN_foytemp2.dta"
		import excel using "$resexp/DINA/CASD/gpercr_pretaxCN_foy.xlsx", first clear sheet("Feuil1")  cellrange(A2:AA2415)
		append using "$resexp/DINA/gpercr_pretaxCN_foy.dta" 
		sort year sex gperc
		save "$resexp/DINA/gpercr_pretaxCN_foy.dta",replace 


************************************
* Part B: Fiscal income            *
************************************

* gpercentile by gender + income share and income composition by decile
	
	* B.I) Fiscal income (all, labor, capital) at the individual level: 
	********************************************************************************************************************************************
		*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)
		*(sex =0,1,2) (n = number of individuals in cell)
		
		* a) gpercentile by gender
		**************************
		clear
		foreach loop of newlist r_irpp rtrav_irpp rcap_irpp {
			foreach pas of global yearliste {
				dis `pas'
				dis "`loop'"
				global year=`pas'
				use "$wfrev/rev${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					rename sexe sex
					drop if sex==.
					append using "$wfrev/rev${year}.dta"
					replace sex=0 if sex==.
				}
				* Taxable income
					if ${year}<1988 {
						replace nonsal=nonsal_irpp
					}
					gen rtrav_irpp=pension_irpp+sal_irpp +chom_irpp+0.7*nonsal+rente_irpp_foy*(pac==0)/ndecl 
					if ${year}>=1988{
						gen rcap_irpp=(rfin_int_bar_irpp_foy+rfin_div_irpp_foy+0.3*nonsal_foy+rfon_irpp_foy)*(pac==0)/ndecl 
					}
					if ${year}<1988{
						gen rcap_irpp=(rfin_irpp_foy+0.3*nonsal_foy+rfon_irpp_foy)*(pac==0)/ndecl
					}
					replace rcap_irpp=0 if  pac==1
					gen r_irpp=rtrav_irpp+rcap_irpp
				
					
				* Definition of the percentile by level of income (all, labor or capital)
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen `loop'2=pondn*`loop'
					bys year sex: egen y0=sum(pondn*(`loop'==0))
					collapse (min) y0 thr=`loop' (sum)`loop'2 n=pondn,by(year sex gperc)
					gsort + year sex - gperc
					bys year sex : gen cumul`loop'=sum(`loop'2)
					bys year sex : gen cumulpond=sum(n)
					gen ytop=cumul`loop'/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					bys year sex: egen tot=sum(n)
					replace y0=y0/tot
					drop tot
					keep year gperc sex  n thr  ytop b y0
					order year gperc sex  n thr  ytop b y0
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/DINA/gperc`loop'temp1.dta",replace
		}	
		* b) Add income share and income composition by decile to gperc
		*******************************************************************
		clear
		foreach loop of newlist r rtrav rcap{
			foreach pas of global yearliste {
				global year=`pas'
				dis `pas'
				dis "`loop'"
				use "$wfrev/rev${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					rename sexe sex
					drop if sex==.
					append using "$wfrev/rev${year}.dta"
					replace sex=0 if sex==.
				}
				* Taxable income
					if ${year}<1988 {
						replace nonsal=nonsal_irpp
					}
					replace sal_irpp=sal_irpp+chom_irpp
					drop chom_irpp
					replace pension_irpp=pension_irpp+rente_irpp_foy*(pac==0)/ndecl 
					gen nonsal_labor_irpp=0.7*nonsal
					gen nonsal_capital_irpp=0.3*nonsal_foy*(pac==0)/ndecl
					drop nonsal_irpp
					gen nonsal_irpp=nonsal_labor_irpp+nonsal_capital_irpp
					gen rtrav_irpp=pension_irpp+sal_irpp +nonsal_labor_irpp
					
					if ${year}>=1988 {
						gen rfin_irpp=(rfin_int_bar_irpp_foy+rfin_div_irpp_foy)*(pac==0)/ndecl 
					}
					if ${year}<1988 {
						gen rfin_irpp=rfin_irpp_foy*(pac==0)/ndecl  
					}
					gen rfon_irpp=	rfon_irpp_foy*(pac==0)/ndecl
					gen rcap_irpp=rfin_irpp+rfon_irpp+nonsal_capital_irpp
					gen r_irpp=rtrav_irpp+rcap_irpp
				
				keep year sex pondn  r_irpp rtrav_irpp sal_irpp pension_irpp nonsal_labor_irpp rcap_irpp rfin_irpp rfon_irpp nonsal_capital_irpp nonsal_irpp
				sort year sex 
				#delimit;
				order year sex pondn 
				r_irpp rtrav_irpp  rcap_irpp sal_irpp  pension_irpp nonsal_labor_irpp
				 rfon_irpp nonsal_capital_irpp rfin_irpp nonsal_irpp  ;
				#delimit cr
				
				* Definition of the percentile by level of income (all, labor or capital)
					sort year sex `loop'_irpp
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop'_irpp [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
				
				foreach var of newlist r rtrav  rcap sal  pension nonsal_labor rfon nonsal_capital rfin nonsal	{
					rename `var'_irpp sh_`var'
				}
				gen `loop'2=sh_`loop'
				foreach var of varlist sh_r- sh_nonsal {
					replace `var'=`var'*pondn
				}
				bys year sex : egen pop=sum(pondn)
				bys year sex: egen `loop'tot=sum(pondn*`loop'2)
				gen ymean=`loop'tot/pop
				collapse (sum) sh_r- sh_nonsal  (mean) ymean pop,by(year sex dperc)
					bys year sex : egen tot=sum(sh_r)
					foreach var of varlist sh* {
							replace `var'=`var'/tot
					}
					drop tot 
				sort year sex dperc
				order year sex ymean pop dperc 
				dis $year
				if (${casd}==0 & $year>1970)  {
					append  using "`temp'"
					erase "`temp'"
				}
				
				if (${casd}==1 & $year>1994) {
					append using "`temp'"
					erase "`temp'"
				}
				tempfile temp
				save "`temp'",replace
			}	
			erase "`temp'"
			sort year sex dperc
		save  "$resexp/DINA/gperc`loop'_irpptemp2.dta",replace
		merge 1:m year sex dperc using "$resexp/DINA/gperc`loop'_irpptemp1.dta" 
		sort year sex gperc
		drop _merge
		order year gperc sex n-b y0
		save "$resexp/DINA/gperc`loop'_irpp.dta",replace 
		erase"$resexp/DINA/gperc`loop'_irpptemp1.dta"
		erase "$resexp/DINA/gperc`loop'_irpptemp2.dta"
		import excel using "$resexp/DINA/CASD/gperc`loop'_irpp.xlsx", first clear sheet("Feuil1")  cellrange(A2:U7241)
		append using "$resexp/DINA/gperc`loop'_irpp.dta" 
		sort year sex gperc
		save "$resexp/DINA/gperc`loop'_irpp.dta",replace 

	}

	* B.II) Fiscal income at the tax unit level 
	*********************************************
		*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)
		*(sex =0,1,2) (n = number of tax units in cell)
		
		* a) gpercentile by gender
		****************************
		clear
			foreach pas of global yearliste {
				dis `pas'
				local loop="r_irpp_foy"
				dis "`loop'"
				global year=`pas'
				use "$wfrev/rev${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					rename sexe sex
					drop if sex==.
					append using "$wfrev/rev${year}.dta"
					replace sex=0 if sex==.
				}
				* Tax unit level
					keep if idnum==1 & cal_demo~=1
				* Taxable income
					gen rtrav_irpp_foy=pension_irpp_foy+sal_irpp_foy +chom_irpp_foy+0.7*nonsal_foy+rente_irpp_foy
					if ${year}>=1988{
						gen rcap_irpp_foy=rfin_int_bar_irpp_foy+rfin_div_irpp_foy+0.3*nonsal_foy+rfon_irpp_foy
					}
					if ${year}<1988{
						gen rcap_irpp_foy=(rfin_irpp_foy+0.3*nonsal_foy+rfon_irpp_foy)
					}
					gen r_irpp_foy=rtrav_irpp_foy+rcap_irpp_foy
					keep year sex pondn r_irpp_foy
					
				* Definition of the percentile by level of income (taxable income at the tax unit level) 
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen `loop'2=pondn*`loop'
					bys year sex: egen y0=sum(pondn*(r_irpp_foy==0))
					collapse (min) y0 thr=`loop' (sum)`loop'2 n=pondn,by(year sex gperc)
					gsort + year sex - gperc
					bys year sex : gen cumul`loop'=sum(`loop'2)
					bys year sex : gen cumulpond=sum(n)
					gen ytop=cumul`loop'/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					bys year sex: egen tot=sum(n)
					replace y0=y0/tot
					drop tot
					keep year gperc sex  n thr  ytop b y0
					order year gperc sex  n thr  ytop b y0
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/DINA/gperc`loop'temp1.dta",replace
				
		* b) Add income share and income composition by decile to gperc
		******************************************************************
		clear
			foreach pas of global yearliste {
				global year=`pas'
				dis `pas'
				local loop="r_irpp_foy"
				dis "`loop'"
				use "$wfrev/rev${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					rename sexe sex
					drop if sex==.
					append using "$wfrev/rev${year}.dta"
					replace sex=0 if sex==.
				}
				* Tax unit level
					keep if idnum==1 & cal_demo~=1
				* Taxable income
					replace pension_irpp_foy=pension_irpp_foy+rente_irpp_foy
					drop nonsal_irpp*
					gen nonsal_labor_irpp_foy=0.7*nonsal_foy
					gen nonsal_capital_irpp_foy=0.3*nonsal_foy
					rename nonsal_foy nonsal_irpp_foy
					gen rtrav_irpp_foy=pension_irpp_foy+sal_irpp_foy +chom_irpp_foy +nonsal_labor_irpp_foy
					if ${year}>=1988{
						gen rcap_irpp_foy=rfin_int_bar_irpp_foy+rfin_div_irpp_foy+nonsal_capital_irpp_foy+rfon_irpp_foy
					}
					if ${year}<1988{
						gen rcap_irpp_foy=(rfin_irpp_foy+nonsal_capital_irpp_foy+rfon_irpp_foy)
					}
					gen r_irpp_foy=rtrav_irpp_foy+rcap_irpp_foy
				
				keep year sex pondn  r_irpp_foy rtrav_irpp_foy sal_irpp_foy pension_irpp_foy nonsal_labor_irpp_foy rcap_irpp_foy rfin_irpp_foy rfon_irpp_foy nonsal_capital_irpp_foy nonsal_irpp_foy
				sort year sex 
				#delimit;
				order year sex pondn 
				r_irpp_foy rtrav_irpp_foy  rcap_irpp_foy sal_irpp_foy  pension_irpp_foy nonsal_labor_irpp_foy
				 rfon_irpp_foy nonsal_capital_irpp_foy rfin_irpp_foy nonsal_irpp_foy  ;
				#delimit cr
				
				* Definition of the percentile by level of income (taxable income at the tax unit level) 
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
				
				foreach var of newlist  rtrav  rcap sal  pension nonsal_labor rfon nonsal_capital rfin nonsal	{
					rename `var'_irpp_foy sh_`var'
				}
				rename r_irpp_foy sh_r_irpp_foy
				gen `loop'2=sh_`loop'
				foreach var of varlist sh_r_irpp_foy- sh_nonsal {
					replace `var'=`var'*pondn
				}
				bys year sex : egen pop=sum(pondn)
				bys year sex: egen `loop'tot=sum(pondn*`loop'2)
				gen ymean=`loop'tot/pop
				collapse (sum) sh_r_irpp_foy- sh_nonsal  (mean) ymean pop,by(year sex dperc)
					bys year sex : egen tot=sum(sh_r_irpp_foy)
					foreach var of varlist sh* {
							replace `var'=`var'/tot
					}
					drop tot 
				sort year sex dperc
				order year sex ymean pop dperc 
				dis $year
				if (${casd}==0 & $year>1970)  {
					append  using "`temp'"
					erase "`temp'"
				}
				
				if (${casd}==1 & $year>1994) {
					append using "`temp'"
					erase "`temp'"
				}
				tempfile temp
				save "`temp'",replace
			}	
			erase "`temp'"
			sort year sex dperc
		save  "$resexp/DINA/gperc`loop'temp2.dta",replace
		merge 1:m year sex dperc using "$resexp/DINA/gperc`loop'temp1.dta" 
		sort year sex gperc
		drop _merge
		order year gperc sex n-b y0
		save "$resexp/DINA/gperc`loop'.dta",replace 
		erase"$resexp/DINA/gperc`loop'temp1.dta"
		erase "$resexp/DINA/gperc`loop'temp2.dta"
		import excel using "$resexp/DINA/CASD/gperc`loop'.xlsx", first clear sheet("Feuil1")   cellrange(A2:U7241)
		append using "$resexp/DINA/gperc`loop'.dta"
		sort year sex gperc
		save "$resexp/DINA/gperc`loop'.dta",replace 

	* B.III) Fiscal income among equal-split adults
	*************************************************
		*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)
		*(sex =0,1,2) (n = number of individuals in cell)
		
		* a) gpercentile by gender
		****************************
		clear
			foreach pas of global yearliste {
				dis `pas'
				global year=`pas'
				local loop="r_irpp_equal"
				dis "`loop'"

				use "$wfrev/rev${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					rename sexe sex
					drop if sex==.
					append using "$wfrev/rev${year}.dta"
					replace sex=0 if sex==.
				}
					
				* Taxable income
					if ${year}<1988 {
						replace nonsal=nonsal_irpp
					}
					gen rtrav_irpp_foy=pension_irpp_foy+sal_irpp_foy +chom_irpp_foy+0.7*nonsal_foy+rente_irpp_foy
					if ${year}>=1988{
						gen	rcap_irpp_foy=(rfin_int_bar_irpp_foy+rfin_div_irpp_foy+0.3*nonsal_foy+rfon_irpp_foy)
					}
					if ${year}<1988{
						gen rcap_irpp_foy=(rfin_irpp_foy+0.3*nonsal_foy+rfon_irpp_foy)
					}
					gen r_irpp_foy=rtrav_irpp_foy+rcap_irpp_foy
				
				* Income equally split among couples
					gen r_irpp_equal=r_irpp_foy*(pac==0)/ndecl
					keep year sex pondn r_irpp_equal

				* Definition of the percentile by level of income (equally split taxable income among adults) 
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen `loop'2=pondn*`loop'
					bys year sex: egen y0=sum(pondn*(`loop'==0))
					collapse (min) y0 thr=`loop' (sum)`loop'2 n=pondn,by(year sex gperc)
					gsort + year sex - gperc
					bys year sex : gen cumul`loop'=sum(`loop'2)
					bys year sex : gen cumulpond=sum(n)
					gen ytop=cumul`loop'/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					bys year sex: egen tot=sum(n)
					replace y0=y0/tot
					drop tot
					keep year gperc sex  n thr  ytop b y0
					order year gperc sex  n thr  ytop b y0
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/DINA/gperc`loop'temp1.dta",replace
				
		* b) Add income share and income composition by decile to gperc
		****************************************************************
		clear
			foreach pas of global yearliste {
				global year=`pas'
				dis `pas'
				local loop="r_irpp_equal"
				dis "`loop'"
				use "$wfrev/rev${year}.dta",clear
				if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
					gen sex=0
				}
				if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
					rename sexe sex
					drop if sex==.
					append using "$wfrev/rev${year}.dta"
					replace sex=0 if sex==.
				}
				
				* Taxable income
					replace pension_irpp_foy=pension_irpp_foy+rente_irpp_foy
					drop nonsal_irpp*
					gen nonsal_labor_irpp_foy=0.7*nonsal_foy
					gen nonsal_capital_irpp_foy=0.3*nonsal_foy
					rename nonsal_foy nonsal_irpp_foy
					gen rtrav_irpp_foy=pension_irpp_foy+sal_irpp_foy+chom_irpp_foy +nonsal_labor_irpp_foy
					if ${year}>=1988{
						gen	rcap_irpp_foy=(rfin_int_bar_irpp_foy+rfin_div_irpp_foy+0.3*nonsal_irpp_foy+rfon_irpp_foy)
					}
					if ${year}<1988{
						gen rcap_irpp_foy=(rfin_irpp_foy+0.3*nonsal_irpp_foy+rfon_irpp_foy)
					}
					gen r_irpp_foy=rtrav_irpp_foy+rcap_irpp_foy
					keep year sex pondn  pac ndecl r_irpp_foy rtrav_irpp_foy sal_irpp_foy pension_irpp_foy nonsal_labor_irpp_foy rcap_irpp_foy rfin_irpp_foy rfon_irpp_foy nonsal_capital_irpp_foy nonsal_irpp_foy
					* Income equally split among couples
						foreach var of newlist r_irpp rtrav_irpp sal_irpp pension_irpp nonsal_labor_irpp rcap_irpp rfin_irpp rfon_irpp nonsal_capital_irpp nonsal_irpp {
							gen `var'_equal=`var'_foy*(pac==0)/ndecl
							drop `var'_foy
						}
					
				sort year sex 
				drop pac ndecl
				#delimit;
				order year sex pondn 
				r_irpp_equal rtrav_irpp_equal  rcap_irpp_equal sal_irpp_equal  pension_irpp_equal nonsal_labor_irpp_equal
				 rfon_irpp_equal nonsal_capital_irpp_equal rfin_irpp_equal nonsal_irpp_equal  ;
				#delimit cr
				
				* Definition of the percentile by level of income (equally split taxable income among adults) 
					sort year sex `loop'
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul `loop' [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
				
				foreach var of newlist  rtrav  rcap sal  pension nonsal_labor rfon nonsal_capital rfin nonsal	{
					rename `var'_irpp_equal sh_`var'
				}
				rename r_irpp_equal  sh_r_irpp_equal
				gen `loop'2=sh_`loop'
				foreach var of varlist sh_r_irpp_equal- sh_nonsal {
					replace `var'=`var'*pondn
				}
				bys year sex : egen pop=sum(pondn)
				bys year sex: egen `loop'tot=sum(pondn*`loop'2)
				gen ymean=`loop'tot/pop
				collapse (sum) sh_r_irpp_equal- sh_nonsal  (mean) ymean pop,by(year sex dperc)
					bys year sex : egen tot=sum(sh_r_irpp_equal)
					foreach var of varlist sh* {
							replace `var'=`var'/tot
					}
					drop tot 
				sort year sex dperc
				order year sex ymean pop dperc 
				dis $year
				if (${casd}==0 & $year>1970)  {
					append  using "`temp'"
					erase "`temp'"
				}
				
				if (${casd}==1 & $year>1994) {
					append using "`temp'"
					erase "`temp'"
				}
				tempfile temp
				save "`temp'",replace
			}	
			erase "`temp'"
			sort year sex dperc
		save  "$resexp/DINA/gperc`loop'temp2.dta",replace
		merge 1:m year sex dperc using "$resexp/DINA/gperc`loop'temp1.dta" 
		sort year sex gperc
		drop _merge
		order year gperc sex n-b y0
		save "$resexp/DINA/gperc`loop'.dta",replace 
		erase"$resexp/DINA/gperc`loop'temp1.dta"
		erase "$resexp/DINA/gperc`loop'temp2.dta"
		import excel using "$resexp/DINA/CASD/gperc`loop'.xlsx", first clear sheet("Feuil1")   cellrange(A2:U7241)
		append using "$resexp/DINA/gperc`loop'.dta"
		sort year sex gperc
		save "$resexp/DINA/gperc`loop'.dta",replace 

**********************************************************************************************************
*Part C: DINA income by age and gender (Pretax income or labor pretax income at the individual level)    * 
**********************************************************************************************************

	* C.I)  Pretax income among equal-split adults by decenial aged and broad income groups
	*****************************************************************************************
		*Statafile columns: year, bperc, aged, thr, ytop, b
		* (bperc = 0, 10, 50, 90, 99, 99.5, 99.9)
		* (aged = 20, 30, 40, 50, etc., 80+)
		clear
		foreach pas of global yearliste {
				global year=`pas'
			
			* Load the dataset
				use year idindiv idfoy pac ndecl pondn  age rcap_cn using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
				merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN)
				drop _merge
			
			* Create the variables used 	
				* Income equally split among couples
					bys idfoy: egen rtrav_pretaxCNtot=sum(rtrav_pretaxCN*(pac==0))
					replace rtrav_pretaxCN=rtrav_pretaxCNtot/2 if pac==0 & ndecl==2
					drop rtrav_pretaxCNtot 
				gen y =rtrav_pretaxCN+rcap_cn
				gen aged=int(age/10)
				drop if aged==.
				replace aged=8 if aged>8
				
			* Definition of income groups by broad age groups
				sort year aged y
				gen pondvr=round(100*pondn) 
				bys year aged : cumul y [w=pondvr], gen (p100)
				gen p10=p100*100
				gen bperc   = 0
				replace bperc=10  if p10 >=10 & p10 <50 & bperc==0
				replace bperc=50  if p10 >=50 & p10 <90 & bperc==0
				replace bperc= 90   if p10 >=90 & p10 <99 & bperc==0
				replace bperc= 99   if p10 >=99 & p10 <99.5 & bperc==0
				replace bperc= 995   if p10 >=99.5 & p10 <99.9 & bperc==0
				replace bperc= 999   if p10 >=99.9  & bperc==0
				drop p10 p100 pondvr

			* Compute the stats 
				keep bperc year aged y pondn
				sort year aged bperc
				bys year aged: egen pop_aged=sum(pondn)
				bys year aged: egen ytot_aged=sum(pondn*y)
				gen ymean_aged=ytot/pop_aged
				gen y2=y
				foreach var of varlist y  {
					replace `var'=`var'*pondn
				}
				collapse (min) thr=y2 (sum) share_bperc_aged=y n=pondn (mean) ymean_aged pop_aged ytot_aged  ,by(year aged bperc)
				* Cumulative au-del du seuil et coef de Pareto
					gsort year aged  - bperc
					bys year aged:gen ytemp=sum(share_bperc)
					bys year aged:gen poptemp=sum(n)
					gen ytop=ytemp/poptemp
					gen b=ytop/thr
				* Share	
					replace share_bperc=share_bperc_aged/ytot_aged
				
			* Clean	
				drop  ytot_aged ytemp poptemp
				sort year aged bperc
				order year aged ymean_aged pop_aged bperc
				
			* Save the dataset
				dis $year
				if (${casd}==0 & $year>1970)  {
					append  using "`temp'"
					erase "`temp'"
				}
				
				if (${casd}==1 & $year>1994) {
					append using "`temp'"
					erase "`temp'"
				}
				tempfile temp
				save "`temp'",replace
	}	
			erase "`temp'"
			sort year aged bperc
			save "$resexp/DINA/bperc_aged_income_equal.dta",replace 
			import excel using "$resexp/DINA/CASD/bperc_aged_income_equal.xlsx", first clear sheet("Feuil1")  cellrange(A2:J933)
			append using "$resexp/DINA/bperc_aged_income_equal.dta"
			sort year aged bperc
			save "$resexp/DINA/bperc_aged_income_equal.dta",replace 
	
	* C.II) Pretax income by age and sex (equal-split adults vs individualistic adults)  
	****************************************************************************************
		* Statafile columns: year, sex, age, n, yav
		clear
	foreach loop of newlist r_pretaxCN r_pretaxCN_equal {
		foreach pas of global yearliste {
				global year=`pas'
		
		* Load the dataset
			use year idindiv idfoy pac ndecl pondn rcap_cn age using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
				gen sex=0
				merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN)
				gen a =1
			}
			if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
				merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
				rename sexe sex
				drop if sex==.
				drop _merge
				gen a =1
				append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keep(year idindiv idfoy pac ndecl pondn rcap_cn age)
				merge m:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN)
				drop _merge  idindiv
				replace sex=0 if sex==.
				replace a=2 if a ==.
			}
		* Clean and create the variables used
			if "`loop'"=="r_pretaxCN_equal" {
				* Income equally split among couples
					bys a idfoy: egen rtrav_pretaxCNtot=sum(rtrav_pretaxCN*(pac==0))
					replace rtrav_pretaxCN=rtrav_pretaxCNtot/2 if pac==0 & ndecl==2
					drop rtrav_pretaxCNtot 
			}
			gen y =rtrav_pretaxCN+rcap_cn
			replace age=81 if age>80
			keep year age sex y pondn rtrav_pretaxCN rcap_cn
		* Compute the stats
			sort year age
			foreach var of varlist y rtrav_pretaxCN rcap_cn {
				replace `var'=`var'*pondn
			}
			collapse (sum) yav=y n=pondn  rtrav_pretaxCN rcap_cn ,by(year sex age)
			foreach var of varlist yav rtrav_pretaxCN rcap_cn  {
				replace `var'=`var'/n
			}
		* Save the dataset
			dis $year
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
			
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
			tempfile temp
			save "`temp'",replace
}	
		erase "`temp'"
		sort year sex age
		if "`loop'"=="r_pretaxCN_equal" {
			save "$resexp/DINA/income_age_sex_equal.dta",replace 
			import excel using "$resexp/DINA/CASD/income_age_sex_equal.xlsx", first clear sheet("Feuil1")  cellrange(A2:G3536)
			append using "$resexp/DINA/income_age_sex_equal.dta"
			sort year sex age
			save "$resexp/DINA/income_age_sex_equal.dta",replace 
		}
		if "`loop'"=="r_pretaxCN" {
			save "$resexp/DINA/income_age_sex.dta",replace 
			import excel using "$resexp/DINA/CASD/income_age_sex.xlsx", first clear sheet("Feuil1")  cellrange(A2:G3536)
			append using "$resexp/DINA/income_age_sex.dta"
			sort year sex age
			save "$resexp/DINA/income_age_sex.dta",replace 
		}
	}
	

	* C.III)Pretax income by decenial age and sex (equal-split adults vs individualistic adults)
	**************************************************************************************************
		* Statafile columns: year, sex, aged, n, yav, shhousing, shares
		clear		
	foreach loop of newlist r_pretaxCN  r_pretaxCN_equal {
		foreach pas of global yearliste {
				global year=`pas'
		* Load the dataset
			use year idindiv idfoy pac ndecl pondn  age r* nonsal* using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
				merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(*_pretaxCN)
				gen sex=0
				gen a =1
			}
			if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
				merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
				rename sexe sex
				drop _merge 
				drop if sex==.
				gen a =1
				append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta"
				merge m:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(*_pretaxCN)
				replace sex=0 if sex==.
				drop _merge idindiv
				replace a=2 if a==.
			}
		* Clean the variables used
			keep year sex age a idfoy ndecl pac pondn r* nonsal* *_pretaxCN
			replace sal_pretaxCN = sal_pretaxCN+  chom_pretaxCN
			drop chom_pretaxCN
			if "`loop'"=="r_pretaxCN_equal" {
				* Income equally split among couples
					foreach var of varlist rtrav_pretaxCN sal_pretaxCN nonsal_labor_pretaxCN pension_pretaxCN  {
						bys a idfoy: egen `var'tot=sum(`var'*(pac==0))
						replace `var'=`var'tot/2 if pac==0 & ndecl==2
						drop `var'tot
					}
					replace nonsal_pretaxCN=nonsal_labor_pretaxCN+nonsal_capital_cn
			}
			drop a idfoy ndecl pac		
			gen y=rtrav_pretaxCN+rcap_cn
			gen rfin_cn=rfin_div_cn+ rfin_int_cn+ rfin_liqu_cn+ rfin_av_cn
			
			gen aged=int(age/10)
			replace aged=8 if aged>8
			#delimit;
				order year sex aged age pondn 
				y rtrav_pretaxCN rcap sal_pretaxCN pension_pretaxCN nonsal_labor_pretaxCN
				 rfon_cn rfon_owner_cn rfon_rent_cn nonsal_capital_cn 
				rfin_cn rfin_div_cn rfin_int_cn rfin_liqu_cn rfin_av_cn  ;
			#delimit cr
			foreach var of newlist rcap rfon rfon_owner rfon_rent nonsal_capital rfin rfin_div rfin_int rfin_liqu rfin_av{
				rename `var'_cn sh_`var'
			}
			foreach var of newlist nonsal rtrav nonsal_labor pension sal {
				rename `var'_pretaxCN sh_`var'
			}
		* Compute the stats 
			foreach var of varlist y-sh_nonsal  {
				replace `var'=`var'*pondn
			}
			bys year sex: egen ytot=sum(y)
			collapse (sum) y-sh_nonsal  n=pondn (mean) ytot,by(year sex aged)
			foreach var of varlist sh_rtrav-sh_nonsal  {
				replace `var' =`var'/y
			}
			gen yav=y/n
			gen sh_aged_sex = y/ytot
			drop ytot y	
		* Save the dataset
			dis $year
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
			
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
			tempfile temp
			save "`temp'",replace
}	
		erase "`temp'"
		sort year sex aged
		order year sex aged n yav sh_aged_sex
		if "`loop'"=="r_pretaxCN" {
			save "$resexp/DINA/income_aged_sex.dta",replace 
			import excel using "$resexp/DINA/CASD/income_aged_sex.xlsx", first clear sheet("Feuil1")  cellrange(A2:U401)
			append using "$resexp/DINA/income_aged_sex.dta"
			sort year sex aged
			save "$resexp/DINA/income_aged_sex.dta",replace 
		}
		if "`loop'"=="r_pretaxCN_equal" {
			save "$resexp/DINA/income_aged_sex_equal.dta",replace 
			import excel using "$resexp/DINA/CASD/income_aged_sex_equal.xlsx", first clear sheet("Feuil1")  cellrange(A2:U401)
			append using "$resexp/DINA/income_aged_sex_equal.dta"
			sort year sex aged
			save "$resexp/DINA/income_aged_sex_equal.dta",replace 
		}
	}
		
	* C.IV) Pretax income by broad age groups and broad income groups among equal-split adults 
	**************************************************************************
		* Statafile year, bperc, bage, thr, ytop, b, share
		* (bperc = 0, 10, 50, 90, 99, 99.5, 99.9)
		* (bage = 20-39, 40-59, 60+)
		clear
		foreach pas of global yearliste {
				global year=`pas'
		* Load the dataset
			use year idindiv idfoy pac ndecl pondn  age r* nonsal* using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(*_pretaxCN)
			drop _merge
		
		* Income equally split among couples
			bys idfoy: egen rtrav_pretaxCNtot=sum(rtrav_pretaxCN*(pac==0))
			replace rtrav_pretaxCN=rtrav_pretaxCNtot/2 if pac==0 & ndecl==2
			drop rtrav_pretaxCNtot 
			
			gen y =rtrav_pretaxCN+rcap_cn
			gen bage=int(age/10)*10
			replace bage=20 if bage==30
			replace bage=40 if bage==50
			replace bage=60 if bage>60
			drop if age==.
			
		* Definition of income groups by broad age groups
			sort year bage y
			gen pondvr=round(100*pondn) 
			bys year bage : cumul y [w=pondvr], gen (p100)
			gen p10=p100*100
			gen bperc   = 0
			replace bperc=10  if p10 >=10 & p10 <50 & bperc==0
			replace bperc=50  if p10 >=50 & p10 <90 & bperc==0
			replace bperc= 90   if p10 >=90 & p10 <99 & bperc==0
			replace bperc= 99   if p10 >=99 & p10 <99.5 & bperc==0
			replace bperc= 995   if p10 >=99.5 & p10 <99.9 & bperc==0
			replace bperc= 999   if p10 >=99.9  & bperc==0
			drop p10 p100 pondvr

		* Clean the variables used
			keep bperc year bage y *_cn *_pretaxCN pondn
			gen rfin_cn=rfin_div_cn+ rfin_int_cn+ rfin_liqu_cn+ rfin_av_cn
			replace sal_pretaxCN = sal_pretaxCN+  chom_pretaxCN
			drop chom_pretaxCN
			foreach var of newlist rcap rfon rfon_owner rfon_rent nonsal_capital rfin_div rfin_int rfin_liqu rfin_av rfin {
				rename `var'_cn sh_`var'
			}
			foreach var of newlist nonsal rtrav nonsal_labor pension sal {
				rename `var'_pretaxCN sh_`var'
			}
			#delimit;
				order year pondn bperc bage y sh_rtrav  sh_rcap sh_sal sh_pension sh_nonsal_labor sh_nonsal_capital sh_rfon sh_rfon_owner sh_rfon_rent
				sh_rfin sh_rfin_div sh_rfin_int sh_rfin_liqu sh_rfin_av sh_nonsal  ;
			#delimit cr
			sort year bage bperc
		* Compute the stats 	
			bys year bage: egen pop_bage=sum(pondn)
			bys year bage: egen ytot_bage=sum(pondn*y)
			gen ymean_bage=ytot_bage/pop_bage
			gen y2=y
			foreach var of varlist y sh_rtrav- sh_nonsal  {
				replace `var'=`var'*pondn
			}
			collapse (min) thr=y2 (sum) share_bperc_bage=y n=pondn sh_rtrav- sh_nonsal (mean) ymean_bage pop_bage ytot_bage  ,by(year bage bperc)
			* Cumulative au-del du seuil et coef de Pareto
				gsort year bage  - bperc
				bys year bage:gen ytemp=sum(share_bperc)
				bys year bage:gen poptemp=sum(n)
				gen ytop=ytemp/poptemp
				gen b=ytop/thr
			* income composition
				foreach var of varlist sh_rtrav- sh_nonsal  {
					replace `var'=`var'/share_bperc_bage
				}
			* Share	
				replace share_bperc_bage=share_bperc_bage/ytot_bage
				drop  ytot_bage ytemp poptemp
				sort year bage bperc
				order year bage ymean_bage pop_bage bperc n  share_bperc_bage thr ytop b
		* Save the dataset
			dis $year
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
			
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
			tempfile temp
			save "`temp'",replace
}	
		erase "`temp'"
		sort year bage bperc
		save "$resexp/DINA/bperc_bage_income_equal.dta",replace 
		import excel using "$resexp/DINA/CASD/bperc_bage_income_equal.xlsx", first clear sheet("Feuil1")  cellrange(A2:Y401)
		append using "$resexp/DINA/bperc_bage_income_equal.dta"
		sort year bage bperc
		save "$resexp/DINA/bperc_bage_income_equal.dta",replace 


	* C.V) Income inequality by gender (Pre-tax labor income among individualistic adults)
	****************************************************************************************

	* a)Proportion of women in top 10%, top 1% and top 0.1% of labor income distribution
	*************************************************************************************
	forval i=1/2{
	foreach pas of global yearliste2 {
		global year=`pas'
		dis `pas'
		use "$wfrevtravcn/revtravcn${year}.dta",clear
		merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe age)
		drop if sexe==.
		if `i'==2{
			drop if age>=60
		}
		keep year pondn rtrav_pretaxCN sexe
			
		* Definition of the percentile by level of labor pretax national income
			sort year rtrav_pretaxCN
			gen pondvr=round(1000*pondn) 
			bys year  : cumul rtrav_pretaxCN [w=pondvr], gen (p100)
			replace p100=p100*100
			replace p100=p100*10 if p100>=99
			replace p100=p100*10 if p100>=999


		* P50, P90, P99, P99.9, P99.99 
			sum rtrav_pretaxCN [aw=pondn]
			local tot=r(sum)
			foreach num of numlist 50 90 990 9990  {
				bys year : egen thr_`num'=max(rtrav_pretaxCN*(p100<=`num'))
				bys year : egen number_`num'=sum(pondn*(rtrav_pretaxCN>=thr_`num'))
				bys year : egen prop_w`num'=sum(pondn*(rtrav_pretaxCN>=thr_`num')*(sexe==2)/number_`num')
				bys year : egen share`num'=sum(pondn*rtrav_pretaxCN*(rtrav_pretaxCN>=thr_`num')/`tot')
				bys year : egen share_w_`num'=sum(pondn*rtrav_pretaxCN*(rtrav_pretaxCN>=thr_`num')*(sexe==2)/`tot')
				drop thr* number*
			}
		keep year prop_w* share*
		keep if _n==1
		if (${casd}==0 & $year>1970)  {
			append  using "`temp'"
			erase "`temp'"
		}
		
		if (${casd}==1 & $year>1994) {
			append using "`temp'"
			erase "`temp'"
		}
		tempfile temp
		save "`temp'",replace
	}	
		erase "`temp'"
		sort year
		order year prop_w*
		if `i'==1{
			save  "$resexp/DINA/genderall.dta",replace
		}
		if `i'==2{
			save  "$resexp/DINA/gender2059.dta",replace
		}
	}
	import excel using "$resexp/DINA/CASD/genderall.xls", first clear sheet("Feuil1")  cellrange(A2:M21)
	append using  "$resexp/DINA/genderall.dta"
	sort year 
	save  "$resexp/DINA/genderall.dta",replace
	
	import excel using "$resexp/DINA/CASD/gender2059.xls", first clear sheet("Feuil1")  cellrange(A2:M21)
	append using  "$resexp/DINA/gender2059.dta"
	sort year
	save  "$resexp/DINA/gender2059.dta",replace

**************************************************************************************
*Part D: Correlation between wealth, total income, capital income and labor income   * 
**************************************************************************************

* D.1) Correlation for all population conditional on 5-year age groups
************************************************************************

foreach pas of global yearliste {
	global year=`pas'
	dis `pas'
	use year idindiv idfoy pac ndecl pondn  pat_cn rcap_cn age using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
	merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(rtrav_pretaxCN)
	drop  _merge
	gen r_pretaxCN=rcap_cn+rtrav_pretaxCN
	rename rcap_cn rcap
					
		* Income equally split among couples
			foreach var of varlist rtrav_pretaxCN r_pretaxCN  {
				bys a idfoy: egen `var'tot=sum(`var'*(pac==0))
				replace `var'=`var'tot/2 if pac==0 & ndecl==2
				drop `var'tot
			}
			
		* Age groups
			gen age_group=int((min(80,age)-20)/5)
			
		* Definition of the percentile by wealth
			sort year pat_cn
			gen pondvr=round(1000*pondn) 
			bys year age_group : cumul pat_cn [w=pondvr], gen (p100)
			replace p100=p100*100
			* Par centile
				gen py_w   = int(p100)*1000
			* Au sein du dernier centile
				replace py_w=int(p100*10)*100 if py_w==99000 
			* Au sein du dernier millime
				replace py_w=int(p100*100)*10 if py_w==99900 
			* Au sein du dernier dix-millime
				replace py_w=int(p100*1000) if py_w==99990 
				replace py_w=py_w[_n-1] if p100==100
			drop p100 	
					
			
		* Definition of the percentile by total income
			sort year r_pretaxCN
			bys year age_group: cumul r_pretaxCN [w=pondvr], gen (p100)
			replace p100=p100*100
			* Par centile
				gen py_y   = int(p100)*1000
			* Au sein du dernier centile
				replace py_y=int(p100*10)*100 if py_y==99000 
			* Au sein du dernier millime
				replace py_y=int(p100*100)*10 if py_y==99900 
			* Au sein du dernier dix-millime
				replace py_y=int(p100*1000) if py_y==99990 
				replace py_y=py_y[_n-1] if p100==100
			drop p100 
			
		* Definition of the percentile by labor income
			sort year rtrav_pretaxCN
			bys year age_group: cumul rtrav_pretaxCN [w=pondvr], gen (p100)
			replace p100=p100*100
			* Par centile
				gen py_yl   = int(p100)*1000
			* Au sein du dernier centile
				replace py_yl=int(p100*10)*100 if py_yl==99000 
			* Au sein du dernier millime
				replace py_yl=int(p100*100)*10 if py_yl==99900 
			* Au sein du dernier dix-millime
				replace py_yl=int(p100*1000) if py_yl==99990 
				replace py_yl=py_yl[_n-1] if p100==100
			drop p100 
			
		* Definition of the percentile by capital income
			sort year rcap
			bys year age_group : cumul rcap [w=pondvr], gen (p100)
			replace p100=p100*100
			* Par centile
				gen py_yk   = int(p100)*1000
			* Au sein du dernier centile
				replace py_yk=int(p100*10)*100 if py_yk==99000 
			* Au sein du dernier millime
				replace py_yk=int(p100*100)*10 if py_yk==99900 
			* Au sein du dernier dix-millime
				replace py_yk=int(p100*1000) if py_yk==99990 
				replace py_yk=py_yk[_n-1] if p100==100
			drop p100 

	keep py* year pondn	
	tempfile data
	save "`data'", replace

	* Transition matrix wealth * Total income
		use "`data'",clear
		collapse (sum) proba=pondn, by (year py_w py_y)
		rename proba w_gr
		reshape wide w_gr, i(year py_y) j(py_w)
		foreach var of varlist w_gr* {
			replace `var'=0 if `var'==.
		}
		gen type="Total income"
		rename py_y py
		tempfile temp1
		save "`temp1'",replace
		
	* Transition matrix wealth * capital income
		use "`data'",clear
		collapse (sum) proba=pondn, by (year py_w py_yk)
		rename proba w_gr
		reshape wide w_gr, i(year py_yk) j(py_w)
		foreach var of varlist w_gr* {
			replace `var'=0 if `var'==.
		}
		gen type="Capital income"
		rename py_yk py
		append using "`temp1'"
		erase "`temp1'"
		tempfile temp1
		save "`temp1'",replace
		
	* Transition matrix wealth * labor income
		use "`data'",clear
		collapse (sum) proba=pondn, by (year py_w py_yl)
		rename proba w_gr
		reshape wide w_gr, i(year py_yl) j(py_w)
		foreach var of varlist w_gr* {
			replace `var'=0 if `var'==.
		}
		gen type="Labor income"
		rename py_yl py
		append using "`temp1'"
		erase "`temp1'"
		erase "`data'"
				
		if (${casd}==0 & $year>1970)  {
			append  using "`temp'"
			erase "`temp'"
		}
		
		if (${casd}==1 & $year>1994) {
			append using "`temp'"
			erase "`temp'"
		}
		tempfile temp
		save "`temp'",replace
	}	
	erase "`temp'"
	sort year type py 
	order year type py
	save  "$resexp/DINA/matrixwealthincome.dta",replace
	import excel using "$resexp/DINA/CASD/matrixwealthincome.xlsx", first clear sheet("feuil1")  cellrange(A2:EA7241)
	drop n
	append using "$resexp/DINA/matrixwealthincome.dta"
	sort year type py 
	save  "$resexp/DINA/matrixwealthincome.dta",replace		

	
	
	
	
	