****************************************************************
* Do-file used to create harmonized ISF tabulations 1984-2013	*
****************************************************************

***********************
* I) Period 1984-2010 *
***********************

	* A) Importation of parameters
	*********************************
		
		* Number of households
			import excel using "$resultsISF/RawResults_ApG.xlsx", first clear sheet("TG2")  cellrange(A7:W40)
			keep year nmen wealthNA nindiv
			tempfile nmen wealthNA nindiv
			save "`nmen'",replace
		
		* Thresholds of wealth tax by tax brackets
			import excel using "$resultsISF/RawResults_ApG.xlsx", first clear sheet("TG1")  cellrange(A7:G40)
			reshape long thrisf,i(year) j(tranche)
			replace thrisf=thrisf/6.55957 if year<2002
			keep if year>=1984
			* For year 1984 and 1985, this is not tax brackets but specific wealth brackets
				replace thrisf=518327 if year==1984 & tranche==1
				replace thrisf= 762245  if year==1984 & tranche==2
				replace thrisf= 1524490   if year==1984 & tranche==3
				replace thrisf=4573471   if year==1984 & tranche==4
				replace thrisf= 15244902 if year==1984 & tranche==5

				replace thrisf=533572   if year==1985 & tranche==1
				replace thrisf=762245   if year==1985 & tranche==2
				replace thrisf=1524490  if year==1985 & tranche==3
				replace thrisf=4573471  if year==1985 & tranche==4
				replace thrisf= 15244902  if year==1985 & tranche==5
			replace thrisf=thrisf/1000
			tempfile temp
			save "`temp'",replace


		* Number of taxpayers and total taxable wealth by tax brackets 1994-2002
			import excel using "$resultsISF/RawResults_ApG.xlsx", first clear sheet("TG4")  cellrange(A7:O15)
			drop *tot
			reshape long Nisf Yisf,i(year) j(tranche)
			merge 1:1 year tranche using "`temp'"
			drop _merge
			sort year tranche
			erase "`temp'"
			tempfile temp
			save "`temp'",replace
			
			
		* Number of taxpayers and total taxable wealth by tax brackets 1984-2010
			import excel using "$resultsISF/RawResults_ApG.xlsx", first clear sheet("TG2")  cellrange(A7:N40)
			keep if year<=2010 
			drop if year>=1995 & year<=2002
			drop H 
			reshape long Nisf Yisf,i(year) j(tranche)
			merge 1:1 year tranche using "`temp'"
			drop _merge
			sort year tranche
			
		merge m:1 year using "`nmen'"
		* Drop missing years
			drop if year<1984 | (year>=1986 & year<1993) | year==1994 | year>2010
			drop _merge
	
	* B) Compute new parameters
	****************************

		* Average wealth above threshold and b coefficient
			gsort + year - tranche
			bys year : gen cumulNisf=sum(Nisf)
			bys year : gen cumulYisf=sum(Yisf)
			foreach var of varlist cumulNisf cumulYisf {
				replace `var'=. if `var'==0
			}
			gen Ytopisf=cumulYisf/cumulNisf*1000
		
		* b coefficient : Top average/threshold
			gen b=Ytopisf/thrisf
		
		* Pareto coef by tax brackets using cumulative of wealth and threshold: 1+log(P(si)/(P(si+1)/log(si+1/si))
			sort year tranche
			gen btranche=1+ln(cumulYisf/cumulYisf[_n+1])/ln(thrisf[_n+1]/thrisf) if tranche[_n+1]~=1
			replace btranche=btranche/(btranche-1)
		* Percentile 
			gen p=(1-cumulNisf/nmen/1000)*100
		save "$resultsISF/StataFiles/ISFtab19842010.dta",replace
		
		* Exportation
			drop p nmen wealthNA nindiv
			reshape wide Nisf Yisf thrisf cumulNisf cumulYisf Ytopisf b btranche,i(tranche) j(year)
			drop cumulYisf* Yisf* Nisf*
			order tranche thrisf* Ytopisf* cumulNisf* b* 
			order btranche*,last

			tempfile temp1
			save "`temp1'",replace
			keep thrisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG2")  sheetmodify cell(B7)  nolabel
			use "`temp1'",clear
			keep Ytopisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG2")  sheetmodify cell(B14)  nolabel
			use "`temp1'",clear
			keep cumulNisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG2")  sheetmodify cell(B21)  nolabel
			use "`temp1'",clear
			keep b????
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG2")  sheetmodify cell(B28)  nolabel
			use "`temp1'",clear
			keep btranche*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG2")  sheetmodify cell(B35)  nolabel
			erase "`temp1'"
			
	* C) Correction for avoidance around the first tax bracket
	*************************************************************
		use "$resultsISF/StataFiles/ISFtab19842010.dta",clear
		* Replace the pareto coefficient of the first tax bracket by that of the second
			replace btranche=btranche[_n+1] if tranche==1
			gen a =btranche/(btranche-1)
		* Compute total wealth above the first bracket
			replace cumulYisf=cumulYisf[_n+1]*(thrisf[_n+1]/thrisf)^(a-1) if tranche==1
		* Compute number of taxpayers above the first bracket
			replace cumulNisf=cumulNisf[_n+1]*(cumulYisf[_n]/cumulYisf[_n+1])^(btranche) if tranche==1
		* AVerage wealth above the treshold
			replace Ytopisf=cumulYisf/cumulNisf*1000  if tranche==1
		* Number of taxpayers in the first tax bracket
			replace Nisf=cumulNisf-cumulNisf[_n+1] if tranche==1
		* Taxable wealth in the first tax bracket
			replace Yisf=cumulYisf-cumulYisf[_n+1] if tranche==1
		* b coefficient
			replace b=Ytopisf/thrisf if tranche==1
			drop a
		* Percentile 
			replace p=(1-cumulNisf/nmen/1000)*100
		save "$resultsISF/StataFiles/ISFtab19842010cor.dta",replace
		
		* Exportation
			drop p nmen wealthNA nindiv
			reshape wide Nisf Yisf thrisf cumulNisf cumulYisf Ytopisf b btranche,i(tranche) j(year)
			drop cumulYisf* Yisf* Nisf*
			order tranche thrisf* Ytopisf* cumulNisf* b* 
			order btranche*,last

			tempfile temp1
			save "`temp1'",replace
			keep thrisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG4")  sheetmodify cell(B7)  nolabel
			use "`temp1'",clear
			keep Ytopisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG4")  sheetmodify cell(B14)  nolabel
			use "`temp1'",clear
			keep cumulNisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG4")  sheetmodify cell(B21)  nolabel
			use "`temp1'",clear
			keep b????
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG4")  sheetmodify cell(B28)  nolabel
			use "`temp1'",clear
			keep btranche*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG4")  sheetmodify cell(B35)  nolabel
			erase "`temp1'"

***********************
* I) Period 2012-2016 *
***********************

	* A) Importation of parameters
	*********************************
		* Number of households
			import excel using "$resultsISF/RawResults_ApG.xlsx", first clear sheet("TG2")  cellrange(A7:W40)
			keep year nmen wealthNA nindiv
			tempfile nmen 
			save "`nmen'",replace
			
		import excel using "$resultsISF/RawResults_ApG.xlsx", first clear sheet("TG3stata")  cellrange(A4:J14)
		reshape long thrisf Nisf Yisf,i(tranche) j(year)
		merge m:1 year using "`nmen'"
		sort year tranche
		keep if _merge==3
		drop _merge
		
	* B) Compute new parameters
	****************************

		* Average wealth above threshold and b coefficient
			gsort + year - tranche
			bys year : gen cumulNisf=sum(Nisf)
			bys year : gen cumulYisf=sum(Yisf)
			foreach var of varlist cumulNisf cumulYisf {
				replace `var'=. if `var'==0
			}
			gen Ytopisf=cumulYisf/cumulNisf*1000
		
		* b coefficient : Top average/threshold
			gen b=Ytopisf/thrisf
		
		* Pareto coef by tax brackets using cumulative of wealth and threshold: 1+log(P(si)/(P(si+1)/log(si+1/si))
			sort year tranche
			gen btranche=1+ln(cumulYisf/cumulYisf[_n+1])/ln(thrisf[_n+1]/thrisf) if tranche[_n+1]~=1
			replace btranche=btranche/(btranche-1)
			
		* Percentile 
			gen p=(1-cumulNisf/nmen/1000)*100
		save "$resultsISF/StataFiles/ISFtab20122016.dta",replace
		
		* Exportation
			drop p nmen wealthNA nindiv
			reshape wide Nisf Yisf thrisf cumulNisf cumulYisf Ytopisf b btranche,i(year) j(tranche)
			drop cumulYisf* Yisf* Nisf*
			order year thrisf* Ytopisf* cumulNisf* b* 
			order btranche*,last

			tempfile temp1
			save "`temp1'",replace
			keep thrisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG3")  sheetmodify cell(B7)  nolabel
			use "`temp1'",clear
			keep Ytopisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG3")  sheetmodify cell(B11)  nolabel
			use "`temp1'",clear
			keep cumulNisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG3")  sheetmodify cell(B15)  nolabel
			use "`temp1'",clear
			keep b? b10
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG3")  sheetmodify cell(B19)  nolabel
			use "`temp1'",clear
			keep btranche*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG3")  sheetmodify cell(B23)  nolabel
			erase "`temp1'"
	
	* C) Correction for avoidance around the first tax bracket
	*************************************************************
		use "$resultsISF/StataFiles/ISFtab20122016.dta",clear

		* Replace the pareto coefficient of the first tax bracket by that of the second
			replace btranche=btranche[_n+1] if tranche==1
			gen a =btranche/(btranche-1)
		* Compute total wealth above the first bracket
			replace cumulYisf=cumulYisf[_n+1]*(thrisf[_n+1]/thrisf)^(a-1) if tranche==1
		* Compute number of taxpayers above the first bracket
			replace cumulNisf=cumulNisf[_n+1]*(cumulYisf[_n]/cumulYisf[_n+1])^(btranche) if tranche==1
		* AVerage wealth above the treshold
			replace Ytopisf=cumulYisf/cumulNisf*1000  if tranche==1
		* Number of taxpayers in the first tax bracket
			replace Nisf=cumulNisf-cumulNisf[_n+1] if tranche==1
		* Taxable wealth in the first tax bracket
			replace Yisf=cumulYisf-cumulYisf[_n+1] if tranche==1
		* b coefficient
			replace b=Ytopisf/thrisf if tranche==1
			drop a
		* Percentile 
			replace p=(1-cumulNisf/nmen/1000)*100
		save "$resultsISF/StataFiles/ISFtab20122016cor.dta",replace
		
		* Exportation
			drop p nmen wealthNA nindiv
			reshape wide Nisf Yisf thrisf cumulNisf cumulYisf Ytopisf b btranche,i(year) j(tranche)
			drop cumulYisf* Yisf* Nisf*
			order year thrisf* Ytopisf* cumulNisf* b* 
			order btranche*,last

			tempfile temp1
			save "`temp1'",replace
			keep thrisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG5")  sheetmodify cell(B7)  nolabel
			use "`temp1'",clear
			keep Ytopisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG5")  sheetmodify cell(B11)  nolabel
			use "`temp1'",clear
			keep cumulNisf*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG5")  sheetmodify cell(B15)  nolabel
			use "`temp1'",clear
			keep b? b10
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG5")  sheetmodify cell(B19)  nolabel
			use "`temp1'",clear
			keep btranche*
			export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG5")  sheetmodify cell(B23)  nolabel
			
/* III) Exportation of wealt tax tabulations for Pareto-interpolations
************************************************************************
	* No correction for avoidance in the first tax bracket
		use "$resultsISF/StataFiles/ISFtab19842010.dta",clear
		append using "$resultsISF/StataFiles/ISFtab20122016.dta"
		sort year tranche
		keep year tranche b p thrisf
		rename thrisf thr
		replace thr =thr*1000
		replace p=p/100
		order year tranche thr p b
		* Add P0
			expand 2 if tranche==1
			replace tranche=0 if _n==_N | (tranche ==1 & tranche[_n+1]==1)
			replace thr=0 if tranche==0
			replace p=0 if tranche==0
			replace b=. if tranche==0
		reshape wide thr  p b,i(tranche) j(year)
		sort tranche
		drop tranche
		export excel using "$resultsISF/RawResults_ApG.xlsx", sheet("TG5")  sheetmodify cell(A4)  nolabel
	
	* Correction for avoidance in the first tax bracket + estimation of P99 when below the first bracket
		use "$resultsISF/StataFiles/ISFtab19842010cor.dta",clear
		append using "$resultsISF/StataFiles/ISFtab20122016cor.dta"
		sort year tranche
		keep year tranche b p thrisf nmen btranche cumulNisf
		rename thrisf thr
		replace thr =thr*1000
		replace p=p/100
		order year tranche thr p b
		* Add P99
			gen id=tranche+1
			expand 2 if tranche==1 & p>0.99
			sort year tranche
			replace tranche=99 if tranche==1 & tranche[_n+1]==1
			replace id=1 if tranche==99
			replace p=0.99 if tranche==99
			* treshold
				gen a =btranche/(btranche-1)
				replace thr = thr[_n+1]*(cumulNisf[_n+1]/nmen/1000/0.01)^(1/a) if tranche==99
		keep year tranche b p id thr

		* Add P0
			expand 2 if tranche==1
			replace tranche=0 if _n==_N | (tranche ==1 & tranche[_n+1]==1)
			replace thr=0 if tranche==0
			replace p=0 if tranche==0
			replace b=. if tranche==0
			replace id=0 if tranche==0
		* Exportation
			tempfile temp1
			save "`temp1'", replace
			
			keep if year <=1997
			reshape wide thr  p b,i(tranche id) j(year)
			sort id	
			drop tranche id
			export excel using "$resultsISF/RawResults_ApG.xlsx", sheet("TG5bis")  sheetmodify cell(A4)  nolabel
			
			use "`temp1'",clear
			keep if year >1997
			reshape wide thr  p b,i(tranche id) j(year)
			sort id	
			drop tranche id
			export excel using "$resultsISF/RawResults_ApG.xlsx", sheet("TG5bis")  sheetmodify cell(S4)  nolabel
