*******************************************************************************************************************
* Console for computing and exporting results on income and wealth distributions derived from the capitalization  *
*******************************************************************************************************************

set more off
clear

macro drop _all

* I) Determination of the different paths
*******************************************	
	
	* Project directory
		* PSE  
			*global projdir "U:/these/Projet wealth_income"	
		* My laptop 
			*global projdir "C:/Users/John/Desktop/these/Projet wealth_income"
		* Acces serveur PSE
			*global projdir "/home/j.goupille/U/these/Projet wealth_income"		
		* Acces CASD
			*global projdir "P:\W2IDF"
		* Dropbox
			global projdir "C:/Users/John/Dropbox/WIDFrance/Papers/GGP2016Wealth"
			global projdirDINA "C:/Users/John/Dropbox/WIDFrance/Papers/GGP2017DINA"

	* A) Capitalization method			
		global projdirCM "$projdir/GGP2016WealthAppendixB/DataFiles/Capitalization method"
		* Parameters
			global param "$projdirCM/Parameters"
		* DoFiles
			global doCM "$projdirCM/DoFiles"
		* Rawdata
			* Income Tax
				global datarev "$projdirCM/RawData/Income Tax"
			* Housing surveys
				global dataenl "$projdirCM/RawData/Housing surveys"
		* Working Files
			global wfenl "$projdirCM/WorkingFiles/Housing surveys"
			global wferfs "$projdirCM/WorkingFiles/ERFS"
			global wfrev "$projdirCM/WorkingFiles/revirpp"
			global wfrevtravcn "$projdirCM/WorkingFiles/revtravcn"
			global wfrevcapwealthcn "$projdirCM/WorkingFiles/revcapwealthcn"
			global wfrobust "$projdirCM/WorkingFiles/robustnesswealth"
			global wfpat "$projdir/GGP2016WealthAppendixF/DataFiles/WorkingFiles"

	* B) Exportation
		global projdirexp "$projdir/GGP2016WealthAppendixB/DataFiles/Exportation"
		* DoFiles
			global doexp "$projdirexp/DoFiles"
		* Results
			global resexp "$projdirexp/Results"
					

* II) Imputation of wealth and income consistent with National Accounts  
**************************************************************************

	* Choice of global to load
		* John PC : Faire tourner de 1970  1993 (global prog=court) ou de 1970  2006 (global prog=long)
			global casd=0
			global prog "court"
			*global prog "long"
			
			if "$prog"=="court" {
				global yearliste "1970 1975 1979 1984 1988 1990 1991 1992 1993"
				* Pour dodemo : donnes par sexe
					global yearliste2 "1970 1975 1979 1984 1988 1990 1991"
					global yearliste3="1992 1993"
			}		
			if "$prog"=="long" {
				global yearliste "1970 1975 1979 1984 1988"
				forval i=1990/2006 {
					global yearliste= "$yearliste" + " `i'"
				}
				* Pour dodemo : donnes par sexe
					global yearliste2 "1970 1975 1979 1984 1988 1990 1991 1997 1998"
					forval i=2000/2006 {
						global yearliste2= "$yearliste2" + " `i'"
					}
					global yearliste3="1999"
					forval i=1992/1996 {
						global yearliste3= "$yearliste3" + " `i'"
					}
			}



		/* CASD
			global casd=1
			global yearliste ""
			global yearliste2 ""
			forval i=1994/2012 {
				global yearliste= "$yearliste" + " `i'"
				global yearliste2= "$yearliste" 
			}
		*/				
	
* Part A: Data Harmonization and data for imputation
*****************************************************

		* 1) Creation of an homogeneous serie of taxable income at the individual level
			* At the household level
				foreach  pas of global yearliste {
					do "$doCM/Income Tax/rev`pas'.do"
				}
				* Note: variable sexe introuvable pour 1992-1996 1999 dans mes fichiers. Dans le CASD, sexe report toutes les annes 1994-2012.
				
			* At the individual level
				do "$doCM/Income Tax/doindivrev.do"
			
			* Data consistent with demographic parameters for under 25 years old
				do "$doCM/Income Tax/dodemo.do"
		
			* Aggregate stats on taxable income 
				do "$doCM/Income Tax/doagregatetaxinc.do"
		
		/* 2) Determination of parameters to impute assets without taxable income (life insurance, owner-occupied housing and savings accounts) based on wealth surveys and housing surveys(exported to Parameters/Imputation)
			* Owner-occupied housing
				* Using wealth surveys with detailed groups (age*financial income*labor income), 1992-2010
				do "$doCM/Imputation/imput_housing_EP.do"
				* Using wealth surveys with simpified groups (age*total income), 1992-2010
				do "$doCM/Imputation/imput_housing_EPrevtot.do"
				* Using housing surveys with simpified groups (age*total income), 1970-2010
				do "$doCM/Imputation/imput_housing_ENL.do"
			* Life insurance and savings accounts using wealth surveys with detailed groups (age*financial income*labor income), 1986-2010
				do "$doCM/Imputation/imput_life_EP.do"
				do "$doCM/Imputation/imput_liqu_EP.do"
		*/

* Part B: Income and wealth consistent with national accounts
**************************************************************
		
		* 1) Labor income, Capital income and wealth consistent with NA
			do "$doCM/dorevtravcn.do"
			* With imputation based on housing and wealth surveys
			do "$doCM/dorevcapwealthcn.do"
							
		* 2) Robustness checks on wealth imputation
			* A) Alternative imputation for owner-occupied housing
				* a) housing surveys, b) wealth surveys with same simplified imputation parameters as for housing surveys (base on age groups and total income)
				do "$doCM/Robustness/dorobust_hous.do"
			* B) Alternative imputation for life insurance, un vs plusieurs rdts fnanciers
				do "$doCM/Robustness/dorobustnesswealth.do"
			* C) Capitalize separately interest and dividends from 1988 to 2012
				do "$doCM/Robustness/dorevcapwealthcn_corTS.do"
			
		* 3) Results: Export of synthetic microfiles and raw tables
			* baseline scenario: Imputation life ins, liquidity and owner-occupied housing based on wealth surveys and housing surveys
				* synthetic microfiles of wealth inequality 
					do "$doexp/doexport_wealthcap.do"
				* Unique capitalization factor on financial income/ Alternative imputation methods for life insurance income/ Differentes clefs de repartition
					do "$doexp/doexport_wealthcaprobust"
				* synthetic microfiles of income inequality 
					do "$doexp/doexport_DINA.do"
					
			* Exportation of tables for exportresults_wealthcap and Appendix B
				do "$doexp/doexport_table.do"
				
	
		

