**************************************************************************************************************************************
* Dofiles used to create wealth distribution series (synthetic files) broken down by percentile, age, gender and asset categories    *
**************************************************************************************************************************************

set more off
clear 

********************************************************************************************************************	
* I) gperc: wealth distribution series by sex and gpercentile (with wealth share and wealth composition by decile) *
********************************************************************************************************************
* columns: year, gperc, sex, n, thr, ytop, b, y0 + wealth share (share_dperc) and wealth composition (by decile except in top deciles that is more detailed)
	*(gperc = 0, 1,2,99,99.1,,99,999 = 127 gperc)
	*(sex =0,1,2) (n = number of individuals in cell)
	* a) gpercentile by gender
		foreach pas of global yearliste {
			global year=`pas'
			
			use year idindiv pondn pat_cn  using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
				gen sex=0
			}
			if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
				merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
				rename sexe sex
				drop _merge idindiv
				append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keep(year pondn pat_cn)
				replace sex=0 if sex==.
			}
				* Definition of the percentile par importance de patrimoine
					sort year sex pat_cn
					gen pondvr=round(1000*pondn) 
					bys year sex : cumul pat_cn [w=pondvr], gen (p100)
					gen p10=p100*100
					* Par centile
						gen gperc   = int(p10) 
					* Au sein du dernier centile
						replace gperc=int(p10*10) if gperc==99 
					* Au sein du dernier millime
						replace gperc=int(p10*100) if gperc==999 
					* Au sein du dernier dix-millime
						replace gperc=int(p10*1000) if gperc==9999 
						replace gperc=gperc[_n-1] if p10==100
					drop p10 p100 pondvr	
				
				* gpercentile
					gen pat2=pondn*pat_cn
					bys year sex : egen y0=sum(pondn*(pat_cn==0))					
					collapse (min) y0 thr=pat_cn (sum)pat2 n=pondn,by(year sex gperc)
					gsort + year sex - gperc
					bys year sex : gen cumulpat=sum(pat2)
					bys year sex : gen cumulpond=sum(n)
					gen ytop=cumulpat/cumulpond
					gen b=ytop/thr
					replace b =. if b<0
					bys year sex : egen tot=sum(n)
					replace y0=y0/tot
					drop tot
					keep year gperc sex  n thr  ytop b y0
					order year gperc sex  n thr  ytop b y0
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex gperc
					gen dperc=int(gperc/10)*10
					replace dperc=95 if gperc>=95
					replace dperc=99 if gperc>=990
					replace dperc=995 if gperc>=995
					replace dperc=999 if gperc>=999
					save  "$resexp/wealth/gperc/gperctemp1.dta",replace
				
	* b) Add wealth share and wealth composition by decile to gperc
		
		foreach pas of global yearliste {
			global year=`pas'

			use "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
				gen sex=0
			}
			if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
				merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
				rename sexe sex
				drop _merge idindiv
				append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta"
				replace sex=0 if sex==.
			}
			gen patnonfi_cn=patfon_brut_cn+patpro_cn
			gen patfin_liquint_cn=patfin_int_cn+ patfin_liqu_cn
			#delimit;
			order year pondn sex pat_cn patnonfi_cn patfon_brut_cn patfon_owner_brut_cn patfon_rent_brut_cn patpro_cn 
				patfin_cn patfin_liquint_cn patfin_liqu_cn patfin_int_cn patfin_div_cn	 patfin_av_cn passif_cn;
			#delimit cr
			keep year-passif_cn
			
			* Definition of the percentile par importance de patrimoine
				* Wealth groups
					sort year sex pat_cn
					gen pondvr=round(100*pondn) 
					bys year sex : cumul pat_cn [w=pondvr], gen (p100)
					gen p10=p100*100
					gen dperc   = int(p10/10)*10
					replace dperc=95 if p10>=95
					replace dperc=99 if p10>=99
					replace dperc=995 if p10>=99.5
					replace dperc=999 if p10>=99.9
					drop p10 p100 pondvr
					
					rename pat_cn pat
					foreach var of newlist 	patnonfi patfon_brut patfon_owner_brut patfon_rent_brut	patpro patfin patfin_liquint patfin_liqu patfin_int patfin_div	patfin_av passif {
						rename `var'_cn sh_`var'
					}
					gen pat2=pat
					foreach var of varlist pat-sh_passif  {
						replace `var'=`var'*pondn
					}
					bys year sex : egen pop=sum(pondn)
					bys year sex: egen patot=sum(pondn*pat2)
					gen patmean=patot/pop
					collapse (sum) pat-sh_passif (mean) patmean pop,by(year sex dperc)
					bys year sex : egen tot=sum(pat)
					foreach var of varlist sh_patnonfi-sh_passif  {
						replace `var' =`var'/pat
					}
					gen share_dperc=pat/tot
					drop tot pat
					sort year sex dperc
					order year sex patmean pop dperc share_dperc
					dis $year
					if (${casd}==0 & $year>1970)  {
						append  using "`temp'"
						erase "`temp'"
					}
					
					if (${casd}==1 & $year>1994) {
						append using "`temp'"
						erase "`temp'"
					}
					tempfile temp
					save "`temp'",replace
				}	
					erase "`temp'"
					sort year sex dperc
	save  "$resexp/wealth/gperc/gperctemp2.dta",replace
	merge 1:m year sex dperc using "$resexp/wealth/gperc/gperctemp1.dta" 
	sort year sex gperc
	drop _merge
	order dperc- sh_passif,last
	save "$resexp/wealth/gperc/gperc.dta",replace 
	erase "$resexp/wealth/gperc/gperctemp1.dta"
	erase "$resexp/wealth/gperc/gperctemp2.dta"
	import excel using "$resexp/wealth/CASD/gperc.xlsx", first clear sheet("Feuil1")  cellrange(A2:X7241)
	append using "$resexp/wealth/gperc/gperc.dta"
	sort year sex gperc
	save "$resexp/wealth/gperc/gperc.dta",replace 
	

***********************************************************************************
* II) bperc_aged: wealth distribution series by broad percentile and decenial age *
***********************************************************************************
* columns: year, bperc, aged, thr, ytop, b
	* (bperc = P0, P10, P50, P90, P99, P99.5, P99.9)
	* (aged = 20, 30, 40, 50, etc., 80+)

foreach pas of global yearliste {
			global year=`pas'

		use year idindiv pondn pat_cn age using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
		gen aged=int(age/10)
		drop if aged==.
		replace aged=8 if aged>8
			
			* Definition of the percentile par importance de patrimoine
					sort year aged pat_cn
					gen pondvr=round(100*pondn) 
					bys year aged : cumul pat_cn [w=pondvr], gen (p100)
					gen p10=p100*100
					gen bperc   = 0
					replace bperc=10  if p10 >=10 & p10 <50 & bperc==0
					replace bperc=50  if p10 >=50 & p10 <90 & bperc==0
					replace bperc= 90   if p10 >=90 & p10 <99 & bperc==0
					replace bperc= 99   if p10 >=99 & p10 <99.5 & bperc==0
					replace bperc= 995   if p10 >=99.5 & p10 <99.9 & bperc==0
					replace bperc= 999   if p10 >=99.9  & bperc==0
					drop p10 p100 pondvr

			* Summary statistics  
				keep bperc year aged pat_cn pondn
				rename pat_cn pat
				sort year aged bperc
				bys year aged: egen pop_aged=sum(pondn)
				bys year aged: egen patot_aged=sum(pondn*pat)
				gen patmean_aged=patot/pop_aged
				gen pat2=pat
				foreach var of varlist pat  {
					replace `var'=`var'*pondn
				}
			collapse (min) thr=pat2 (sum) share_bperc_aged=pat n=pondn (mean) patmean_aged pop_aged patot_aged  ,by(year aged bperc)
			* Cumulative au-del du seuil et coef de Pareto
				gsort year aged  - bperc
				bys year aged:gen pattemp=sum(share_bperc)
				bys year aged:gen poptemp=sum(n)
				gen ytop=pattemp/poptemp
				gen b=ytop/thr
			* Share	
				replace share_bperc=share_bperc_aged/patot_aged
				drop  patot_aged pattemp poptemp
				sort year aged bperc
				order year aged patmean_aged pop_aged bperc
			dis $year
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
			
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
			tempfile temp
			save "`temp'",replace
		}	
			erase "`temp'"
			sort year aged bperc
save "$resexp/wealth/other/bperc_aged.dta",replace 
import excel using "$resexp/wealth/CASD/bperc_aged.xlsx", first clear sheet("Feuil1")  cellrange(A2:J933)
append using "$resexp/wealth/other/bperc_aged.dta"
sort year aged bperc
save "$resexp/wealth/other/bperc_aged.dta",replace 


******************************************************
* III) wealth_age_sex: Average wealth by age and sex *
******************************************************	
* columns: year, sex, age, n, yav			


foreach pas of global yearliste {
			global year=`pas'

		use year idindiv pondn pat_cn age using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
		if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
			gen sex=0
		}
		if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
			merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
			rename sexe sex
			drop _merge idindiv
			append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keep(year pondn pat_cn age)
			replace sex=0 if sex==.
		}
		replace age=81 if age>80
		
		* Summary statistics  
			keep year age sex pat_cn pondn
			rename pat_cn pat
			sort year age
			foreach var of varlist pat  {
				replace `var'=`var'*pondn
			}
			collapse (sum) yav=pat n=pondn  ,by(year sex age)
			replace yav=yav/n
			
			dis $year
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
			
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
			tempfile temp
			save "`temp'",replace
		}	
			erase "`temp'"
			sort year sex age
	save "$resexp/wealth/other/wealth_age_sex.dta",replace 
	import excel using "$resexp/wealth/CASD/wealth_age_sex.xlsx", first clear sheet("Feuil1")  cellrange(A2:E3536)
	append using "$resexp/wealth/other/wealth_age_sex.dta"
	sort year sex age
	save "$resexp/wealth/other/wealth_age_sex.dta",replace 

	
****************************************************************************************************
* IV) wealth_aged_sex: Average wealth, wealth share and wealth composition by decenial age and sex *
****************************************************************************************************	
*columns: year, sex, aged, n, yav + wealth share and wealth composition 


foreach pas of global yearliste {
			global year=`pas'

		use  "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
		if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
			gen sex=0
		}
		if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
			merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
			rename sexe sex
			drop _merge idindiv
			append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta"
			replace sex=0 if sex==.
		}
		
		gen aged=int(age/10)
		replace aged=8 if aged>8
		gen patnonfi_cn=patfon_brut_cn+patpro_cn
		gen patfin_liquint_cn=patfin_int_cn+ patfin_liqu_cn
		#delimit;
		order year pondn sex aged pat_cn patnonfi_cn patfon_brut_cn patfon_owner_brut_cn patfon_rent_brut_cn patpro_cn 
			patfin_cn patfin_liquint_cn patfin_liqu_cn patfin_int_cn patfin_div_cn	 patfin_av_cn passif_cn;
		#delimit cr
		keep year-passif_cn
			
		rename pat_cn pat
		foreach var of newlist 	patnonfi patfon_brut patfon_owner_brut patfon_rent_brut	patpro patfin patfin_liquint patfin_liqu patfin_int patfin_div	patfin_av passif {
			rename `var'_cn sh_`var'
		}
		foreach var of varlist pat-sh_passif  {
			replace `var'=`var'*pondn
		}
		bys year sex: egen patot=sum(pat)
		collapse (sum) pat-sh_passif n=pondn (mean) patot,by(year sex aged)
		foreach var of varlist sh_patnonfi-sh_passif  {
			replace `var' =`var'/pat
		}
		gen yav=pat/n
		gen sh_aged_sex = pat/patot
		drop patot pat	
		dis $year
		if (${casd}==0 & $year>1970)  {
			append  using "`temp'"
			erase "`temp'"
		}
		
		if (${casd}==1 & $year>1994) {
			append using "`temp'"
			erase "`temp'"
		}
		tempfile temp
		save "`temp'",replace
	}	
		erase "`temp'"
		sort year sex aged
		order year sex aged n yav sh_aged_sex
	save "$resexp/wealth/other/wealth_aged_sex.dta",replace 
	import excel using "$resexp/wealth/CASD/wealth_aged_sex.xlsx", first clear sheet("Feuil1")  cellrange(A2:R401)
	append using "$resexp/wealth/other/wealth_aged_sex.dta"
	sort year sex aged
	save "$resexp/wealth/other/wealth_aged_sex.dta",replace 

	
********************************************************************************************************************************************
* V) bperc_bage: wealth distribution series by broad age (bage) and broad wealth groups (bperc) (with wealth share and wealth composition) *
********************************************************************************************************************************************
* columns: year, bperc, baged, thr, ytop, b + wealth shares and wealth composition
	* (bperc = 0, 10, 50, 90, 99, 99.5, 99.9)
	* (bage = 20-39, 40-59, 60+)

foreach pas of global yearliste {
			global year=`pas'

		use year idindiv pondn pat* passif_cn age using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
		gen bage=int(age/10)*10
		replace bage=20 if bage==30
		replace bage=40 if bage==50
		replace bage=60 if bage>60
		drop if age==.
			
			* Definition of the percentile par importance de patrimoine
					sort year bage pat_cn
					gen pondvr=round(100*pondn) 
					bys year bage : cumul pat_cn [w=pondvr], gen (p100)
					gen p10=p100*100
					gen bperc   = 0
					replace bperc=10  if p10 >=10 & p10 <50 & bperc==0
					replace bperc=50  if p10 >=50 & p10 <90 & bperc==0
					replace bperc= 90   if p10 >=90 & p10 <99 & bperc==0
					replace bperc= 99   if p10 >=99 & p10 <99.5 & bperc==0
					replace bperc= 995   if p10 >=99.5 & p10 <99.9 & bperc==0
					replace bperc= 999   if p10 >=99.9  & bperc==0
					drop p10 p100 pondvr

			* Summary statistics and wealth composition
				keep bperc year bage *_cn pondn
				gen patnonfi_cn=patfon_brut_cn+patpro_cn
				gen patfin_liquint_cn=patfin_int_cn+ patfin_liqu_cn
				foreach var of newlist pat	patnonfi patfon_brut patfon_owner_brut patfon_rent_brut	patpro patfin patfin_liquint patfin_liqu patfin_int patfin_div	patfin_av passif patfon_net patfon_owner_net patfon_rent_net {
					rename `var'_cn `var'
				}
				#delimit;
				order year pondn bperc bage pat patnonfi patfon_brut patfon_owner_brut patfon_rent_brut patpro
				patfin patfin_liquint patfin_liqu patfin_int patfin_div	patfin_av passif patfon_net patfon_owner_net patfon_rent_net ;
				#delimit cr
				sort year bage bperc
				bys year bage: egen pop_bage=sum(pondn)
				bys year bage: egen patot_bage=sum(pondn*pat)
				gen patmean_bage=patot/pop_bage
				gen pat2=pat
				foreach var of varlist pat-patfon_rent_net  {
					replace `var'=`var'*pondn
				}
			collapse (min) thr=pat2 (sum) share_bperc_bage=pat n=pondn patnonfi-patfon_rent_net (mean) patmean_bage pop_bage patot_bage  ,by(year bage bperc)
			* Cumulative au-del du seuil et coef de Pareto
				gsort year bage  - bperc
				bys year bage:gen pattemp=sum(share_bperc)
				bys year bage:gen poptemp=sum(n)
				gen ytop=pattemp/poptemp
				gen b=ytop/thr
			* Wealth composition
				foreach var of varlist patnonfi-patfon_rent_net {
					replace `var'=`var'/share_bperc_bage
				}
			* Share	
				replace share_bperc_bage=share_bperc_bage/patot_bage
				drop  patot_bage pattemp poptemp
				sort year bage bperc
				order year bage patmean_bage pop_bage bperc n  share_bperc_bage thr ytop b
			dis $year
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
			
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
			tempfile temp
			save "`temp'",replace
		}	
			erase "`temp'"
			sort year bage bperc
	save "$resexp/wealth/other/bperc_bage.dta",replace 
	import excel using "$resexp/wealth/CASD/bperc_bage.xlsx", first clear sheet("Feuil1")  cellrange(A2:Y401)
	append using "$resexp/wealth/other/bperc_bage.dta"
	sort year bage bperc
	save "$resexp/wealth/other/bperc_bage.dta",replace 


************************************************************************************************************************
* VI) gperc_w_r_pretaxCN: Distribution of pretax income and its decomposition by gender and level of wealth (decile)   *
************************************************************************************************************************
		
		clear
		foreach pas of global yearliste {
			global year=`pas'
			local loop="r_pretaxCN"
			dis `pas'
			dis "`loop'"
			use year idindiv pondn rcap_cn- rfin_av_cn pat_cn using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			if ${casd}==0 & (${year}==1999 | (${year}>=1992 & ${year}<=1996)) {
				gen sex=0
				merge 1:1 year idindiv using "$wfrevtravcn/revtravcn${year}.dta"
			}
			if $casd==1 | ( ${casd}==0 & (${year}<=1991 | ${year}>=2000 | ${year}==1997 | ${year}==1998))  {
				merge 1:1 idindiv using "$wfrev/rev${year}.dta",keepusing(sexe)
				rename sexe sex
				drop _merge 
				append using "$wfrevcapwealthcn/revcapwealthcn${year}.dta"
				order pat_cn,last
				drop idfoy- passif_rent_cn
				merge m:1 year idindiv using "$wfrevtravcn/revtravcn${year}.dta"
				replace sex=0 if sex==.
			}
			keep year sex pondn  *_cn pat_cn *_pretaxCN
			sort year sex 
			gen r_pretaxCN=rcap_cn+rtrav_pretaxCN
			gen rfin_cn=rfin_div_cn+ rfin_int_cn+ rfin_liqu_cn+ rfin_av_cn
			replace sal_pretaxCN = sal_pretaxCN +chom_pretaxCN
			drop chom_pretaxCN
			rename rcap_cn rcap
			rename pat_cn pat

			#delimit;
			order year sex pondn pat
			r_pretaxCN rtrav_pretaxCN rcap   sal_pretaxCN pension_pretaxCN nonsal_labor_pretaxCN
			 rfon_cn rfon_owner_cn rfon_rent_cn nonsal_capital_cn 
			rfin_cn rfin_div_cn rfin_int_cn rfin_liqu_cn rfin_av_cn  ;
			#delimit cr
			
			* Definition of the percentile par importance de revenu
				sort year sex pat
				gen pondvr=round(1000*pondn) 
				bys year sex : cumul pat [w=pondvr], gen (p100)
				gen p10=p100*100
				gen dperc   = int(p10/10)*10
				replace dperc=95 if p10>=95
				replace dperc=99 if p10>=99
				replace dperc=995 if p10>=99.5
				replace dperc=999 if p10>=99.9
				drop p10 p100 pondvr
				drop pat
			
			foreach var of newlist rfon  rfon_owner rfon_rent nonsal_capital rfin rfin_div rfin_int rfin_liqu rfin_av	{
				rename `var'_cn sh_`var'
			}
			rename rcap sh_rcap
			foreach var of varlist *_pretaxCN	{
				rename `var' sh_`var'
			}
			gen `loop'2=sh_`loop'
			foreach var of varlist sh_r_pretaxCN- sh_nonsal_pretaxCN {
				replace `var'=`var'*pondn
			}
			bys year sex : egen pop=sum(pondn)
			bys year sex: egen `loop'tot=sum(pondn*`loop'2)
			gen ymean=`loop'tot/pop
			collapse (sum) sh_r_pretaxCN- sh_nonsal_pretaxCN  (mean) ymean pop,by(year sex dperc)
			
			bys year sex : egen tot=sum(sh_r_pretaxCN)
			
			foreach var of varlist sh* {
					replace `var'=`var'/tot
			}
			drop tot 
			sort year sex dperc
			order year sex ymean pop dperc 
			dis $year
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
			
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
			tempfile temp
			save "`temp'",replace
		}	
		erase "`temp'"
		sort year sex dperc
		save  "$resexp/wealth/gperc/gperc_w_`loop'.dta",replace
		import excel using "$resexp/wealth/CASD/gperc_w_`loop'.xlsx", first clear sheet("Feuil1")  cellrange(A2:U800)
		append using "$resexp/wealth/gperc/gperc_w_`loop'.dta"
		sort year sex dperc
		save  "$resexp/wealth/gperc/gperc_w_`loop'.dta",replace


********************************************************************************
* VII) Asset specific distributions by broad asset specific groups or by gperc *
********************************************************************************

	* Broad groups
	
	foreach pas of global yearliste {
		global year=`pas'
		clear
		foreach var of newlist patfon_brut patfon_owner_brut patfon_rent_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av    {
			use "$wfrevcapwealthcn/revcapwealthcn${year}.dta",clear
			rename `var'_cn `var'

			* Definition of the percentile 
			sort year `var'
			gen pondvr=round(100*pondn) 
			bys year : cumul `var' [w=pondvr], gen (p100)
			gen p10=p100*100
			gen py   = 0
			replace py=50  if p10 >=50 & p10 <90 & py==0
			replace py= 90   if p10 >=90 & p10 <95 & py==0
			replace py= 95   if p10 >=95 & p10 <99 & py==0
			replace py= 99   if p10 >=99 & p10 <99.5 & py==0
			replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
			replace py= 999   if p10 >=99.9 & py==0
			
			* Distribution by assets
				replace `var'=`var'*pondn
				collapse (sum) `var' ,by(year py)
				bys year : egen `var'_tot=sum(`var')
				replace `var'=`var'/`var'_tot
				drop `var'_tot
				sort year py
				if "`var'"~="patfon_brut" {
					merge 1:1 year py using "`tempA'"
					drop _merge
					erase "`tempA'"
				}
				tempfile tempA
				save "`tempA'",replace
				
		}
		erase "`tempA'"
		order year py patfon_brut patfon_owner_brut patfon_rent_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av
		* Append the different years
		dis $year
		if (${casd}==0 & $year>1970) {
			append  using "`temp'"
			erase "`temp'"
		}
					
		if (${casd}==1 & $year>1994) {
			append using "`temp'"
			erase "`temp'"
		}
		tempfile temp
		save "`temp'",replace
	}
				
	erase "`temp'"
	sort year  py
	save  "$resexp/wealth/other/assetdistri.dta",replace
	import excel using "$resexp/wealth/CASD/assetdistri.xlsx", first clear sheet("Feuil1")  cellrange(A2:L135)
	append using "$resexp/wealth/other/assetdistri.dta"
	sort year py
	save  "$resexp/wealth/other/assetdistri.dta",replace
	
	
			

