********************************************************************************************************************************************
* do-file used to estimate the distribution of wealth between 1984 and 2010 from the MTG files by using the estate multiplier approach     *
********************************************************************************************************************************************

set more off
clear

* A) Importation of the mortality parameters
*************************************************
		
		* Mortality rate from DemoData (ratio nber of decedents/ nber of living by year, sex and decenial age)
			* Male
				import excel using "$resultsDMTG/RawResults_ApD.xlsx", first clear sheet("TableD4(m)")  cellrange(A7:L36)
				drop if _n==1 | _n==2
				keep year mortrate*
				destring _all,replace
				foreach var of varlist mortrate* {
					replace `var'=`var'/100000
					foreach year of numlist 1984 1987 1994 2000 2006 2010 {
						quiet sum `var' if year==`year'
						global `var'`year'=r(mean)
					}
				}
			* Female				
				import excel using "$resultsDMTG/RawResults_ApD.xlsx", first clear sheet("TableD4(f)")  cellrange(A7:L36)
				drop if _n==1 | _n==2
				keep year mortrate*
				destring _all,replace
				foreach var of varlist mortrate* {
					replace `var'=`var'/100000
					foreach year of numlist 1984 1987 1994 2000 2006 2010 {
						quiet sum `var' if year==`year'
						global `var'`year'=r(mean)
					}
				}
				
		* Number of living per year
			import excel using "$resultsDMTG/RawResults_ApD.xlsx", first clear sheet("stataDMTG")  cellrange(A4:C31)
			keep year na2
			rename na2 na
			foreach year of numlist 1984 1987 1994 2000 2006 2010 {
				quiet sum na if year==`year'
				global na`year'=r(mean)
			}

				
		* Differential Mortality parameters by age
			import excel using "$resultsDMTG/RawResults_ApD.xlsx", first clear sheet("statadiffmort")  cellrange(A4:L39)
			drop mort_rate*
			drop if year ==1975
			expand 2 if aged==3
			sort aged year
			replace aged=2 if aged==3 & aged[_n+1]==aged[_n] & year[_n+1]==year[_n]
			
			replace year=1984 if year==1982
			replace year=1994 if year==1990
			replace year=2000 if year==1999
			replace year=2010 if year==2008

			expand 2 if year==1984
			expand 2 if  year==2000
			
			sort year aged
			replace year=1987 if year==1984 & aged[_n-1]==age[_n]
			replace year=2006 if year==2000 & aged[_n-1]==age[_n]
			sort year aged
			
			tempfile diffmort
			save "`diffmort'",replace
					
foreach year of global yearlistdmtg {
global year=`year'
* B) Simulation of the wealth distribution of the living from the MTG files using th estate multiplier approach
******************************************************************************************************************
	
	* Load the data
	*****************
		use "$wfDMTG/demodec/wf${year}demodec.dta",clear
		keep year sexe age pondn pat idsucc
		gen aged=int(age/10)
		replace aged=9 if aged>9
		replace aged=2 if aged<2
					
		merge m:1 year aged using "`diffmort'"
		keep if year==$year
		drop _merge
		expand 10 
		replace pondn=pondn/10
			
	* Estate mulitplier approach
	******************************
		
		* death probability attibution by sexe, year and decenial age
			gen mortality_rate=0
			foreach num of numlist 2/9 {
				replace mortality_rate=${mortratem`num'${year}} if sexe==0 & aged==`num' & year==${year}
				replace mortality_rate=${mortratef`num'${year}} if sexe==1 & aged==`num' & year==${year}
			}	
		* Differential mortality rate: See GGP2016WealthAppendix for more details
			* a) 2 groups: Bottom 50% and top 50% by decenial age
				* Attention differential mortality par bot 50 et top 50 des vivants
				* => Top 1/(1+delta) et bottom delta/(1+delta) des dfunts avec delta= taux mortalit des pauvres/tx mortalit des riches
				gen temptop=1/(1+diff_mortoldbot50/ diff_mortoldtop50)
				gen pyold="" 
				bys year aged sexe : egen tot=sum(pondn)
				gsort year aged sexe  - pat
				bys year aged sex : gen cumul=sum(pondn)/tot 
				replace pyold="top50" if cumul<=temptop &  pyold==""
				replace pyold="bot50" if  pyold==""
				drop cumul tot temptop
			
			* b) 3 groups: Bottom 50%, middle 40% and top 50% by decenial age
				* Attention differential mortality par bot 50, mid 40 et top 50 des vivants
				* => Top 1/(1+4 mM/mR + 5 mP/mR) ; 	Middle (4 mM/mR) /(1+4 mM/mR + 5 mP/mR) et bot (5 mP/mR) / (1+4 mM/mR + 5 mP/mR) des dfunts 
					gen temptop=1/(1+4*diff_mortmidh /diff_morttoph+ 5*diff_mortboth /diff_morttoph) if sexe==0
					replace temptop=1/(1+4*diff_mortmidf /diff_morttopf+ 5*diff_mortbotf /diff_morttopf) if sexe==1

					gen tempmid=(4*diff_mortmidh /diff_morttoph)/(1+4*diff_mortmidh /diff_morttoph+ 5*diff_mortboth /diff_morttoph) if sexe==0
					replace tempmid= (4*diff_mortmidf /diff_morttopf)/(1+4*diff_mortmidf /diff_morttopf+ 5*diff_mortbotf /diff_morttopf) if sexe==1	
					/* Verif
						gen tempbot=(5*diff_mortboth /diff_morttoph)/(1+4*diff_mortmidh /diff_morttoph+ 5*diff_mortboth /diff_morttoph) if sexe==0
						replace tempbot= (5*diff_mortbotf /diff_morttopf)/(1+4*diff_mortmidf /diff_morttopf+ 5*diff_mortbotf /diff_morttopf) if sexe==1
						gen verif=tempmid+tempbot+temptop
						sum verif,d
						drop verif tempbot
					*/
					gen py="" 
					bys year aged sexe : egen tot=sum(pondn)
					gsort year aged sexe - pat
					bys year aged sexe : gen cumul=sum(pondn)/tot 
					replace py="top" if cumul<=temptop &  py==""
					replace py="mid" if cumul<=( temptop+tempmid) &  py==""
					replace py="bot" if  py==""
					drop cumul tot tempmid temptop
				
			* Differential mortality rate
				gen diff_mortrate=0
					foreach var of newlist bot mid top {
						replace diff_mortrate=diff_mort`var'h if sexe==0 & py=="`var'"
						replace diff_mortrate=diff_mort`var'f if sexe==1 & py=="`var'"
						drop diff_mort`var'h diff_mort`var'f
					}
					
				gen diff_mortrateold=0
				replace diff_mortrateold =diff_mortoldbot50 if pyold=="bot50"
				replace diff_mortrateold =diff_mortoldtop50 if pyold=="top50"
				drop diff_mortoldbot50 diff_mortoldtop50
				
					
							
		* Apply the estate multiplier approach
			* sansdiff: No differential mortality by level of wealth
			* olddiff: Differntial mortality among two wealth groups (top50 vs bot50)
			* diff: Differential mortality among three wealth groups (top10 vs mid40 vs bot50)
			rename pondn pondndec
			gen pondnsansdiff=pondndec/mortality_rate
			gen pondnolddiff=pondndec/(mortality_rate*diff_mortrateold)
			gen pondndiff=pondndec/(mortality_rate*diff_mortrate)
		
		* Adjustment for entire French pop instead of only France Metropolitaine
			foreach var of newlist sansdiff olddiff diff {
				sum pondn`var'
				replace pondn`var'=pondn`var'*${na${year}}*1000/r(sum)
			}
			drop py* mort* diff_mort*  

	* Add wealth variables
	***************************
		merge m:1 year idsucc using "$wfDMTG/demodec/wf${year}demodec.dta"
		foreach var of varlist patfon_brut patpro patfin_div patfin_int patfin_liqu patfin_av {
			replace `var'=`var'+`var'_exo
			drop `var'_exo
		}
		gen patfon_net=max(patfon_brut-passif,0)
		gen patfin=patfin_div +patfin_int+ patfin_liqu+ patfin_av
		keep year idsucc sexe age aged pondndec pondnsansdiff pondnolddiff pondndiff pat patfon_net patfon_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av
		#delimit;
		order year idsucc sexe age aged pondndec pondnsansdiff pondnolddiff pondndiff
		pat patfon_net patfon_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av;
		#delimit cr
		
		save "$wfDMTG/wealth/wfwealth${year}.dta",replace
		

}
erase "`diffmort'"
macro drop mort* na* ndeca*

/* Verif : Comparison of the simulated and observed population
	* ok
	import excel using "$resultsDMTG/RawResults_ApD.xlsx", first clear sheet("stataDMTG")  cellrange(A4:C31)
	keep year na2 ndeca
	rename na2 na
	tempfile temp
	save "`temp'",replace
	
	use "$wfDMTG/wealth/wfwealth1984.dta"
	foreach year of global yearlistdmtg {
		append using "$wfDMTG/wealth/wfwealth`year'.dta"
	}
	collapse (sum) pondnsansdiff pondnolddiff pondndiff pondndec,by(year)
	merge 1:1 year using "`temp'"
	keep if _merge==3
	erase "`temp'"
			
	foreach var of newlist sansdiff olddiff diff {
		bys year  : egen tot`var'=sum(pondn`var'/na/1000)
	}
		bys year  : egen totdec=sum(pondndec/ndeca/1000)
	twoway (connected totsansdiff year, sort)  (connected totolddiff year, sort) (connected totdiff year, sort) (connected totdec year, sort)
	
*/

	