**************************************************************************************
* Console to compute and export wealth distribution using estate multiplier approach *
**************************************************************************************

set more off
clear

macro drop _all

* I) Determination of the different paths
*******************************************
	
	* Project directory
		* PSE  
			*global projdir "U:/these/Projet wealth_income"	
		* My laptop 
			global projdirDMTG "C:/Users/John/Desktop/these/Projet wealth_income/GGP2016WealthAppendixD/DataFiles"	
			global projdirrev "C:/Users/John/Desktop/these/Projet wealth_income/GGP2016WealthAppendixB/DataFiles/Capitalization method/WorkingFiles/revcapwealthcn"
		* Acces CASD
			*global projdir "P:/W2IDF/GGP2016WealthAppendixD/DataFiles"
			*global projdirrev "P:/W2IDF/GGP2016WealthAppendixD/DataFiles/Capitalization method/WorkingFiles/revcapwealthcn""	
		
		* Parameters
			global param "$projdirDMTG/Parameters"
		* DoFiles
			global doDMTG "$projdirDMTG/DoFiles"
		* Rawdata
			global dataDMTG "$projdirDMTG/RawData"
		* Working Files
			global wfDMTG "$projdirDMTG/WorkingFiles"
			global wfpat "C:/Users/John/Desktop/these/Projet wealth_income/GGP2016WealthAppendixF/DataFiles/WorkingFiles"

		* Results
			global resultsDMTG "$projdirDMTG/Results"
			
	* Choice of global to load
		* on my computer
			global casd=0
			global yearlistdmtg "1984 1987 1994 2000"
		* on CASD
			*global casd=1
			*global yearlistdmtg "2006 2010"
			
	
* II) Estate multiplier approach and exportation
*************************************************
	
	* 1) Distribution of wealth at death (1984-2010)
		* a) Creation of an homogeneous serie of estate at death between 1984-2010 from the MTG file succession
			do "$doDMTG/DMTG/dodmtg.do"
		*b) Add non-tax filers with 0 wealth => fully representative sample of the demographic structure of the French decedents 
			do "$doDMTG/DMTG/dodmtgdemo.do"
	
	*2)  Distribution of wealth using the the estate multiplier approach (1984-2010)
		* Compute Differential mortality parameters
			do "$doDMTG/domortdiff.do"		
		* Varying differential mortality factor
			do "$doDMTG/dowealthdemo.do"
		* Add wealth for non-tax filers
			do "$doDMTG/doimputnontaxfiler.do"
		* Add life insurance and bottom 50% wealth
			do "$doDMTG/doimputavie.do"
		* Add life insurance and bottom 50% wealth + consistent with National Accounts
			do "$doDMTG/dowealthcn.do"
	* 4) Exportation des rsultats
		do "$doDMTG/doexportshare.do"
		
		
	
