***********************************************************************
* Do file used to adjust wealth consistently to National Accounts	*
***********************************************************************


foreach year of  global yearlistdmtg {
	global year=`year'
		
* I) Importation of parameters 
********************************		
	
	* Wealth and its components from National Accounts 
		import excel using "$resultsDMTG/RawResults_ApD.xlsx",first clear sheet("stataDMTG") cellrange(A4:N31) 
		drop na2 ndeca
		gen patfon_netNA=patfon_owner_netNA +patfon_rent_netNA
		drop  patfon_owner* patfon_rent* 
		* Transform all parameters into global 
			foreach var of varlist _all {
				quiet sum `var' if year==${year}
				global `var'=r(mean)
			}
* II) Wealth consistent with NA Wealth 
***************************************

foreach onglet of newlist diff olddiff sansdiff {
	global onglet="`onglet'"
	use "$wfDMTG/wealthwithavie/wfwealth${year}avie${onglet}.dta",clear
	
	* Dummy for Bottom 50 
		* Bottom 50% Wealth already consistent with NA
		*py${onglet}
		
	
	* Adjustment of top 50
		foreach var of varlist patfon_net patpro patfin_div patfin_int patfin_liqu patfin_av {
			egen `var'bot50=sum(`var'*pondn${onglet}*(py_${onglet}==50))
			egen `var'top50=sum(`var'*pondn${onglet}*(py_${onglet}==0))
			replace `var'=`var'*(${`var'NA}*1000000000-`var'bot50)/`var'top50 if py_${onglet}==0
			drop `var'bot50 `var'top50
		}
		replace patfin=patfin_div+ patfin_int+  patfin_av + patfin_liqu
		replace pat=patfin+patpro+patfon_net
		drop patfon_brut passif py
		save "$wfDMTG/wealthcn/wfwealthcn${year}${onglet}.dta",replace
	
	macro drop onglet
			

}
	macro drop year patfin* pat patfon* patpro*

}			
		
