*******************************************
*Imputation of wealth for non-tax filers	*
*******************************************

* Bottom 50% share comes from capitalization method
* Imputation using a uniform law for the bottom 50% nontax-filers


foreach year of global yearlistdmtg {
global year=`year'

	foreach onglet of newlist diff olddiff sansdiff {
		global onglet="`onglet'"
		
		use "$wfDMTG/wealth/wfwealth${year}.dta",clear
		set seed 65946665
		
		* Bottom 50 in DMTG living
			sort year pat
			gen pondvr=round(10000*pondn${onglet}) 
			bys year : cumul pat [w=pondvr], gen (p100)
			replace p100=p100*100
			gen py_${onglet}   = 0
			replace py_${onglet}=50  if p100 <50 
			drop p100 pondvr	
			tempfile temp
			save "`temp'",replace
		
		* Bottom 50% wealth in capitalization method from revcap file
			if $year==1987 { 
				use  "$projdirrev/revcapwealthcn1988.dta",clear
				replace year=1987
			}
			if $year~=1987 { 
				use  "$projdirrev/revcapwealthcn${year}.dta",clear
			}
			
			sort year pat_cn
			gen pondvr=round(100*pondn) 
			bys year : cumul pat_cn [w=pondvr], gen (p100)
			replace p100=p100*100
			gen py   = 0
			replace py=50  if p100 <50
			keep if py==50
			egen tot=sum(pondn)
			foreach var of newlist pat patfon_net patfon_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av {
				replace `var'_cn=`var'_cn*pondn/tot
			}
			collapse (sum) pat_cn patfon_net_cn patfon_brut_cn passif_cn patpro_cn patfin_cn patfin_div_cn patfin_int_cn patfin_liqu_cn patfin_av_cn  ,by(year)
			foreach var of newlist patfon_net patfon_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av {
				replace `var'_cn=`var'_cn/pat_cn
			}
			
		* Imputation of bottom 50% in DMTG files
			merge 1:m year using "`temp'"
			drop _merge
			gen uni=uniform() if py==50
			replace pat=uni*pat_cn*2 if py==50
			foreach var of varlist patfon_net patfon_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av {
				replace `var'=`var'_cn*pat if py_${onglet}==50
				drop `var'_cn
			}
			drop uni  pat_cn
			if "${onglet}"=="diff" {
				drop pondndec pondnsansdiff pondnolddiff 
			}
			if "${onglet}"=="sansdiff" {
				drop pondndec  pondnolddiff pondndiff
			}
			if "${onglet}"=="olddiff" {
				drop pondndec pondnsansdiff pondndiff
			}
			
		save "$wfDMTG/wealthwithntf/wfwealthntf${year}${onglet}.dta",replace
			

}
}
macro drop onglet
