*****************************************************************************
*  Do-file used to create homogeneous series of wealth at death (1984-2010) *
*****************************************************************************
	
	* Add non-tax filers with 0 wealth such as the series are fully consistent with demographic structure of decedents
	* wf`year'demodec.dta

foreach year of global yearlistdmtg {
	global year=`year'

	* Number of decedents per year
		import excel using "$resultsDMTG/RawResults_ApD.xlsx", first clear sheet("stataDMTG")  cellrange(A4:C31)
		keep year ndeca
		quiet sum ndeca if year==${year}
		global ndeca${year}=r(mean)
		

* A) Demographic structure of the tax filer decedents
********************************************************
	use  "$wfDMTG/MTG/wf${year}succ.dta",clear
	tempfile a
	save "`a'", replace
		
	* Computations of the number of decedents by demographic parameters
			
		*  by year, age and gender
			replace age=20 if age<20
			replace age=100 if age>100
			gen aged=10*int(age/10)
			replace aged=90 if aged>90
			replace aged=20 if aged<20
			bys year sexe age : egen ntotage=sum(pondn)
			bys year sexe aged : egen ntotaged=sum(pondn)

			collapse aged ntotage ntotaged,by (year sexe age)
			sort year sexe aged age
			save "$wfDMTG/demodec/wfdemopositive${year}.dta", replace
			
		* by year and gender
			use "`a'", clear	
			erase "`a'"
			bys year sexe : egen ntot=sum(pondn)

		*  by year, gender and marital status
			global list "C M V D"
			foreach var in "C" "M" "V" "D" {
				bys year sexe : egen n`var' = sum(pondn) if mat=="`var'"
			}

		* by year, gender and dummy for having at least a child
			bys year sexe : egen nenf0=sum(pondn) if nenf01==0

	collapse  (mean) nenf0 nD nV nM nC ntot, by(year sexe) 
	merge 1:m year sexe using "$wfDMTG/demodec/wfdemopositive${year}.dta",update
	drop _merge
	save "$wfDMTG/demodec/wfdemopositive${year}.dta", replace
		

			
* B) Demographic structure of the decedents (entire population)
*****************************************************************	
	* Launch only on time: saved as wfdemofile.dta
		*do "$doDMTG/DMTG/dodemofile.do"
		
		
* C) Add non-tax filers
************************
* Imputation consistent with demographic structure of total decedents by year/age/gender 

	* Probability to have a given marital status among non filers
		use "$wfDMTG/demodec/wfdemofile.dta", clear
		merge m:m year sexe using "$wfDMTG/demodec/wfdemopositive${year}.dta",keepusing(nenf0 nD nV nM nC ntot)
		keep if year==${year}
		drop _merge
		
		replace pC=(pC*ndecsexe-nC)/(ndecsexe-ntot)
		replace pM=(pM*ndecsexe-nM)/(ndecsexe-ntot)
		replace pV=(pV*ndecsexe-nV)/(ndecsexe-ntot)
		replace pD=(pD*ndecsexe-nD)/(ndecsexe-ntot)
		replace penf0=(penf0*ndecsexe-nenf0)/(ndecsexe-ntot)
		* Adjustments: 
			*For some years, there can be more taxable decedents (in the DMTG files) of a given marital status than in the entire population of decedents
			foreach var of varlist pC pM pV pD penf0 {
				replace `var'=0 if `var'<0
			}
			gen tot = pC +pM +pV+ pD
			foreach var of varlist pC pM pV pD penf0 {
				replace `var'=`var'/tot
			}
			drop tot
	
	* Comparison of the number of decedents (DMTG files and entire pop of decedents) by year, age and gender	
		sort year sexe aged age
		merge m:m year sexe aged age using "$wfDMTG/demodec/wfdemopositive${year}.dta",keepusing(ntotage ntotaged)
		replace ntotage=0 if ntotage==.
		bys year sexe aged : egen temp=mean(ntotaged)
		replace ntotaged=temp if ntotaged==.
		drop _merge temp
		*drop nenf0-nC
	
	* Add non tax filers	
		* ntotage = Nuber of decedents by year/age/gender in DMTG files
		* ndecage = Nuber of decedents by year/age/gender in entire pop of decedents

		gen pondn=0 
		replace pondn = (ndecage-ntotage)
		* Adjustments:
			* For a given age and gender: pondn<0 => there can be more taxable decedents (in the DMTG files) than in the entire population of decedents
			* When pondn<1, we replace by pondn=0 and adjust the weight of decedents of same age groups (aged) and gender 
			
			* Dummy for observations to adjust
				gen probtemp=1 if pondn <1
				replace probtemp=0 if probtemp==.
				bys year sexe aged : egen prob=sum(probtemp)
				replace prob=1 if prob>1
				drop probtemp
				
				replace pondn=0 if pondn<1
				drop if pondn==0

			* Number of non-tax filer decedents by age groups and sex (before adjustment)
				bys year sexe aged : egen ndecaged2 = sum(pondn*(mat=="C" & nenf01==0))
			* Number of non-tax filer decedents by age groups and sex (what we should have)
				gen ndecagedverif = ndecaged-ntotaged 
			* adjustments
				replace pondn = pondn*ndecagedverif/ndecaged2 if prob==1
				drop ndecaged2 prob
			/* verif 
				bys year sexe aged : egen verif= sum(pondn*(mat=="C" & nenf01==0))
				gen verif2=verif-ndecagedverif
				sum verif2,d 
				drop verif verif2
				*/

	* Marital status and child dummy for non-tax filer
		replace pondn=pondn*pC if mat=="C" & age<100
		replace pondn=pondn*pM if mat=="M" & age<100
		replace pondn=pondn*pV if mat=="V" & age<100
		replace pondn=pondn*pD if mat=="D" & age<100
		replace pondn=pondn*penf0 if nenf01==0
		replace pondn=pondn*(1-penf0) if nenf01==1
		* Adjustment
			* For age>100, everybody is a widow (90% of the case in reality)
				drop if age >=100 &  (mat=="C" | mat=="M" | mat=="D")
				
			/* verif 
					bys year sexe aged : egen verif= sum(pondn)
					gen verif2=verif-ndecagedverif
					sum verif2,d 
					drop verif2
			*/		
					
	keep  age year sexe mat nenf01 pondn
	sort year sexe age
	
	* Complementray information
		
		* Identifier
			gen idsucc=10000 if year~=year[_n-1]  & year ~=1988
			replace idsucc=idsucc[_n-1]+1 if year==year[_n-1] & year ~=1988
		
		* Socio-demo variables
			gen yeardec=year 
			gen birth=year-age
			gen nenf=nenf01
		* Info about wealth : 0
			foreach var of newlist  pat actbrut passif actnet pat_exo patfon_brut patpro patfin_div patfin_int patfin_liqu patfin_av patfon_brut_exo patpro_exo patfin_div_exo patfin_int_exo patfin_liqu_exo patfin_av_exo donations dons10moins dons10plus donsman {
				gen `var'=0
			}
	* Merge with taxable decedents
		append using "$wfDMTG/MTG/wf${year}succ.dta"
		sort year idsucc

save "$wfDMTG/demodec/wf${year}demodec.dta", replace

	* Check for consistency with total number of decedents
		quiet sum pondn
		dis r(sum) -${ndeca${year}}*1000
		macro drop ndeca*

}


	