
set seed 71811881


*************************************************************************
* I) Compute parameters from ISF tabulations for Pareto interpolations  *
*************************************************************************

	use "$resultsISF/StataFiles/ISFtab19842010cor.dta",clear
	append using "$resultsISF/StataFiles/ISFtab20122016cor.dta"
	* Total number of tax brackets
		bys year : egen ntranche=max(tranche*(Nisf~=.))
		drop if tranche>ntranche
	* Pareto coefficient
		replace btranche=b if tranche==ntranche
		gen aPareto=btranche/(btranche-1)
		
	* Add P97
		expand 2 if tranche==1 
		replace tranche=0 if _n==_N | (tranche ==1 & tranche[_n+1]==1)
		sort year tranche
		replace p=97 if tranche==0
		* Total wealth, number of households and treshold above P97
			replace cumulNisf=(100-p)/100*nmen*1000 if tranche==0
			replace cumulYisf = ((cumulNisf/cumulNisf[_n+1])^(1/btranche))*cumulYisf[_n+1] if tranche==0
			replace thrisf= thrisf[_n+1]/((cumulYisf/cumulYisf[_n+1])^(1/(a-1))) if tranche==0
	keep year tranche thrisf nmen wealthNA nindiv cumulNisf cumulYisf p ntranche aPareto
	sort year tranche
	save "$resultsISF/StataFiles/paramISF19842016cor.dta",replace
		
***********************************************************************
* II) Estimation of the top wealth distribution using ISF tabulations *
***********************************************************************
foreach year of numlist 1984 1985 1993 1995/2010 2012 2013 2016 {
	
global year=`year'
	
* Importation of parameters	
*****************************
	use "$resultsISF/StataFiles/paramISF19842016cor.dta",clear
	keep if year==${year}
	sum ntranche
	local sup=r(max)
	foreach pas of numlist 0/`sup' {
		foreach var of varlist cumulNisf cumulYisf thrisf aPareto aPareto p {
			quiet sum `var' if tranche==`pas'
			global `var'`pas'=r(sum)
		}
	}
	foreach var of varlist nmen wealthNA ntranche nindiv {
		quiet sum `var' 
		global `var'=r(max)
	}
	

* Creation of the distribution
*********************************

	clear
	set obs 200000
	gen year=${year}

	* Weight, wealth ranking 
		gen pondn=${nmen}*0.03*1000/200000 
		gen classtkcn=.
		quietly su pondn
		global nbretot=r(sum)
		replace classtkcn=(r(sum)-sum(pondn)+1)/(${nmen}*1000)

	* Tax brackets and Pareto coefficient	
		gen tranche=0
		gen aPareto=0
		gen ymax=.
		gen ymin=.
		forval x=0/$ntranche {
			replace tranche=`x' if 1-classtkcn>=1-${cumulNisf`x'}/(${nmen}*1000)
			replace aPareto=${aPareto`x'} if tranche==`x'
		}
		local z =$ntranche-1
		forval x=0/`z'{
			local y=`x'+1
			replace ymax=${thrisf`y'} if tranche==`x'
			replace ymin=${thrisf`x'} if tranche==`x'
		}
		replace ymin= ${thrisf${ntranche}} if tranche==${ntranche}
	*Imputation of wealth
		egen somi=max(classtkcn), by(ymin)
		gen q=1-classtkcn/somi
		g patriISF=.
		replace patriISF=min(ymax-1,ymin/(1-q)^(1/aPareto))
	
	* Calage
		gen patri_tot=.
		local supp=$ntranche-1
		forval x=0/`supp'{
			local y=`x'+1
			replace patri_tot=${cumulYisf`x'}-${cumulYisf`y'} if tranche==`x'
		}
		replace patri_tot =${cumulYisf${ntranche}} if tranche==${ntranche}
		
		forval x=0/$ntranche{
			quiet sum patriISF [aw=pondn] if tranche==`x'
			replace patriISF=patriISF*patri_tot*1000/r(sum) if tranche==`x'
		}
		keep year pondn tranche classtkcn patriISF
		tempfile temp
		save "`temp'"
			
* Exportation of the resuts
*****************************
			
	* At the household level
		replace classtkcn=1-classtkcn
		egen share_patop1=sum(pondn*patriISF*(classtkcn>=0.99)/(${wealthNA}*${nmen}))
		egen share_patop05=sum(pondn*patriISF*(classtkcn>=0.995)/(${wealthNA}*${nmen}))
		egen share_patop01=sum(pondn*patriISF*(classtkcn>=0.999)/(${wealthNA}*${nmen}))
		gen share995=share_patop1 -share_patop05
		gen share999=share_patop05-share_patop01
		keep year share*
		keep if _n==1
		local line=${year}-1984+8
		drop year
		export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG6")  sheetmodify cell(G`line')  nolabel

	* At the individual level
		use "`temp'",clear
		erase "`temp'"
		bys tranche: gen uni=runiform()
		expand 2 if uni<=0.8
		replace patriISF=patriISF/2 if uni<=0.8
		
		keep year pondn patriISF
		sort year patriISF
		gen classtkcn=.
		quietly su pondn
		replace classtkcn=1-(r(sum)-sum(pondn)+1)/(${nindiv}*1000)
		
		egen share_patop1=sum(pondn*patriISF*(classtkcn>=0.99)/(${wealthNA}*${nmen}))
		egen share_patop05=sum(pondn*patriISF*(classtkcn>=0.995)/(${wealthNA}*${nmen}))
		egen share_patop01=sum(pondn*patriISF*(classtkcn>=0.999)/(${wealthNA}*${nmen}))
		gen share995=share_patop1 -share_patop05
		gen share999=share_patop05-share_patop01
		keep year share*
		keep if _n==1
		local line=${year}-1984+8
		export excel using "$projdirISF/GGP2016WealthAppendixG.xlsx", sheet("TG6")  sheetmodify cell(A`line')  nolabel
	}
