*******************************************************
* Exportation of the results related to GGP2016Wealth *
******************************************************* 

***************************************************************************************
* Part A : Creation of table at the decile level with interpolation for missing years *
***************************************************************************************
	
	* A.I)  Wealth: dperc_w.dta
	* A.II) Income by wealth groups: dperc_w_r_pretaxCN

	* A.I) Wealth: Creation of complete table with wealth share, wealth composition, average wealth and tresholds 1970-2014 
	************************************************************************************************************************
		
		* 1) Load the Data
		*******************
			import excel using "$resexp/exportresults_wealthcap.xlsx", first clear sheet("comptanat") cellrange(AB7:AK52) 
			foreach var of varlist patfon_owner_brut patfon_rent_brut passif patpro patfin_div patfin_int patfin_liqu patfin_av {
				rename `var' `var'_tot
			}
			
			gen sex=0
			order year sex 
			merge 1:m year sex   using "$resexp/gperc/gperc.dta"
			keep if sex==0 
			replace dperc=0 if dperc==.

			sort year gperc dperc
			bys year dperc: egen ntemp=sum(n)
			replace n=ntemp
			drop ntemp
			keep if dperc==1 | dperc~=dperc[_n-1] | year ~= year[_n-1]
			foreach var of varlist sh_patnonfi- sh_passif {
				replace `var'=`var'*share_dperc
			}
			
			drop _merge gperc 
			tempfile temp
			save "`temp'",replace
			keep year sex patmean pop n thr ytop b y0 dperc 
			tempfile temp2
			save "`temp2'",replace
			use "`temp'",clear
			erase "`temp'"
			keep year *_tot sh* dperc 
			reshape wide sh*, i(year *_tot) j(dperc)

		* 2) Interpolation for missing years
		*************************************
			
			* Reference year: 1970
			local base=1970
			
			* Period 1970-1975
				 local i =1970-`base'+1
				 local j=1975-`base'+1
				 foreach var of newlist patfon_owner_brut patfon_rent_brut patpro patfin_liqu patfin_av patfin_int patfin_div passif {
					 foreach num of numlist 0(10)90 95 99 995 999 {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
					 
			* Priod 1975-1979
				local i =1975-`base'+1
				 local j=1979-`base'+1
				 foreach var of newlist patfon_owner_brut patfon_rent_brut patpro patfin_liqu patfin_av patfin_int patfin_div passif {
					 foreach num of numlist 0(10)90 95 99 995 999 {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
					 
			* Priod 1979-1984
				local i =1979-`base'+1
				 local j=1984-`base'+1
				 foreach var of newlist patfon_owner_brut patfon_rent_brut patpro patfin_liqu patfin_av patfin_int patfin_div passif {
					 foreach num of numlist 0(10)90 95 99 995 999 {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			 
			 
			  * Period 1984-1988
				local i =1984-`base'+1
				 local j=1988-`base'+1
				foreach var of newlist patfon_owner_brut patfon_rent_brut patpro patfin_liqu patfin_av patfin_int patfin_div passif {
					 foreach num of numlist 0(10)90 95 99 995 999 {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			  * Period 1988-1990
				local i =1988-`base'+1
				local j=1990-`base'+1
				foreach var of newlist patfon_owner_brut patfon_rent_brut patpro patfin_liqu patfin_av patfin_int patfin_div passif {
					 foreach num of numlist 0(10)90 95 99 995 999 {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			* Period 2012-2014
				local i =2012-`base'+1
				foreach var of newlist patfon_owner_brut patfon_rent_brut patpro patfin_liqu patfin_av patfin_int patfin_div passif {
					 foreach num of numlist 0(10)90 95 99 995 999 {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i'])*`var'_tot[_n] if _n>`i' 
					 }
				 }
			
		* 3) Last adjustments
		***********************
			reshape long share_dperc sh_patnonfi sh_patfon_brut sh_patfon_owner_brut sh_patfon_rent_brut sh_patpro sh_patfin sh_patfin_liquint sh_patfin_liqu sh_patfin_int sh_patfin_div sh_patfin_av sh_passif,i(year-patfin_av_tot  ) j(dperc)
			replace sh_patfon_brut=sh_patfon_owner_brut+sh_patfon_rent_brut
			replace sh_patnonfi=sh_patfon_brut+ sh_patpro
			replace sh_patfin_liquint =sh_patfin_liqu+ sh_patfin_int
			replace sh_patfin=sh_patfin_liqu+ sh_patfin_int+ sh_patfin_div+ sh_patfin_av
			replace share_dperc= sh_patnonfi+ sh_patfin-sh_passif		
			gen sh_patfon_net=sh_patfon_brut-sh_passif
			gen sh_patfinhorsliqu=sh_patfin-sh_patfin_liqu
			
			drop *_tot
			gen sex=0
			order year sex dperc
			foreach var of varlist sh_patnonfi- sh_patfinhorsliqu {
				replace `var'=`var'/share_dperc
			}
		save "$resexp/dperc/dperc_w.dta",replace 
			
	* A.II) Income ranked by wealth: Creation of complete table with income share, income composition, average income and tresholds 1970-2012 
	*******************************************************************************************************************************************

		* 1) Load the Data
		*********************
			import excel using "$projdirDINA/GGP2017DINAAppendixC/DataFiles/Results/exportresults_DINA.xlsx", first clear sheet("comptanat") cellrange(A7:P52) 
			foreach var of newlist  rtrav rcap sal pension nonsal_labor rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av {
				rename `var'_pretaxCN `var'_tot
			}
			rename income income_tot
			drop E
			sort year
			gen sex=0 
			tempfile NA
			save "`NA'",replace
			
			merge 1:m year sex using "$resexp/gperc/gperc_w_r_pretaxCN.dta"
			keep if sex==0
			rename sh_r_pretaxCN share_dperc
			replace dperc=0 if dperc==.
			sort sex year dperc		
			drop _merge 
			keep year sex  sh* dperc
			reshape wide sh*, i(year sex) j(dperc)
			merge 1:1 year sex using "`NA'"
			drop _merge
			sort sex year
		
		* 2) Interpolation
		********************
		
			* Year of reference of the database: 1970
			local base=1970
			
			* Period 1970-1975
				 local i =1970+1-`base'
				  local j=`i'+5
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_tot[`i']+(sh_`var'`num'[`j']/rfon_tot[`j'] -sh_`var'`num'[`i']/rfon_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			
			* Period 1975-1979
				 local i =1975-`base'+1
				 local j=`i'+4
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_tot[`i']+(sh_`var'`num'[`j']/rfon_tot[`j'] -sh_`var'`num'[`i']/rfon_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
				 
			* Period 1979-1984
				 local i =1979-`base'+1
				 local j=`i'+5
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_tot[`i']+(sh_`var'`num'[`j']/rfon_tot[`j'] -sh_`var'`num'[`i']/rfon_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			 
			* Period 1984-1988
				 local i =1984-`base'+1
				 local j=`i'+4
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_tot[`i']+(sh_`var'`num'[`j']/rfon_tot[`j'] -sh_`var'`num'[`i']/rfon_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			
			* Period 1988-1990
				local i =1988-`base'+1
				 local j=`i'+2
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i']+(sh_`var'`num'[`j']/`var'_tot[`j'] -sh_`var'`num'[`i']/`var'_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_tot[`i']+(sh_`var'`num'[`j']/rfon_tot[`j'] -sh_`var'`num'[`i']/rfon_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			* Period 2012-2014
				local i =2012-`base'+1
				 local j=`i'+3
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_tot[`i'])*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_tot[`i'])*`var'_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_tot[`i'])*rfon_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			drop wealth-rfin_av_tot
			reshape long share_dperc sh_rtrav_pretaxCN sh_rcap sh_sal_pretaxCN sh_pension_pretaxCN sh_nonsal_labor_pretaxCN sh_rfon sh_rfon_owner sh_rfon_rent sh_nonsal_capital sh_rfin sh_rfin_div sh_rfin_int sh_rfin_liqu sh_rfin_av sh_nonsal_pretaxCN,i(year sex) j(dperc)
			
		* 3) Last adjustments
		***********************
			replace sh_nonsal_pretaxCN= sh_nonsal_labor_pretaxCN +sh_nonsal_capital
			replace sh_rfin =sh_rfin_div +sh_rfin_int +sh_rfin_liqu+ sh_rfin_av
			replace sh_rcap= sh_rfon +sh_nonsal_capital+ sh_rfin
			replace sh_rtrav_pretaxCN= sh_sal_pretaxCN +sh_pension_pretaxCN+ sh_nonsal_labor_pretaxCN
			replace share_dperc= sh_rtrav_pretaxCN+	sh_rcap
			
			order year sex dperc
			foreach var of varlist sh_rtrav_pretaxCN-sh_nonsal_pretaxCN {
				replace `var'=`var'/share_dperc
			}
			sort sex year dperc
			save "$resexp/dperc/dperc_w_r_pretaxCN.dta",replace 

	
*********************************************************
* Part B: Exportation of results on wealth distribution *	
*********************************************************
	
	* All results are exported in xls file exportresults_wealthcap
	
	* I)  Wealth share and wealth composition
		* 1) Detailed series for distribution of wealth
		* 2) Summary statistics for the distribution of wealth
		* 3) Wealth composition by decile or broad groups
	* II) Determinants of wealth inequality by wealth groups (rates of return, real rates of capital gains, savings rate, labor income share)
		* 1) Distribution of national income, labor income and capital income ranked by wealth
		* 2) Rate of returns, rate of capital gain and saving rate  by decile and broad groups
	* III)Wealth inequality by age groups
		* 1) Summary statistics for the distribution of wealth by broad age groups
		* 2) Summary statistics for the distribution of wealth by decenial age
		* 3) Wealth/age profiles 
	* IV) Robustness checks by broad groups
	* V) Simulations for 1970-2012 using constant capital gains by assets and/or saving rate
	
* B.I)  Wealth share and wealth composition
*********************************************
	
	* 1) Detailed series for distribution of wealth without missing years
	***********************************************************************
		local i=0
		use "$resexp/gperc/gperc.dta",clear
		keep year gperc sex  thr ytop b n y0
		keep if sex==`i'
		drop sex
		tempfile temp
		save "`temp'",replace
		
		* Add interpolated years from Tom Programm
			foreach num of numlist 1971/1974 1976/1978 1980/1983 1985/1987 1989 2013 2014  {
				dis `num'
				clear
				insheet using "$resexp/Pareto interpolations/`num'.csv",    delimiter(",")
				drop year average
				if `num'<1985 | `num'>=2013 {
					replace b="" if b=="Inf"
					destring _all, replace dpcomma
				}
				gen year=`num'
				gen gperc=round(p*100) if p<0.985
				replace gperc=round(p*1000) if  p<0.9985 & gperc==.
				replace gperc=round(p*10000) if  p<0.99985 & gperc==.
				replace gperc=round(p*100000) if  p>0.99985 & gperc==.
				drop p topsh
				rename topavg ytop
				append using "`temp'"
				erase "`temp'"
				tempfile temp
				save "`temp'",replace		
			}
	
		import excel using "$resexp/exportresults_wealthcap.xlsx", first clear sheet("comptanat") cellrange(A7:D52) 
		replace pop=pop*1000
		gen patmean=wealth*1000000000/pop
		drop wealth income
		merge 1:m year using "`temp'"
		erase "`temp'"
		drop _merge
		
		gen ntemp=0.01 if n==.
		replace ntemp=ntemp/10 if n==. & gperc>99
		replace ntemp=ntemp/10 if n==. & gperc>999
		replace ntemp=ntemp/10 if n==. & gperc>9999
		replace n=ntemp*pop if n==.
		drop ntemp
		* Intermediate average
			gsort + year - gperc
			bys year : gen npop =sum(n)
			sort year gperc
			gen yint=(ytop*npop-ytop[_n+1]*npop[_n+1])/(npop-npop[_n+1]) if year==year[_n+1] 
			replace yint=ytop if gperc==99999
		* Round value
			foreach var of varlist yint thr {
				replace `var'=round(`var')
			}
		* Check error
			replace thr=round((yint+yint[_n-1])/2) if (yint<thr[_n+1] & yint[_n-1]>thr[_n-1] & yint>yint[_n-1] & thr<yint[_n-1]) & gperc~=99999
			replace yint=round((thr+thr[_n+1])/2) if (thr>=yint[_n-1] & yint[_n-1]>=thr[_n-1] & thr<=thr[_n+1] & thr[_n+1]<=yint[_n+1] & thr>yint) & gperc~=99999
			gsort year -gperc
			bys year :gen tot=sum(n)
			bys year : gen tot2=sum(n*yint)
			replace ytop=tot2/tot 
			replace b=ytop/thr	
			drop npop tot tot2
		* Check
			sort year gperc
			gen prob=0
			replace prob=1 if thr>thr[_n+1] & year==year[_n+1]
			replace prob=1 if yint>thr[_n+1] & year==year[_n+1]
			replace prob=1 if yint<thr & year==year[_n+1]
			replace prob=1 if yint>yint[_n+1] & year==year[_n+1]
			tab year if prob==1
			drop prob
		sort year gperc
		gen sex=0
		order year sex patmean pop gperc n thr ytop b y0 
		save "$resexp/gperc/gperc_19702014.dta",replace
		* Exportation to excel table	
			drop patmean pop n sex y0 yint
			reshape wide thr ytop b,i(gperc) j(year)
			drop gperc 
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("gperc_w")   sheetmodify cell(B13) firstrow(variables)
	
	
	* 2) Summary statistics for the distribution of wealth 
	*******************************************************
		local i=0
		clear
		set obs 45
		gen year =1969+_n
		gen sex=`i'
		gen gperc=0
		merge 1:m year sex gperc using "$resexp/gperc/gperc_19702014.dta"
		keep year gperc sex  thr ytop b n y0
		keep if sex==`i'
		drop sex 
		
		* Pop above the threshold
			gsort + year - gperc 
			bys year : gen npop =sum(n)
		* Definition of wealth groups
			keep if gperc==0 | gperc==10 | gperc==50 | gperc==90  | gperc==990 | gperc==9990 | gperc==99990 | gperc==99999 
			
		* Wealth shares
			sort year gperc
			bys year : egen ytot=sum(npop*ytop*(gperc==0))
			gen share=ytop*npop
			replace share=share[_n-1]-share if gperc==10 
			replace share=share-share[_n+2] if gperc==0 
			replace share=share-share[_n+1] if gperc==50  
			replace share=share/ytot
		* Other
			bys year : egen yav=sum(ytop*(gperc==0))
			replace yav=. if ytop==.
			gen thr_perc=thr/yav
		* Supress interpolated info above P99.9
			foreach var of varlist thr_perc share b thr {
						replace `var'`num'=. if year<1990 & year~=1970 & year~=1975 & year~=1979 & year~=1984 & year~=1988 & gperc>=9991
			}
			keep yav share thr_perc b thr year gperc y0
			reshape wide share thr_perc  b thr ,i(year yav y0 ) j(gperc)
			drop  year   thr0 b0   thr_perc0	
			order  yav share10  share* y0 thr_perc* b* thr*
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("sum_stat_w")   sheetmodify cell(B8) firstrow(variables)
		
	* 3) Wealth composition by decile and broad groups
	***************************************************
		* a) Wealth composition by broad groups
			use "$resexp/dperc/dperc_w.dta",clear
			drop sex
			gen bperc=dperc
			replace bperc=0 if dperc<50
			replace bperc=50 if dperc >=50 & dperc<90
			foreach var of varlist sh_patnonfi- sh_patfinhorsliqu {
				replace `var'=`var'*share_dperc
			}
			collapse (sum) sh* ,by(year bperc)
			rename share_dperc share_bperc
			order sh_patfon_net,after(sh_patfon_rent_brut)
			reshape wide sh*, i(year) j(bperc)
			
			foreach var of newlist share_bperc sh_patnonfi sh_patfon_brut sh_patfon_owner_brut sh_patfon_rent_brut sh_patfon_net sh_patpro sh_patfin sh_patfin_liquint sh_patfin_liqu sh_patfin_int sh_patfin_div sh_patfin_av sh_passif  sh_patfinhorsliqu {
				replace `var'99=`var'99+`var'995+`var'999
				drop `var'995
				replace `var'90=`var'90+`var'95+`var'99
				drop `var'95
				gen `var'9=`var'90-`var'99
				gen `var'09=`var'99-`var'999
			}
			order year *0 *50 *90 *99 *999
			order *09 ,last
			* shares in % of total wealth
				export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("compo_sum2")   sheetmodify cell(A8) firstrow(variables)
			* shares in % wealth share 
				foreach var of newlist sh_patnonfi sh_patfon_brut sh_patfon_owner_brut sh_patfon_rent_brut sh_patfon_net sh_patpro sh_patfin sh_patfin_liquint sh_patfin_liqu sh_patfin_int sh_patfin_div sh_patfin_av sh_passif  sh_patfinhorsliqu {
					foreach num of numlist 0 50 90 99 999 9 {
						replace `var'`num'=`var'`num'/share_bperc`num'
					}
					replace `var'09=`var'09/share_bperc09
				}
				export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("compo_sum1")   sheetmodify cell(A8) firstrow(variables)

		
		* b) Wealth composition by decile
			use "$resexp/dperc/dperc_w.dta",clear
			drop sex
			order sh_patfon_net,after(sh_patfon_rent_brut)
			reshape wide sh*, i(year) j(dperc)
			* shares in % wealth share 
				export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("compo_det1")   sheetmodify cell(A8) firstrow(variables)
			* shares in % of total wealth
				foreach var of newlist sh_patnonfi sh_patfon_brut sh_patfon_owner_brut sh_patfon_rent_brut sh_patfon_net sh_patpro sh_patfin sh_patfin_liquint sh_patfin_liqu sh_patfin_int sh_patfin_div sh_patfin_av sh_passif  sh_patfinhorsliqu {
					foreach num of numlist 0(10)90 95 99 995 999 {
						replace `var'`num'=`var'`num'*share_dperc`num'
					}
				}
				export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("compo_det2")   sheetmodify cell(A8) firstrow(variables)
			* shares in % of wealth share (ordered by decile instead of year)
				use "$resexp/dperc/dperc_w.dta",clear
				drop sex
				keep year dperc sh_patfinhorsliqu sh_patfin_liqu sh_patpro sh_patfon_net
				order year dperc sh_patfon_net sh_patpro  sh_patfinhorsliqu sh_patfin_liqu 
				reshape wide sh*, i(dperc) j(year)
				drop dperc
				export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("compo_det1_decile")   sheetmodify cell(B8) firstrow(variables)

				
* B.II) Determinants of wealth inequality by wealth groups (rates of return, real rates of capital gains, savings rate, labor income share)
**********************************************************************************************************************************************
	
	*  1) Distribution of national income, labor income and capital income ranked by wealth
	****************************************************************************************
			use "$resexp/dperc/dperc_w_r_pretaxCN.dta",clear
			keep year dperc share_dperc sh_rtrav_pretaxCN sh_rcap
			foreach var of varlist sh_rtrav_pretaxCN sh_rcap {
				replace `var'=`var'*share_dperc
			}
			
			gsort + year -dperc
			foreach var of varlist share_dperc sh_rtrav_pretaxCN sh_rcap {
				bys year : gen `var'_cumul=sum(`var')
				replace `var'=`var'_cumul if dperc>=90
				drop `var'_cumul
			}
			gen bperc=50 if dperc<=40
			replace bperc=40 if dperc>40 & dperc<90
			replace bperc=dperc if bperc==.
			collapse (sum) share_dperc sh_rtrav_pretaxCN sh_rcap,by(year bperc)
			foreach var of varlist sh_rtrav_pretaxCN sh_rcap {
				bys year : egen `var'_cumul=sum(`var'*(bperc<=90))
				replace `var'=`var'/`var'_cumul
				drop `var'_cumul
			}
			reshape wide share_dperc sh_rtrav_pretaxCN sh_rcap ,i(year) j(bperc)
			order  *50 *40 *90 *95 *99 
			order *995 *999,last
			order year share_dperc* sh_rtrav_pretaxCN* sh_rcap*
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("sum_stat_w_r")   sheetmodify cell(A8) firstrow(variables)
		
		
	
	* 2) Rate of returns, rate of capital gain and saving rate  by decile and broad groups
	***************************************************************************************
		import excel using "$resexp/exportresults_wealthcap.xlsx", first clear sheet("comptanat") cellrange(A7:Z52) 
		merge 1:m year using "$resexp/dperc/dperc_w.dta"
		drop _merge
		rename share_dperc share_dperc_pat
		merge 1:m year sex dperc using "$resexp/dperc/dperc_w_r_pretaxCN.dta",keepusing(share_dperc)
		rename share_dperc share_dperc_rev
		drop _merge sex
		order year dperc
		sort year dperc
		drop sh_patnonfi sh_patfon_owner_brut sh_patfon_rent_brut sh_patfin sh_patfin_liquint  sh_patfinhorsliqu
		reshape wide sh*, i(year) j(dperc)
		foreach var of newlist sh_patfon_brut sh_patpro sh_patfin_liqu sh_patfin_int sh_patfin_div sh_patfin_av sh_passif sh_patfon_net {
			foreach num of numlist 0(10)90 95 99 995 999 {
				replace `var'`num'=`var'`num'*share_dperc_pat`num'
			}
		}
		foreach var of newlist  share_dperc_pat sh_patfon_brut sh_patpro sh_patfin_liqu sh_patfin_int sh_patfin_div sh_patfin_av sh_passif sh_patfon_net share_dperc_rev {
			gen `var'bot50=`var'0+`var'10+`var'20+`var'30+`var'40
			gen `var'mid40=`var'50+`var'60+`var'70+`var'80
			gen `var'top10=`var'90+`var'95+`var'99+`var'995+`var'999
			gen `var'top1=`var'99+`var'995+`var'999
			gen `var'top101=`var'top10-`var'top1
			gen `var'top11=`var'top1-`var'999
			gen `var'bot90=`var'bot50+`var'mid40
			gen `var'bot99=`var'bot90+`var'top101
		}
		
		
		* Rate of return
			foreach num of numlist 0(10)90 95 99 995 999  {
				gen return1_`num'= (sh_patfon_brut`num'*returnfon_brut +sh_patpro`num'*returnpro - sh_passif`num'*returnpassif + sh_patfin_liqu`num'*returnfi_liqu + sh_patfin_int`num'*returnfi_int+ sh_patfin_div`num'*returnfi_div  + sh_patfin_av`num' * returnfi_av )/share_dperc_pat`num'
				gen return2_`num'= (sh_patfon_brut`num'*returnfon_brut +sh_patpro`num'*returnpro - sh_passif`num'*returnpassif + sh_patfin_liqu`num'*returnfi_liqu + (sh_patfin_int`num'+sh_patfin_div`num')*returnfi_divint + sh_patfin_av`num' * returnfi_av )/share_dperc_pat`num'
				gen return3_`num'= (sh_patfon_net`num'*returnfon_net +sh_patpro`num'*returnpro   + sh_patfin_liqu`num'*returnfi_liqu + sh_patfin_int`num'*returnfi_int+ sh_patfin_div`num'*returnfi_div  + sh_patfin_av`num' * returnfi_av )/share_dperc_pat`num'
				}
			foreach num of newlist bot50 mid40 top10 top1 top101 top11 bot90 bot99{
				gen return1_`num'= (sh_patfon_brut`num'*returnfon_brut +sh_patpro`num'*returnpro - sh_passif`num'*returnpassif + sh_patfin_liqu`num'*returnfi_liqu + sh_patfin_int`num'*returnfi_int+ sh_patfin_div`num'*returnfi_div  + sh_patfin_av`num' * returnfi_av) /share_dperc_pat`num'
				gen return2_`num'= (sh_patfon_brut`num'*returnfon_brut +sh_patpro`num'*returnpro - sh_passif`num'*returnpassif + sh_patfin_liqu`num'*returnfi_liqu + (sh_patfin_int`num'+sh_patfin_div`num')*returnfi_divint + sh_patfin_av`num' * returnfi_av )/share_dperc_pat`num'
				gen return3_`num'= (sh_patfon_net`num'*returnfon_net +sh_patpro`num'*returnpro   + sh_patfin_liqu`num'*returnfi_liqu + sh_patfin_int`num'*returnfi_int+ sh_patfin_div`num'*returnfi_div  + sh_patfin_av`num' * returnfi_av )/share_dperc_pat`num'
				}

			drop return- returnfi_divint

		* Capital gain
			foreach num of numlist 0(10)90 95 99 995 999  {
				gen capgain1_`num'= (sh_patfon_brut`num'*capgainfon_brut +sh_patpro`num'*capgainpro - sh_passif`num'*capgainpassif + sh_patfin_liqu`num'*capgainfi_liqu + sh_patfin_int`num'*capgainfi_int+ sh_patfin_div`num'*capgainfi_div  + sh_patfin_av`num' * capgainfi_av)/share_dperc_pat`num' 
				gen capgain2_`num'= (sh_patfon_brut`num'*capgainfon_brut +sh_patpro`num'*capgainpro - sh_passif`num'*capgainpassif + sh_patfin_liqu`num'*capgainfi_liqu + (sh_patfin_int`num'+sh_patfin_div`num')*capgainfi_divint + sh_patfin_av`num' * capgainfi_av )/share_dperc_pat`num'
				gen capgain3_`num'= (sh_patfon_net`num'*capgainfon_net +sh_patpro`num'*capgainpro  + sh_patfin_liqu`num'*capgainfi_liqu + sh_patfin_int`num'*capgainfi_int+ sh_patfin_div`num'*capgainfi_div  + sh_patfin_av`num' * capgainfi_av)/share_dperc_pat`num' 

			}
			foreach num of newlist bot50 mid40 top10 top1 top101 top11 bot90 bot99 {
				gen capgain1_`num'= (sh_patfon_brut`num'*capgainfon_brut +sh_patpro`num'*capgainpro - sh_passif`num'*capgainpassif + sh_patfin_liqu`num'*capgainfi_liqu + sh_patfin_int`num'*capgainfi_int+ sh_patfin_div`num'*capgainfi_div  + sh_patfin_av`num' * capgainfi_av )/share_dperc_pat`num'
				gen capgain2_`num'= (sh_patfon_brut`num'*capgainfon_brut +sh_patpro`num'*capgainpro - sh_passif`num'*capgainpassif + sh_patfin_liqu`num'*capgainfi_liqu + (sh_patfin_int`num'+sh_patfin_div`num')*capgainfi_divint + sh_patfin_av`num' * capgainfi_av )/share_dperc_pat`num'
				gen capgain3_`num'= (sh_patfon_net`num'*capgainfon_net +sh_patpro`num'*capgainpro + sh_patfin_liqu`num'*capgainfi_liqu + sh_patfin_int`num'*capgainfi_int+ sh_patfin_div`num'*capgainfi_div  + sh_patfin_av`num' * capgainfi_av)/share_dperc_pat`num' 
				}
			drop capgain-capgainfi_divint capgain_nom 
			
		* Saving rate
			keep year return?_* capgain?_* inflation  share_dperc_pat* share_dperc_rev* wealth income
			foreach var of varlist share_dperc_pat* {
				replace `var'=`var'*wealth*1000000000
			}
			foreach var of varlist share_dperc_rev* {
				replace `var'=`var'*income*1000000000
			}
			foreach num of numlist 0(10)90 95 99 995 999  {
				gen sav1_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain1_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_rev`num'
				gen sav2_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain2_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_rev`num'
				gen sav3_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain3_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_rev`num'
				gen savpat1_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain1_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_pat`num'
				gen savpat2_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain2_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_pat`num'
				gen savpat3_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain3_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_pat`num'
			}
			foreach num of newlist bot50 mid40 top10 top1 top101 top11 bot90 bot99 {
				gen sav1_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain1_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_rev`num'
				gen sav2_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain2_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_rev`num'
				gen sav3_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain3_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_rev`num'
				gen savpat1_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain1_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_pat`num'
				gen savpat2_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain2_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_pat`num'
				gen savpat3_`num'= (share_dperc_pat`num'[_n+1]/(1+capgain3_`num')/(1+inflation)-share_dperc_pat`num')/share_dperc_pat`num'
			}
			keep year return?_* capgain?_* sav?_* savpat?_*
			order savpat?_*,last
		
		tempfile temp
		save "`temp'",replace
		keep year return1_* capgain1_* sav1_* savpat1_*
		order year *_bot50 *_mid40 *_top10 *_top1 *_999
		order *_bot90 *_bot99,last
		order year return* capgain* sav* savpat*
		order savpat*,last
		export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("returncapgain")   sheetmodify cell(A8) firstrow(variables)
		use "`temp'",clear
		keep year return2_* capgain2_* sav2_* savpat2_*
		order year *_bot50 *_mid40 *_top10 *_top1 *_999
		order *_bot90 *_bot99,last
		order year return* capgain* sav* savpat*
		order savpat*,last
		export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("returncapgain2")   sheetmodify cell(A8) firstrow(variables)
		use "`temp'",clear
		erase "`temp'"
		keep year return3_* capgain3_* sav3_* savpat3_*
		order year *_bot50 *_mid40 *_top10 *_top1 *_999
		order *_bot90 *_bot99,last
		order year return* capgain* sav* 
		order savpat*,last
		export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("returncapgain3")   sheetmodify cell(A8) firstrow(variables)
		
* B.III) Wealth inequality by age groups
*****************************************

	* 1) Summary statistics for the distribution of wealth by broad age groups
	***************************************************************************
		clear
		set obs 43
		gen year =1969+_n
		gen bperc=0
		gen bage=20
		merge 1:m year bage bperc using "$resexp/other/bperc_bage.dta"
		drop _merge
				
		* Wealth shares
			gsort + year bage - bperc 
			rename share_bperc_bage share
			* Au-dessus de P90, share =Pxx-100
				bys year bage : gen temp =sum(share)
				replace share=temp if bperc>=90 & bperc<=999
			* Pour P0-50 :
				replace share=share + share[_n-1] if bperc==0 & bperc[_n-1]==10
			
		gen thr_perc=thr/patmean_bage	
		keep year bage bperc patmean_bage   share thr_perc b thr 
		reshape wide share thr_perc  b thr patmean_bage ,i(year bperc  ) j(bage)
		reshape wide share* thr*  b??  ,i(year patmean_bage??) j(bperc)
		drop share?010 thr?00 b?00  thr_perc?00
		order year patmean_bage20 share20* thr_perc20* b20* thr20* patmean_bage40 share40*  thr_perc40* b40* thr40* 
		order  patmean_bage60 share60*  thr_perc60* b60*  thr60*,last
		export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("sum_stat_bage")   sheetmodify cell(A8) firstrow(variables)
		
	* 2) Summary statistics for the distribution of wealth by decenial age
	***************************************************************************
		clear
		set obs 43
		gen year =1969+_n
		gen bperc=0
		gen aged=2
		merge 1:m year aged bperc using "$resexp/other/bperc_aged.dta"
		drop _merge
				
		* Wealth shares
			gsort + year aged - bperc 
			rename share_bperc_aged share
			* Au-dessus de P90, share =Pxx-100
				bys year aged : gen temp =sum(share)
				replace share=temp if bperc>=90 & bperc<=999
			* Pour P0-50 :
				replace share=share + share[_n-1] if bperc==0 & bperc[_n-1]==10
			
		gen thr_perc=thr/patmean_aged	
		keep year aged bperc patmean_aged   share thr_perc b thr 
		reshape wide share thr_perc  b thr patmean_aged ,i(year bperc  ) j(aged)
		reshape wide share* thr*  b?  ,i(year patmean_aged?) j(bperc)
		drop share?10 thr?0 b?0  thr_perc?0
		order year patmean_aged2 share2* thr_perc2* b2* thr2*  patmean_aged3 share3* thr_perc3* b3* thr3* patmean_aged4 share4* thr_perc4* b4* thr4* patmean_aged5 share5* thr_perc5* b5* thr5* patmean_aged6 share6* thr_perc6* b6* thr6* patmean_aged7 share7* thr_perc7* b7* thr7*   
		order  patmean_aged8 share8*  thr_perc8* b8*  thr8*,last
		export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("sum_stat_aged")   sheetmodify cell(A8) firstrow(variables)
	
	* 3) Wealth/age profiles
	****************************
		use  "$resexp/other/wealth_age_sex.dta",clear
		drop if age>80
		keep if sex==0
		* age-wealth profile (in % of average wealth)
			bys year: egen tot=sum(n*yav) 
			bys year: egen ntot=sum(n)
			gen moy=tot/ntot
			gen yav_old=yav/moy 
		tempfile base
		save "`base'",replace
		* Smoothing
		foreach var of numlist 1970 1975 1979 1984 1988 1990 1991 1992/2012 {
			use "`base'",clear
			di `var'
			cap drop yav_smoo*
			keep if year==`var'  
		 	lpoly yav_old age [aw=n], at(age)    generate(ratio_wealth)
			if (`var'>1970){
				append using "`temp'"
				erase "`temp'"
			}	
				tempfile temp
				save "`temp'", replace
		}
		keep year age ratio_wealth n
		save "$resexp/other/smoothed_ratio_wealth_age", replace  
		
		* Exportation of the results
			rename ratio_wealth ratio
			drop n
			reshape wide ratio ,i(age) j(year)
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("age_wealth")   sheetmodify cell(A8) firstrow(variables)


* B.IV) Robustness checks by broad groups	
*******************************************
	* Baseline wealth series
		use  "$resexp/dperc/dperc_w.dta",clear
		keep year dperc share_dperc
		rename share_dperc share_bperc_w
		drop if year>2012
	* Merge with wealth series using alternative imputation for life insurance
		foreach num of newlist A B C {
			merge 1:m year dperc using "$resexp/gperc/gperc_avie`num'.dta",keepusing(share_dperc)
			drop _merge
			sort year dperc
			keep if dperc~=dperc[_n-1]
			rename share_dperc share_bperc_avie`num'
		}
	* Merge with wealth series using alternative imputation for owner-occupied housing (housENL, housEPrevtot) or interests and dividends capitalizd separately (corTS)
		foreach var of newlist _housENL _housEPrevtot _corTS {
			merge 1:m year dperc using "$resexp/gperc/gperc`var'.dta",keepusing(share_dperc)
			drop _merge
			sort year dperc
			keep if dperc~=dperc[_n-1]
			rename share_dperc share_bperc`var'
		}
	* Definition of broad groups
		gen bperc=dperc
		replace bperc=0 if dperc<50
		replace bperc=50 if dperc >=50 & dperc<90
		collapse (sum) share*  ,by(year bperc)
		foreach var of varlist share* {
			replace `var'=. if `var'==0
		}
		reshape wide share_bperc_w share_bperc_avieA share_bperc_avieB share_bperc_avieC share_bperc_housENL share_bperc_housEPrevtot share_bperc_corTS, i(year) j(bperc)
		
		foreach var of newlist share_bperc_w share_bperc_avieA share_bperc_avieB share_bperc_avieC share_bperc_housENL share_bperc_housEPrevtot share_bperc_corTS {
			replace `var'99=`var'99+`var'995+`var'999
			drop `var'995
			replace `var'90=`var'90+`var'95+`var'99
			drop `var'95
			gen `var'9=`var'90-`var'99
			gen `var'09=`var'99-`var'999
		}
	
	order share_bperc_corTS* share_bperc_housENL* share_bperc_housEPrevtot* share_bperc_avieA* share_bperc_avieB* share_bperc_avieC*,last
	export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("robustness")   sheetmodify cell(A8) firstrow(variables)

		
* B.V) Simulations for 1970-2012 using constant capital gains by assets and/or saving rate
*******************************************************************************************		
			
		use  "$resexp/dperc/dperc_w.dta",clear
		drop sex 
		gen bperc=dperc
		replace bperc=0 if dperc<50
		replace bperc=50 if dperc >=50 & dperc<90
		foreach var of varlist sh_patnonfi- sh_patfinhorsliqu {
			replace `var'=`var'*share_dperc
		}
		collapse (sum) sh*  ,by(year bperc)
		tempfile temp 
		save "`temp'",replace
		
		* National accounts data
			import excel using "$resexp/exportresults_wealthcap.xlsx", first clear sheet("comptanat") cellrange(AS7:EE52) 
			drop BE-BW 
			merge 1:m year using "`temp'"
			erase "`temp'"
			drop _merge sh_patnonfi sh_patfon_brut sh_patfon_net sh_patfin sh_patfin_liquint sh_patfinhorsliqu share_dperc index
			sort year bperc
		tempfile temp 
		save "`temp'",replace
		forval i=1/6 {
			use "`temp'",clear
			foreach var of newlist patfon_owner_brut patfon_rent_brut passif patpro patfin_div patfin_int patfin_liqu patfin_av {
				gen sh_`var'_capgain`i'=sh_`var'*pat_tot*`var'_capgain`i'/`var'_tot/pat_capgain`i'
				drop sh_`var'
			}
			 * Derniers ajustements
				 gen sh_patfon_brut_capgain`i'=sh_patfon_owner_brut_capgain`i'+sh_patfon_rent_brut_capgain`i'
				 gen sh_patnonfi_capgain`i'=sh_patfon_brut_capgain`i'+ sh_patpro_capgain`i'
				 gen sh_patfin_capgain`i'=sh_patfin_liqu_capgain`i'+ sh_patfin_int_capgain`i'+ sh_patfin_div_capgain`i'+ sh_patfin_av_capgain`i'
				 gen sh_patfon_net_capgain`i'=sh_patfon_brut_capgain`i'-sh_passif_capgain`i'
				 gen sh_patfinhorsliqu_capgain`i'=sh_patfin_capgain`i'-sh_patfin_liqu_capgain`i'
				 gen share_bperc_capgain`i'= sh_patnonfi_capgain`i'+ sh_patfin_capgain`i'-sh_passif_capgain`i'	

			reshape wide sh*, i(year) j(bperc)
			
		foreach var of newlist share_bperc sh_patnonfi sh_patfon_brut sh_patfon_owner_brut sh_patfon_rent_brut sh_patfon_net sh_patpro sh_patfin  sh_patfin_liqu sh_patfin_int sh_patfin_div sh_patfin_av sh_passif  sh_patfinhorsliqu {
			replace `var'_capgain`i'99=`var'_capgain`i'99+`var'_capgain`i'995+`var'_capgain`i'999
			drop `var'_capgain`i'995
			replace `var'_capgain`i'90=`var'_capgain`i'90+`var'_capgain`i'95+`var'_capgain`i'99
			drop `var'_capgain`i'95
			gen `var'_capgain`i'9=`var'_capgain`i'90-`var'_capgain`i'99
			gen `var'_capgain`i'09=`var'_capgain`i'99-`var'_capgain`i'999
		}
		
		* Pour le moment on n'exporte que les shares : on verra si on a besoin de plus
		keep share_bperc*
		order  *0 *50 *90 *99 *999
		order *09 ,last
		if `i'==1 {
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("simulation")   sheetmodify cell(B8) firstrow(variables)
		}
		if `i'==2 {
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("simulation")   sheetmodify cell(I8) firstrow(variables)
		}
		if `i'==3 {
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("simulation")   sheetmodify cell(P8) firstrow(variables)
		}
		if `i'==4 {
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("simulation")   sheetmodify cell(W8) firstrow(variables)
		}
		if `i'==5 {
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("simulation")   sheetmodify cell(AD8) firstrow(variables)
		}
		if `i'==6 {
			export excel using "$resexp/exportresults_wealthcap.xlsx", sheet("simulation")   sheetmodify cell(AK8) firstrow(variables)
		}
		
	}
		

	