/********************************************************
 Do-file used to harmonize the wealht survey 1992	*
*********************************************************/

set more off
clear

set seed 187371
local year=1992
*global datapat "\\ulysse\users\BGarbinti\brtrd\Projet wealth_income\Hors_structure\Wealth surveys\Wealth surveys\Data\Fichiers sources"

use "$datapat/EP 92/Stata/act921.dta",clear
gen year=1992
keep ident lien* sexe* matri* cs* anais* nivsoc pond nbind nbenf hodo log107 log108 re*  cc3  patpromi patproma year cc3 cd1 cd3 le115? le13 elo115? elo12 mob116? mob13* bct12 ass110* log107 log108 log110 log111 log119? log120? log124? log125? log126 log127 t14* t15* p14* p17* patpromi patproma
drop sexepr-cs2cj cs2? cs2??
* 2 observations with false link
replace lien1="1" if lien1=="5"

* A) Socio-demographic variables 
**********************************
			
	* Identifier
		* Household : identmen, Individual : identind
	* Weight
		gen pondn=pond
	* Age
		gen age=1992-real(anais1)
		sum age
	* Decenial age 
		gen aged=int(age/10)+1
		tab aged
		replace aged=9 if aged==10
	* Link with the person of reference (PR)
		* lien
	* Number of children living in the household
		bys ident : gen nbenftemppr=(lien1=="3")+(lien2=="3")+(lien3=="3")+(lien4=="3")+(lien5=="3")+(lien6=="3")+(lien7=="3")+(lien8=="3")+(lien9=="3")+(lien10=="3")+(lien11=="3")+(lien12=="3")+(lien13=="3")+(lien14=="3")
		gen nenf=0 
		replace nenf=nbenftemppr if lien1=="1" | lien1=="2"
		drop nbenftemppr
	* Total number of children (in and utside the household)
		replace nenf=nenf+real(hodo) if lien1=="1" | lien1=="2"
		gen nenf01=0
		replace nenf01=1 if nenf>0
	* Marital status
		*matri (1: single (C), 2: married (M), 3: widow (V), 4: divorced (D))
		codebook matri1 matri2				
		gen mat="C" if matri1=="1"
		replace mat="M" if matri1=="2"
		replace mat="V" if matri1=="3"
		replace mat="D" if matri1=="4"
		replace mat="C" if matri1==""
		drop matri*

	* sex (1 :M, 2 :F)
		tab sexe1 sexe2
		gen sexetemp=sexe1
		*attention, ne pas faire drop sexe1-sexe14 ci-dessous car a drop aussi cs
		*drop sexe1 sexe2 sexe3 sexe4 sexe5 sexe6 sexe7 sexe8 sexe9 sexe10 sexe11 sexe12 sexe13 sexe14
		gen sexe=0 if sexetemp=="1"
		replace sexe=1 if sexetemp=="2"
		
	* PCS
		tab cs1
		*codebook cs1
		gen pcs_ind=int(real(cs1)/10)
		replace pcs_ind=0 if real(cs1)==99 | cs1==""
		replace pcs_ind=9 if real(cs1)==31
		replace pcs_ind=8 if cs1=="00"
		
	tempfile temp
	save "`temp'",replace

* B) Correction of non-response
***********************************
			
	* Non-response or "do not knwow" for the estimation of wealth (4.5% of households)
	* Procedure : hotdeck stratified by 
		* marie: dummy for being married
		* age_hot: Age (<40, 40-50, 50-60, >60)
		* re05a_hot: Income bracket in 1990 (revenu global) available in 97% of cases ,sinon mis  0 pour non dclars)
		* re07cc2_hot: Wealth bracket
		* indpt : Dummy for Self-employed
		* nivsorc : Social status of the person of reference (code p37 of pdf documentation file dfic2)

	* Variables for the hotdeck stratification
		gen marie=1 if mat=="M" 
		replace marie=0 if mat~="M"
		
		gen age_hot="1840" if age<40
		replace age_ho = "4050" if missing(age_hot) & age<=50
		replace age_ho = "5060" if missing(age_hot) & age<=60
		replace age_ho = "60p"  if missing(age_hot)
		
		gen re05a_hot=re05a
		tab re05a
		replace re05a_hot="0" if re05a=="10" | missing(re05a)
		destring re05a_hot,replace
		tab re05a_hot	
		
		gen re07cc2_hot=re07cc2
		tab re07cc2
		replace re07cc2_hot="" if re07cc2=="12"
		destring re07cc2_hot, replace
		codebook re07cc2_hot,mv
		
		tab nivsoc
		gen indpt = (nivsoc==1 | nivsoc==2 | nivsoc==3 | nivsoc==4)
		tab indpt
		*gen indpt_ac_rev = indpt*(re05a_hot>0)
		*tab indpt_ac_rev
		/* Difficile d'avoir  la fois un ge dtaill et le niveau social
		comme on s'intresse au patrimoine accumule on prfre l'ge pour approcher
		le cycle de vie que la CSP, d'autant qu'on a dj le revenu de manire fine (re05)
		tab nivsoc 
		tab nivsoc if re05a_hot==0
		
		gen nivsoc_hot = 1 if (nivsoc==1 | nivsoc==2 | nivsoc==3 | nivsoc==4) & re05a_hot==0 
		replace nivsoc_hot = 2 if (nivsoc==5 | nivsoc==6) & re05a_hot==0
		replace nivsoc_hot = 3 if (nivsoc==7 | nivsoc==8 | nivsoc==9)  & re05a_hot==0
		replace nivsoc_hot = 4 if (nivsoc==10) & re05a_hot==0
		*replace nivsoc_hot = 0 if re05a_hot>8 
		replace nivsoc_hot = 0 if re05a_hot>0*/ 

	* Hotdeck procedure
		*cd "\\ulysse\users\BGarbinti\brtrd\Projet wealth_income\Hors_structure\Wealth surveys\Wealth surveys\Data"
		cd "$datapat"
		hotdeck re07cc2_hot using hotdeck,store by(marie age_hot re05a_hot indpt) keep(ident re07cc2_hot) seed(18763784) 			
		use "`temp'",clear
		erase "`temp'"
		merge 1:1 ident using hotdeck1
		erase hotdeck1.dta

		g re07cc2temp=re07cc2_hot
		tostring re07cc2temp,replace
		replace re07cc2=re07cc2temp if re07cc2=="12"
		*codebook re07cc2
		*tab re07cc2
		destring re07cc2,replace
		tostring re07cc2,replace
		tab re07cc2
		drop re07cc2temp _merge re05a_hot re07cc2_hot age_hot marie   nivsoc /*nivsoc_hot*/
								
* C) Composition of wealth by asset and income
**************************************************
							
* C.1) Estimation of exact amount of different assets from brackets
*********************************************************************
		
	* Gross wealth
	****************
		gen uni=runiform() 
		gen patrimoine_men=uni*3049 if re07cc2=="1" 
		replace patrimoine_men=3049+uni*(7622-3049) if re07cc2=="2" 
		replace patrimoine_men=7622+uni*(15245-7622) if re07cc2=="3" 
		replace patrimoine_men=15245+uni*(45735-15245) if re07cc2=="4" 
		replace patrimoine_men=45735+uni*(76225-45735) if re07cc2=="5" 
		replace patrimoine_men=76225+uni*(152449-76225) if re07cc2=="6" 
		replace patrimoine_men=152449+uni*(228674-152449) if re07cc2=="7"
		replace patrimoine_men=228674+uni*(304998-228674) if re07cc2=="8" 
		replace patrimoine_men=304998+uni*(381123-304998) if re07cc2=="9" 
		replace patrimoine_men=381123+uni*(457347-381123) if re07cc2=="10"
		*Pareto de coeff 2 pour la dernire
		replace patrimoine_men=457347*(uni^(-1/2)) if (re07cc2=="11")   
		drop uni

	* Financial assets
	*********************
		
		* compte cheque (p59)
			codebook cc3
			*mv 293/9530
			tab cc3
			gen uni=runiform() 
			gen ccheque=0
			replace ccheque = uni*762 if cc3=="2"
			replace ccheque = 762+uni*(1524-762) if cc3=="3"
			replace ccheque = 1524+uni*(3049-1524) if cc3=="4"
			replace ccheque = 3049+uni*(7623-3049) if cc3=="5"
			replace ccheque = 7623+uni*(15245-7623) if cc3=="6"
			*Pareto de coeff 2 pour la dernire
			replace ccheque = 15245*(uni^(-1/2)) if cc3=="7"
			drop cc3 uni
				
		* Compte  terme (p61)
			gen uni=runiform()
			gen caterme =0
			replace caterme= uni*152 if cd1=="1"
			replace caterme= 152+uni*(1524-152) if cd1=="2"
			replace caterme= 1524+uni*(7623-1524) if cd1=="3"
			replace caterme= 7623+uni*(30490 -7623) if cd1=="4"
			replace caterme= 30490+uni*(60980 -30490) if cd1=="5"
			*Pareto de coeff 2 pour la dernire
			replace caterme=60980*(uni^(-1/2))  if cd1=="6"
			drop  cd1 uni
			
			* divers
				gen uni=runiform()
				gen divers=0
				replace divers= uni*152 if cd3=="1"
				replace divers= 152+uni*(1524-152) if cd3=="2"
				replace divers= 1524+uni*(7623-1524) if cd3=="3"
				replace divers= 7623+uni*(30490 -7623) if cd3=="4"
				replace divers= 30490+uni*(60980 -30490) if cd3=="5"
				*Pareto de coeff 2 pour la dernire
				replace divers=60980*(uni^(-1/2))  if cd3=="6"
				drop  cd3 uni
			
			* livret p164 de lil-0125dfic2
				gen livret=0
				forval num =1/6 {
					gen unilivret`num'=runiform() 
					gen livret`num'=0
					replace livret`num'= unilivret`num'*152 if le115`num'=="1"
					replace livret`num'= 152+unilivret`num'*(1524-152) if le115`num'=="2"
					replace livret`num'= 1524+unilivret`num'*(4573-1524) if le115`num'=="3"
					replace livret`num'= 4573+unilivret`num'*(7623 -4573) if le115`num'=="4"
					replace livret`num'=7623+unilivret`num'*(10671 -7623)  if le115`num'=="5"
					replace livret`num'=10671+unilivret`num'*(13720 -10671)  if le115`num'=="6"
					*Pareto de coeff 2 pour la dernire							
					replace livret`num'=13720*(uni^(-1/2))  if le115`num'=="7"
					replace livret=livret+livret`num'
					drop unilivret`num' livret`num' le115`num'
				}
					* When the total amount is know
					gen uni=runiform()
					replace livret= uni*152 if le13=="1" 
					replace livret= 152+uni*(1524-152) if le13=="2"
					replace livret= 1524+uni*(4573-1524) if le13=="3"
					replace livret= 12196+uni*(19818 -12196) if le13=="4"
					replace livret=19818+uni*(10671 -19818)  if le13=="5"
					replace livret=19818+uni*(27440 -19818)  if le13=="6"
					*Pareto de coeff 2 pour la dernire				
					replace livret=27440*(uni^(-1/2)) if le13=="7"
					drop  le13 uni
			
			* epargne logement p194 de lil-0125dfic2
				gen epl=0
				forval num =1/8 {
					gen uniepl`num'=runiform()  
					gen epl`num'=0
					replace epl`num'= uniepl`num'*762 if elo115`num'=="1"
					replace epl`num'= 762+uniepl`num'*(1524-762) if elo115`num'=="2"
					replace epl`num'= 1524+uniepl`num'*(3049-1524) if elo115`num'=="3"
					replace epl`num'= 3049+uniepl`num'*(9147-3049) if elo115`num'=="4"
					replace epl`num'= 9147+uniepl`num'*(15245 -9147) if elo115`num'=="5"
					replace epl`num'= 15245+uniepl`num'*(30490 -15245) if elo115`num'=="6"
					*Pareto de coeff 2 pour la dernire	
					replace epl`num'=30490*(uni^(-1/2))  if elo115`num'=="7"
					replace epl=epl+epl`num'
					drop uniepl`num' epl`num' elo115`num'
				}	
					
				* When the total amount is known
				gen uni=runiform()
				replace epl= uni*762 if elo12=="1"
				replace epl= 762+uni*(1524-762) if elo12=="2"
				replace epl= 1524+uni*(3049-1524) if elo12=="3"
				replace epl= 3049+uni*(9147-3049) if elo12=="4"
				replace epl= 9147+uni*(15245 -9147) if elo12=="5"
				replace epl= 15245+uni*(30490 -15245) if elo12=="6"
				*Pareto de coeff 2 pour la dernire	
				replace epl=30490*(uni^(-1/2))   if elo12=="7"
				drop  elo12 uni
					
			* Valeurs mobilires p220 de lil-0125dfic2
				* 1: bonds, 2: sicav de ct, 3: aures sicav, 4: FCP, 5: Actions cotes, 6: SCPI immo, 7: Actions non cotes
				forval num =1/7 {
					gen uni`num'=runiform() 
					gen mob`num'=0
					replace  mob`num'= uni`num'*1524 if mob116`num'=="1"
					replace  mob`num'= 1524+uni`num'*(4573-1524) if mob116`num'=="2"
					replace  mob`num'= 4573+uni`num'*(7623-4573) if mob116`num'=="3"
					replace  mob`num'= 7623+uni`num'*(15245-7623) if mob116`num'=="4"
					replace  mob`num'= 15245+uni`num'*(38112-15245) if mob116`num'=="5"
					replace  mob`num'= 38112+uni`num'*(114337-38112) if mob116`num'=="6"
					replace  mob`num'= 114337+uni`num'*(228674-114337) if mob116`num'=="7"
					*Pareto de coeff 2 pour la dernire	
					replace  mob`num'= 228674*(uni^(-1/2))  if mob116`num'=="8"
					drop uni`num' mob116`num'
				}
				rename mob1 obli
				rename mob2 sicav
				rename mob3 autsicav
				rename mob4 fcp
				rename mob5 act
				rename mob6 actnc
				
			* Bons  p248 de lil-0125dfic2
				gen uni=runiform()
				gen bon=0
				replace bon= uni*1524 if bct12=="1"
				replace bon= 1524+uni*(4573-1524) if bct12=="2"
				replace bon= 4573+uni*(15245-7623) if bct12=="3"
				replace bon= 15245+uni*(38112 -15245) if bct12=="4"
				*Pareto de coeff 2 pour la dernire	
				replace bon=38112*(uni^(-1/2))  if bct12=="5"
				drop bct12 uni
			
			* Life insurance p259 de lil-0125dfic2
				* Valeur de rachat
				gen patfin_av=0
				forval i =1/8 {
					gen uni`i'=runiform()  
					gen avie`i' = 0
					replace avie`i' = uni`i'*3049 if ass110a`i'=="1"
					replace avie`i' = 3049+uni`i'*(7623-3049) if ass110a`i'=="2"
					replace avie`i' = 7623+uni`i'*(15245-7623) if ass110a`i'=="3"
					replace avie`i' = 15245+uni`i'*(30490-15245) if ass110a`i'=="4"
					replace avie`i' = 30490+uni`i'*(45735-30490) if ass110a`i'=="5"
					*Pareto de coeff 2 pour la dernire	
					replace avie`i' = 45735*(uni`i'^(-1/2)) if ass110a`i'=="6"
					replace patfin_av=patfin_av+avie`i'
					drop avie`i' ass110a`i' 
				}
				
				* Montant plac au lieu de la valeur de rachat quand ne sait pas ou placement ne peut etre liquid
				forval i =1/8 {
					gen avie`i' = 0
					replace avie`i' = uni`i'*3049 if ass110b`i'=="1"
					replace avie`i' = 3049+uni`i'*(7623-3049) if ass110b`i'=="2"
					replace avie`i' = 7623+uni`i'*(15245-7623) if ass110b`i'=="3"
					replace avie`i' = 15245+uni`i'*(30490-15245) if ass110b`i'=="4"
					replace avie`i' = 30490+uni`i'*(45735-30490) if ass110b`i'=="5"
					*Pareto de coeff 2 pour la dernire	
					replace avie`i' = 45735*(uni`i'^(-1/2)) if ass110b`i'=="6"
					replace patfin_av=patfin_av+avie`i'
					drop uni`i' avie`i' ass110b`i'
				}
			
	* Housing assets
	*****************

			* Owner-occupied housing (p7 de lil-0125dfic3)
				gen patfon_owner=(log107+log108)/(2*6.55957) if log107~=. & log108~=.
				replace patfon_owner = log107/6.55957 if log107~=. & log108==.
				replace patfon_owner = log108/6.55957 if log107==. & log108~=.
				replace patfon_owner=(log110+log111)/(2*6.55957) if log110~=. & log111~=.
				replace patfon_owner = log110/6.55957 if log111==. & log110~=.
				replace patfon_owner = log111/6.55957 if log110==. & log111~=.
				replace patfon_owner=0 if patfon_owner==.
			
			* Tenant-occupied housing (p16 de lil-0125dfic3)
				forval i=1/9 {
					local j=`i'+1
					gen patfon_rent`j'=(log119`i'+log120`i')/(2*6.55957) if log119`i'~=. & log120`i'~=.
					replace patfon_rent`j' = log119`i'/6.55957 if log119`i'~=. & log120`i'==.
					replace patfon_rent`j' = log120`i'/6.55957 if log119`i'==. & log120`i'~=.
					replace patfon_rent`j'=(log124`i'+log125`i')/(2*6.55957) if log124`i'~=. & log125`i'~=.
					replace patfon_rent`j' = log124`i'/6.55957 if log124`i'~=. & log125`i'==.
					replace patfon_rent`j' = log125`i'/6.55957 if log124`i'==. & log125`i'~=.
					replace patfon_rent`j'=0 if patfon_rent`j'==.
				}
					gen patfon_rent11=(log119a+log120a)/(2*6.55957) if log119a~=. & log120a~=.
					replace patfon_rent11 = log119a/6.55957 if log119a~=. & log120a==.
					replace patfon_rent11 = log120a/6.55957 if log119a==. & log120a~=.
					replace patfon_rent11=(log124a+log125a)/(2*6.55957) if log124a~=. & log125a~=.
					replace patfon_rent11 = log124a/6.55957 if log124a~=. & log125a==.
					replace patfon_rent11 = log125a/6.55957 if log124a==. & log125a~=.
					replace patfon_rent11=0 if patfon_rent11==.
				
				gen patfon_rent=0
				forval i=2/11 {	
						replace patfon_rent=patfon_rent+patfon_rent`i'
						drop patfon_rent`i'
				}
				* When individuals do not know the value of each of their housing assets or they have more than 10 housing assets (p74 de lil-0125dfic3)
				replace patfon_rent = (log126+log127)/(2*6.55957) if log126~=. & log127~=.
				replace patfon_rent = log126/6.55957 if log126~=. & log127==.
				replace patfon_rent = log127/6.55957 if log126==. & log127~=.

	* Business assets
	*******************
	
			* Land not used for business purpose (p108 de lil-0125dfic3)
				gen land=0
				replace land=(t14a+t14b)/(2*6.55957) if t14a~=. & t14b~=.
				replace land = t14a/6.55957 if t14a~=. & t14b==.
				replace land = t14b/6.55957 if t14a==. & t14b~=.
				replace land=(t15a+t15b)/(2*6.55957) if t15a~=. & t15b~=.
				replace land = t15a/6.55957 if t15a~=. & t15b==.
				replace land = t15b/6.55957 if t15a==. & t15b~=.
			
			* Locaux professionels non exploits par le menage
				forval i=1/5 {
					gen prof`i'=0
					replace prof`i' = (p14a`i'+p14b`i')/(2*6.55957) if p14a`i'~=. & p14b`i'~=.
					replace prof`i' = p14a`i'/6.55957 if p14a`i'~=. & p14b`i'==.
					replace prof`i' = p14b`i'/6.55957 if p14a`i'==. & p14b`i'~=.
					replace prof`i' = (p17a`i'+p17b`i')/(2*6.55957) if p17a`i'~=. & p17b`i'~=.
					replace prof`i' = p17a`i'/6.55957 if p17a`i'~=. & p17b`i'==.
					replace prof`i' = p17b`i'/6.55957 if p17a`i'==. & p17b`i'~=.
				}
				forval i=2/5 {
					replace prof1=prof1+prof`i'
					drop prof`i'
				}
			
			* Business assets for business purpose (p243 de lil-0125dfic3)
				gen prof2=0
				replace prof2=(patpromi +patproma)/(2*6.55957) if patpromi~=. & patpromi~=1
				drop patpromi patproma t14* t15* p14* p17* log107- re07cc2  

* C.2) Decomposition of wealth by aggregate asset category
***********************************************************

	* Financial assets:
		* patfin_div: Equities and mutual funds 
		* patfin_int: Bonds and loans 
		* patfin_liqu: Deposits and savings accounts
		* patfin_av: Life insurance and pension funds	
			
	 * Non-Financial assets:
		* patfon_owner: Owner-occupied housing assets
		* patfon_rent: Tenant-occupied housing assets
		* patpro: Business assets
	
		* Deposits and savings accounts: 
			* Placement  vue et numraire (AF21+AF22+AF291)
			gen patfin_liqu=ccheque+ livret
		
		* Bonds, loans: 
			* Placement  chance (AF292), pargne contractuelle (AF293), Obligations (AF3) titres de creances (AF4) 
			gen patfin_int=caterme+ divers+epl+obli+bon
				
		* Equities and investment fund shares
			gen patfin_div=sicav+autsicav+fcp+actnc+act
			* incl. Mututal funds (AF52)
				gen patfin_div_mut=sicav+autsicav+fcp
			* incl. private equities (AF512+AF519)
				gen patfin_div_priv=actnc
			* incl. public equities (AF511)
				gen patfin_div_pub=act
		
		gen patfin=patfin_liqu+patfin_div+patfin_int+patfin_av
		* patfin_av: Life insurance and pension funds	

		* patfon_owner: Owner-occupied housing assets	
		
		* patfon_rent: Tenant-occupied housing assets

		gen patfon=patfon_owner+patfon_rent
			
		* Business assets (unincorporated business + land)
			gen patpro=land+prof1+prof2

		drop land prof1 prof2 sicav autsicav fcp act bon actnc caterme divers livret epl obli mob7
		tempfile temp
		save "`temp'"
		
		
* C.3) Income of the houshold
*******************************
	* Financial income: Revenus de valeurs mobilires (p238 de lil-0125dfic2)
		* Correction for non response
			gen temp=patfin_int+patfin_div
			gen patfin_hot="0"
			replace patfin_hot="1" if temp<1524 & temp>0
			replace patfin_hot="2" if temp>=1524 & temp<4573
			replace patfin_hot="3" if temp>=4573 & temp<7623
			replace patfin_hot="4" if temp>=7623 & temp<15245
			replace patfin_hot="5" if temp>=15245 & temp<38112
			replace patfin_hot="6" if temp>=38112 & temp<114337
			replace patfin_hot="7" if temp>=114337 
			drop temp
			drop if mob13==""
			gen mob13_hot=mob13
			replace mob13_hot="" if mob13=="7"
			destring mob13_hot,replace
			hotdeck mob13_hot using hotdeck,store by(patfin_hot)  keep(ident mob13_hot) seed(65449) 			
			use "`temp'",clear
			erase "`temp'"
			merge 1:1 ident using hotdeck1
			erase hotdeck1.dta
			drop _merge
			tostring mob13_hot,replace
			replace mob13=mob13_hot if mob13=="7"
		* Exact amount
			gen uni=runiform()
			gen rfin_irpp_foy=0
			replace rfin_irpp_foy= uni*152.4 if mob13=="1"
			replace rfin_irpp_foy= 152.4+uni*(762.2-152.4) if mob13=="2"
			replace rfin_irpp_foy= 762.2+uni*(3049-762.2) if mob13=="3"
			replace rfin_irpp_foy= 3049+uni*(7622.4 -3049) if mob13=="4"
			replace rfin_irpp_foy= 7622.4+uni*(30490 -7622.4) if mob13=="5"
			*Pareto de coeff 2 pour la dernire
			replace rfin_irpp_foy=30490*(uni^(-1/2))  if mob13=="6"
			drop  mob13 uni
			
	* Labor income: wages+self-employed income+pensions (p66 de lil-0125dfic2)
			gen rev_act_pens=0
			forval i=1/9 {
				replace re01b0`i' =0 if re01b0`i'==.
				replace rev_act_pens=rev_act_pens+re01b0`i'/6.55957
			}
			forval i=10/18{
				replace re01b`i' =0 if re01b`i'==.
				replace rev_act_pens=rev_act_pens+re01b`i'/6.55957
			}
			drop re01b*	
	
	* Total income
		gen uni=runiform()
		gen rev_tot=0
		replace rev_tot= uni*30000 if re05a=="01"
		replace rev_tot= 30000+uni*(50000-30000) if re05a=="02"
		replace rev_tot= 50000+uni*(75000-50000) if re05a=="03"
		replace rev_tot= 75000+uni*(100000 -75000) if re05a=="04"
		replace rev_tot= 100000+uni*(130000 -100000) if re05a=="05"
		replace rev_tot= 130000+uni*(200000 -130000) if re05a=="06"
		replace rev_tot= 200000+uni*(300000 -200000) if re05a=="07"
		replace rev_tot= 300000+uni*(500000 -300000) if re05a=="08"
		*Pareto de coeff 2 pour la dernire
		replace rev_tot=500000*(uni^(-1/2))  if  re05a=="09"
		replace rev_tot=rev_tot/6.55957
		drop uni
		* For non-response (3.6%)
		replace rev_tot=rev_act_pens+rfin_irpp_foy if re05a=="" | re05a=="10"
		* Consistent with labor and financial income
		replace rev_tot=rev_act_pens if rev_tot<rev_act_pens

		tempfile temp
		save "`temp'",replace
		
* C.4) Liabilities (table endettement) (p44 de lil-0125dfic5) 
**************************************************************
	
	*use "\\ulysse\users\BGarbinti\brtrd\Projet wealth_income\Hors_structure\Wealth surveys\Wealth surveys\Data\Fichiers sources\EP 92\Stata\act922.dta", clear
	use "$datapat/EP 92/Stata/act922.dta",clear
	keep ident em11c* encour*  em4* kdutot em02*

	* encour (dummy for each loan, 0: loan already pay back)
	* em02 (Motive for the loan, "01"  = for owner-occupied housing)
	* em4 (loan for business purpose =1)
	* em11c: Capital restant d  rembourser (value of the current loan)
	* kdutit : Total liabilities at the household level
 
	g passif=0
	g passprof=0
	g passif_owner =0
	
	forval num = 1/9{
		replace em11c0`num'=0 if (em11c0`num'==-1 & encour0`num'=="1") | em11c0`num'==.
		gen passif`num'=em11c0`num'/6.55957*(em40`num'~="1")*(encour0`num'=="1")
		gen passprof`num'=em11c0`num'/6.55957*(em40`num'=="1")*(encour0`num'=="1")
		gen passif_owner`num'=em11c0`num'/6.55957*(em40`num'~="1")*(encour0`num'=="1")*(em020`num'=="01")
		replace passif = passif +passif`num'
		replace passif_owner = passif_owner +passif_owner`num'
		replace passprof = passprof +passprof`num'
	}

	forval num = 10/23{
		replace em11c`num'=0 if (em11c`num'==-1 & encour`num'=="1")  | em11c`num'==.
		gen passif`num'=em11c`num'/6.55957*(em4`num'~="1")*(encour`num'=="1")
		gen passprof`num'=em11c`num'/6.55957*(em4`num'=="1")*(encour`num'=="1")
		gen passif_owner`num'=em11c`num'/6.55957*(em4`num'~="1")*(encour`num'=="1")*(em02`num'=="01")
		replace passif = passif +passif`num'
		replace passif_owner = passif_owner +passif_owner`num'
		replace passprof = passprof +passprof`num'
	}

	replace kdutot=0 if kdutot==-1
	gen passif_tot=0
	replace passif_tot=kdutot/6.55957 if kdutot~=.

	collapse (mean) passif passprof passif_owner passif_tot,by(ident)
	/* verif : ok
		gen diff=passif+ passprof-passif_tot
		sum diff,d
		drop diff
		gen diff=passif-passif_owner
		sum diff,d
		*always >0 ok
		drop diff
	*/
	merge 1:m ident using "`temp'"
	drop _merge

* C.5) Gross wealth consistent with its components 
***************************************************
	order patrimoine_men patfon patfon_owner patfon_rent patpro patfin patfin_div patfin_div_mut patfin_div_priv patfin_div_pub patfin_int patfin_liqu ccheque patfin_av passif_tot passif passif_owner passprof  ,last
	foreach var of varlist patrimoine_men- passprof {
		replace `var'=0 if `var'==.
	}
	* Harmonisation

		* First method: Gross wealth is consistent and we adjust its components
		gen tot=patfin_int +patfin_liqu +patfin_div +patfin_av+ patpro+ patfon
		foreach var of varlist  patfin_int patfin_liqu patfin_div patfin_av patpro patfon  {
			replace `var'=`var'*patrimoine_men/tot 
			replace `var'=0 if patrimoine_men==0 | tot==0
		}
		gen tot2=patfon_owner +patfon_rent 
		foreach var of varlist  patfon_owner patfon_rent  {
			replace `var'=`var'*patfon/tot2 if tot2~=0
		}
		drop tot2
		gen tot2= patfin_div_mut +patfin_div_priv +patfin_div_pub
		foreach var of varlist  patfin_div_mut patfin_div_priv patfin_div_pub  {
			replace `var'=`var'*patfin_div/tot2  if tot2~=0
		}
		replace ccheque=min(ccheque,patfin_liqu)
		replace patfin=patfin_int +patfin_liqu +patfin_div +patfin_av 

		* For those with gross wealth >0 but missing components (3% of the case)
			sort patrimoine_men
			gen prob=0
			foreach var of varlist  patfon patfon_owner patfon_rent patpro patfin patfin_div patfin_div_mut patfin_div_priv patfin_div_pub patfin_int patfin_liqu ccheque patfin_av passif_tot passif passif_owner passprof   {
				replace prob=1 if  tot==0 & patrimoine_men>0
				replace `var'=patrimoine_men*`var'[_n-1]/patrimoine_men[_n-1] if tot==0 & patrimoine_men>0
			}
			drop tot prob
			sort ident 
	
		/* Check for consistency: gross wealth=sum of assets
			gen tot=patfin_int +patfin_liqu +patfin_div +patfin_av+ patpro+ patfon
			gen diff =tot-patrimoine_men
			sum diff  ,d
			drop diff tot 
			*/
	
		* Second method: the assets are consistent and we recompute net wealth
			

		
			
	* Net wealth and liabilities
		replace passif_owner=min(passif_owner,patfon_owner)
		replace passprof=min(passprof, patpro)
		gen temp=patfin+patfon
		replace passif=min(passif,temp)
		drop temp
		replace patpro=patpro-passprof
		gen pat=patfon+patfin+patpro-passif
			
	*Identifiants mnages 
		sort ident 
		gen id_men=_n
		
	* Harmonisation des noms de variable */
		rename lien1 lien
		
	tempfile tabmen
	save "`tabmen'",replace

* D) File at the household or individual level
************************************************

	* Household level
	*******************
		scalar drop _all
		keep year id_men  pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut rev_act_pens  rfin_irpp_foy rev_tot
		order year id_men pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut rev_act_pens  rfin_irpp_foy rev_tot

		* Arrondi des valeurs montaires
			foreach var of varlist pat-patfin_av {
				replace `var'=round(`var')
			}
		save "$wfpat/wfEP92.dta",replace

	* Individual level
	*************************
		use "`tabmen'",clear
		rename lien lien1
		keep  lien* sexe* anais* year id_men  pondn age aged nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut    
		drop sexe
		reshape long lien sexe  anais,i(year id_men pondn) j(idnum) string
		drop if lien==""

		* Age
			drop age
			gen age=1992-real(anais)

		* Decenial age
			drop aged
			gen aged=int(age/10)+1
			replace aged=9 if aged==10
			
		* keep only adults (>20 years old) 
			*Suppression des moins de 20 ans qui ne sont pas la personne de rfrence ou le conjoint ou qui sont seuls dans le mnage ou qui sont en mnage avec des moins de 20 ans
			gen prob=1 if (lien=="1" | lien=="2") &(aged<=2)
			bys id_men : egen probis=sum(prob==1)
			replace probis=1 if probis~=0
			*bys ident : egen verif=sum(aged>2)
			drop if (aged <=2 & prob~=1) 
			drop prob probis 
			replace age=20 if age<20
			replace aged=3 if aged==2 

		* Sex
			rename sexe sexetemp
			gen sexe=0 if sexetemp=="1"
			replace sexe=1 if sexetemp=="2"

		* Individual Identifier
			sort id_men lien 
			gen id_indiv=_n
			sort id_men id_indiv

		* Dummy bor being in couple 
			bys id_men : egen marie=sum(lien=="2")
			gen pac=0
			replace pac=1 if (lien~="1" & lien~="2")
			
		* Individual wealth
			keep year id_men id_indiv  pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut
			order year id_men id_indiv pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind pat passif   patpro patfon patfon_owner passif_owner patfon_rent patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut 
		
			foreach var of varlist pat-patfin_div_mut{
				replace `var'=`var'/2 if (lien=="1" | lien=="2") & marie==1
				replace `var' =0 if (lien~="1" & lien~="2") 
			}

		* Arrondi des valeurs montaires
			foreach var of varlist  pat-patfin_div_mut {
				replace `var'=round(`var')
			}
			
		save "$wfpat/wfEP92_ind.dta",replace

