/********************************************************
 Do-file used to harmonize the wealht survey 2009-2010	*
*********************************************************/


set more off
clear

local year=2010
use "$datapat/EP 09-10/Stata/individu.dta",clear
gen year=2010
		
* A) Socio-demographic variables of individuals
*************************************************		
	
	* Identifier
		* Household : identmen, Individual : identind
		rename identind idnum
	* Weight
		gen pondn=pond
	* Age
		*age
	* Decenial age 
		gen aged=int(age/10) +1
		replace aged=9 if aged>=10
	* Link with the person of reference (PR)
			* Harmonization of variable "lien" with previous surveys 
			gen lien="1" if lienpref=="00"
			replace lien="2" if lienpref=="01"
			replace lien="3" if lienpref=="02" | lienpref=="31"
			replace lien="4" if lienpref=="21" 
			replace lien="5" if lienpref=="03" |  lienpref=="22" | lienpref=="32"
			replace lien="6" if lienpref=="10" |  lienpref=="40"
			replace lien="7" if lienpref=="60" 
			replace lien="8" if lienpref=="50" | lienpref=="90" 

	* nbenf de chaque individu vivant dans le menage
			bys ident : egen nbenftemppr=sum(enf=="2")
			bys ident : egen nbenftempconj=sum(enf=="3")
			bys ident : egen nbenftempcouple=sum(enf=="1")

			gen nenf=0
			replace nenf=nbenftemppr+nbenftempcouple if lien=="1" 
			replace nenf=nbenftempconj+nbenftempcouple if lien=="2" 
			drop nbenftemp*

		*Statut matrimonial
			*etamatri (1 : celibataire/ 2 : M/ 3 : V, 4 : D)
			gen mat="C" if etamatri=="1"
			replace mat="M" if etamatri=="2"
			replace mat="V" if etamatri=="3"
			replace mat="D" if etamatri=="4"
			replace mat="C" if etamatri==""
			drop etamatri


		* sexe (1 :M, 2 :F)
			gen sexetemp=sexe
			drop sexe
			gen sexe=0 if sexetemp=="1"
			replace sexe=1 if sexetemp=="2"
		
		* harmonisation avec enqutes DMTG
			gen pcs_indtemp=real(cs24)
			gen pcs_ind=int(pcs_indtemp/10) if pcs_indtemp<70 | pcs_indtemp>80
			replace pcs_ind=9 if cs24=="31"
			replace pcs_ind=pcs_indtemp-70 if pcs_indtemp>70 & pcs_indtemp<80
			replace pcs_ind=0 if pcs_ind==.
			drop pcs_indtemp
			
		keep year identmen idnum noi sexe age aged lien nenf mat pondn pcs_ind
		order year identmen idnum noi pondn sexe age aged lien nenf mat pcs_ind
		
	* Merge avec table menage
		merge m:m identmen using "$datapat/EP 09-10/Stata/menage.dta",keepusing(hodnb patimm patfisom patri_brut patprofent patprofhent patri_net mtdettes mtdetpriv mtreste zfoncier zrag zrentes zretraites zrevdec zrevfin zric zrnc zsalaires zchomage) force
		drop _merge
		
		* Nbre d'enfants = nbre d'enfants dans le mnage +nbre d'enfans hors domicile
			replace nenf=nenf+hodnb if lien=="1" | lien=="2"
			gen nenf01=0
			replace nenf01=1 if nenf>0
			
		* Income
			* Financial income
				gen rfin_irpp_foy=zrevfin
			* Labor income: wages+self-employed income+pensions	
				gen rev_act_pens=zretraites+zrentes+zsalaire+zchomage+max(0,zric)+ max(0,zrnc) +max(0,zrag)
			* Rental income
				gen rfon_irpp_foy=max(0,zfoncier)
			* Total income
				gen rev_tot=rev_act_pens+rfin_irpp_foy+rfon_irpp_foy
			
			    
	* B) Caractristiques du patrimoine des invidus
		
				* Au niveau mnage : 
						*Note dans l'enqute 2010, une partie du patrimoine non observ correspondant aux voitures, biens lectromnagers... ont t estims (variable mtreste) et inclut dans le patrimoine. Pour rendre comparable les diffrentes enqutes on ne le prend pas en compte ici
						* Variables agrges au niveau mnage : patimm, patfisom, patprofent, patprofhent, patri_net, mt_dettes (mtdetpriv+mtdetprofhent+mtdetprofhent), MTRESTE
						
							
				keep year-pcs_ind nenf01 patimm patfisom patri_brut patprofent patprofhent patri_net mtdettes mtdetpriv mtreste *_foy rev_act_pens rev_tot
				tempfile temp
				save "`temp'",replace
								
					* Wealth composition :
				
						* Financial assets:
							* patfin_div: Equities and mutual funds 
							* patfin_int: Bonds and loans 
							* patfin_liqu: Deposits and savings accounts
							* patfin_av: Life insurance and pension funds	
								
						 * Non-Financial assets:
							* patfon_owner: Owner-occupied housing assets
							* patfon_rent: Tenant-occupied housing assets
							* patpro: Business assets
							
						
						* Financial assets					
							use  nature finna logna montcla identmen detqua detnat detptyp nop parmen natemp using "$datapat/EP 09-10/Stata/produit.dta" ,clear 
							destring nature finna logna detqua detnat detptyp natemp, replace
							
							keep if nature==1 | nature==2 | (nature==6 & detnat==1)


									* Table par produits classs en fonction de nature puis dcompos en sous-catgorie (fina, logna...) 
										* Montant =MONTCLA
										* Pour 5 cas, la variable montcla_corr corrige montcla mais on ne peut pas l'utiliser car le patrimoine financier au niveau du mnage patfisom est gal  somme de montcla. En prenant montcla_corr, on a une incohrence.
										
										/* Code nature du produit
											1 Actif financier
											2 Actif immobilier
											3 Terre ou autre bien professionnel non exploit professionnellement par
											le mnage
											4 Terre ou autre bien professionnel exploit professionnellement par le
											mnage
											5 Prt
											6 Endettement
										
										fina
										a	01 Compte-chques
										a	02 Livret A
										a	03 Livret Bleu
										a	04 Livret de dveloppement durable (LDD, ancien CODEVI)
										a	05 Livret d'pargne populaire (LEP)
										a	06 Livret jeune
										a	07 Livret soumis  l'impt (Livret B, livret Orange, pargne Orange, )
										a	08 Plan pargne-logement (PEL)
										a	09 Compte pargne-logement (CEL)
										a	10 Epargne salariale sous forme d'argent plac sur un compte courant bloqu
										a	11 Epargne salariale sous forme de Sicav ou FCPE, dtenus dans le cadre d'un PEE ou PEI ou PEG
										a	12 Epargne salariale sous forme de Sicav ou FCPE, dtenus hors du cadre d'un PEE ou PEI ou PEG
										a	13 Epargne salariale sous forme de titres de son entreprise, dtenus dans le cadre d'un PEE ou PEI ou PEG
										a	14 Epargne salariale sous forme de titres de son entreprise, dtenus hors du cadre d'un PEE ou PEI ou PEG
										a	16 Plan d'pargne retraite populaire (PERP)
										a	17 Plan d'pargne populaire (PEP)
										a	18 Retraite surcomplmentaire
										a	19 Retraite complmentaire volontaire
										a	20 Assurance-vie
										a	21 Bons de capitalisation
										a	22 Plan d'pargne en actions (PEA)
										a	23 Actions cotes sur un compte-titres ordinaire
										a	24 Actions non cotes sur un compte-titres ordinaire
										a	25 Obligations sur un compte-titres ordinaire
										a	26 Sicav ou FCP sur un compte-titres ordinaire
										a	27 Parts sociales de banque sur un compte-titres ordinaire
										a	28 Parts de SCPI sur un compte-titres ordinaire
										a	30 Actions non cotes ou parts de SARL hors compte-titres ordinaire
										a	31 Bons d'pargne, bons de caisse ou bons du Trsor
										a	32 Compte  termes
										a	33 Compte courant d'associ
										a	34 Livret d'pargne en entreprise (LEE)
										a	35 Autre produit n'ayant pu tre reclass dans sa catgorie
										
										*/
														
							replace montcla=0 if montcla==.
							
							* Deposits and savings accounts: 
								* Placement  vue et numraire (AF21+AF22+AF291)
								gen patfin_liqu=montcla if finna<=7   | finna==9 
								* incl. Deposits (Compte cheque dans patfin_liqu (AF21+AF22))
									gen ccheque=montcla if finna==1
																						
							* Bonds, loans: 
								* Placement  chance (AF292), pargne contractuelle (AF293), Obligations (AF3) titres de creances (AF4) 
								gen patfin_int=montcla if  finna==8 | finna==10  | finna==17 | finna==25 | finna==31 | finna==32 | finna==33 | finna==34 | finna==35
							
							* Equities and investment fund shares
								gen patfin_div=montcla if finna==11 |finna==12 | finna==13 |  finna==14 | finna==22 | finna==23 | finna==24 | finna==26 | finna==27 | finna==28 | finna==30
								* incl. Mututal funds (AF52)
									gen patfin_div_mut=montcla if finna==11 | finna==12 | finna==26 | finna==28
								* incl. private equities (AF512+AF519)
									gen patfin_div_priv=montcla if finna==24 | finna==27 | finna==30
								* incl. public equities (AF511)
									gen patfin_div_pub=montcla if finna==13 | finna==14 | finna==22 | finna==23
							
							* Life insurance and pension funds	
								gen patfin_av = montcla if finna==16  | finna==18 | finna==19  |finna==20 | finna==21
						
					* owner-occupied housing assets 		
						* Debts on owner-occupied housing 
								gen passif_owner=montcla if detqua==1
								replace passif_owner=0 if passif_owner<0 | passif_owner==.
						* Gross Owner-occupied housing 
								gen patfon_owner=montcla*parmen/100 if logna==1
								replace patfon_owner=0 if patfon_owner<0 | patfon_owner==.
								
					foreach var of varlist patfin_liqu-patfon_owner  {
						replace `var'=0 if `var'==. | `var'<0
					}
					
					* Retraitement de nop
						replace nop="00" if nop=="ME"
						rename nop noi
						
						
					collapse (sum) patfin_liqu-patfon_owner,by(identmen noi)	
					merge m:m identmen noi using "`temp'"
					rename identmen ident
					
					foreach var of varlist patfin_liqu-patfon_owner  {
							replace `var'=0 if _merge==2
					}
					* Reclassement des actifs de la table produit dtenue au niveau mnage
						bys ident : egen pac_adult=sum((lien=="3")*(age>=20 & age<=26))
						replace pac_adult=1 if pac_adult>1
						bys ident : egen patfin_liqu_pac=sum(patfin_liqu*(lien=="3")*(age>=20 & age<=26))
						foreach var of varlist patfin_liqu-patfon_owner {
							bys ident : egen `var'_men=sum(`var')
							drop `var'
							rename `var'_men `var'
						}
										
						drop if noi=="00"
						drop _merge noi		
										
					* Business assets (Household level)
						gen patpro=patprofhent+patprofent
						replace patpro=0 if patpro<0
						
					* Total Financial assets
						gen patfin= patfin_liqu+ patfin_int+patfin_div+patfin_av
						/* verif
							gen temp=patfin-patfisom
							sum temp if patfisom>0,d
							drop temp
						*/
					* Housing assets (nature=2) (Household level)
						gen patfon=patimm
						gen patfon_rent=patfon-patfon_owner

					* Other assets : durable goods  (Household level)
						gen reste=mtreste
						* On ajoute les biens durables 
						
					* Endettement prof et person (MTDETTES = MTDETRPIV + MTDETPROFHENT + MTDETPROFENT) (Household level)
						* On dduit du passif perso le montant des biens durables. COmme on ne compte pas les biens durables dans le patrimoine, les enlever du passif permet de retrouver la mme valeur de patri_net calcule par l'INSEE
						* On exprime directement le patrimoine pro net des dettes
						replace passif_owner=min(passif_owner,patfon_owner)
						gen passif=max(0,mtdetpriv-mtreste)
						gen passprof=max(0,mtdettes-passif-mtreste)
						gen temp=patfin+patfon
						replace passif=min(passif,temp)
						replace passprof=min(passprof, patpro)
						replace patpro=patpro-passprof
						gen pat=patfon+patfin+patpro-passif	
						drop temp 
						
					/* Module verif 
							* Comparaison patrimoine brut patrimoine avec somme des composantes du patrimoine: c'est bon
								* j'ai une petite diff pour 1% des individus due au fait que je remets  0 toutes les composantes du patrimoine ngatives (mais l'erreur est ngligeable au niveau agrg). 		
								gen diff =patpro+passprof+patfon+patfin+reste-patri_brut
								sum diff ,d
								drop diff
							* Comparaison patrimoine net patrimoine avec somme des composantes du patrimoine
								* j'ai une diff due au fait que l'endettement ne peut tre suprieur  l'actif considr	
								gen diff =patpro+patfon+patfin+reste-passif-patri_net
								sum diff ,d
								drop diff	
							*/
					
						
						
	* C) Retraitement de la population 
			
			* Suppression des moins de 20 ans qui ne sont pas la personne de rfrence ou le conjoint ou qui sont seuls dans le mnage ou qui sont en mnage avec des moins de 20 ans
					gen prob=1 if (lien=="1" | lien=="2") &(aged<=2)
					bys ident : egen probis=sum(prob==1)
					replace probis=1 if probis~=0
					*bys ident : egen verif=sum(aged>2)
					drop if (aged <=2 & prob~=1) 
					drop prob probis
					replace age=20 if age<20
					replace aged=3 if aged==2 			
							
			/* Retraitement des pondrations
					quiet sum pondn
					replace pondn=pondn*${pondn`year'}*1000/r(sum)				
			*/			
			* Identifiants mnages et individuels
				sort ident lien idnum
				gen temp=1 if lien=="1"
				replace temp=0 if temp==.
				gen id_men=sum(temp)
				
	
	* D) Sauvergarde du fichier mnage
			tempfile tabmen
			save "`tabmen'",replace
			keep if lien=="1"
	
			scalar drop _all
			keep  year id_men pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif  patpro patfon patfon_owner passif_owner patfon_rent  patfin patfin_div  patfin_int patfin_liqu  patfin_av pac_adult patfin_liqu_pac patfin_div_pub patfin_div_priv patfin_div_mut ccheque  reste rev_act_pens rfin_irpp_foy rfon_irpp_foy rev_tot
			order year id_men pondn sexe age aged lien nenf nenf01 mat pcs_ind pat passif  patpro patfon patfon_owner passif_owner patfon_rent  patfin patfin_div  patfin_int patfin_liqu  patfin_av patfin_liqu_pac  ccheque  patfin_div_pub patfin_div_priv patfin_div_mut reste rev_act_pens rfin_irpp_foy rfon_irpp_foy rev_tot pac_adult
	
			* Arrondi des valeurs montaires
				foreach var of varlist pat-patfin_div_mut {
					replace `var'=round(`var')
				}
				
				
save "$wfpat/wfEP10.dta",replace

	* E) FIchier individuel
	
		use "`tabmen'",clear
				
		* identifiant individuel	
			sort id_men lien idnum
			gen id_indiv=_n
			sort id_men id_indiv
			drop temp ident idnum patfin_liqu_pac
			
		*Indicatrice de couple (presence de lien=2 dans le menage)
			bys id_men : egen marie=sum(lien=="2")
			gen pac=0
			replace pac=1 if (lien~="1" & lien~="2")
			
			order year id_men id_indiv pondn sexe age aged lien pac marie  nenf nenf01 mat pcs_ind   pat passif  patpro patfon patfon_owner passif_owner patfon_rent  patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut   rfin_irpp_foy
			keep year id_men id_indiv pondn sexe age aged lien  pac marie nenf nenf01 mat  pcs_ind   pat passif  patpro patfon patfon_owner passif_owner patfon_rent  patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut   rfin_irpp_foy

			* Patrimoine individuel
			foreach var of varlist pat-patfin_div_mut rfin_irpp_foy {
				replace `var'=`var'/2 if (lien=="1" | lien=="2") & marie==1
				replace `var' =0 if (lien~="1" & lien~="2") 
			}
			rename rfin_irpp_foy rfin_irpp_ind
			
			* Arrondi des valeurs montaires
				foreach var of varlist pat-patfin_div_mut rfin_irpp_ind {
					replace `var'=round(`var')
				}
				
save "$wfpat/wfEP10_ind.dta",replace
			
	
		
						 
		
						
	
