******************************************************************
* Exportation of the results related to GGP2016Wealth Appendix A *
******************************************************************


global projdir "C:/Users/John/Dropbox/WIDFrance/Papers"
global rawresultsB "$projdir/GGP2016Wealth/GGP2016WealthAppendixB/DataFiles/Exportation/Results"
global rawresultsC "$projdir/GGP2016Wealth/GGP2016WealthAppendixC/DataFiles"
global rawresultsA "$projdir/GGP2016Wealth/GGP2016WealthAppendixA/DataFiles"
global rawresultsDINAA "$projdir/GGP2017DINA/GGP2017DINAAppendixA"

* I) Creation of unified gperc 1800-2014
*******************************************

		* Total adult population for year 1800-1969
			import excel using "$rawresultsDINAA/GGP2017DINAAppendixA.xlsx",  clear sheet("A0") cellrange(A17:Q169) 
			gen year=A if _n>=9	
			destring year,replace
			replace  year=1795 if _n==1
			replace year=year[_n-1]+10 if _n>1 & _n<9
			gen pop=P*1000 
			keep year pop
			tempfile NA
			save "`NA'",replace
			
			clear
			set obs 215
			gen year=1799+_n
			merge 1:1 year using "`NA'"
			keep if year>=1805
			local i=1
			foreach num of numlist 1805(10)1855 1865 {
				local j=`i'+10
				if `num'==1865 {
					local j= `i'+5
				}
				sum pop if _n==`i'
				local ni =r(mean)
				sum pop if _n==`j'
				local nj=r(mean)
				replace pop=`ni'+(`nj'-`ni')*(_n-`i')/(`j'-`i') if _n<`j' & _n>`i'
				local i=`i'+10
			}
			drop _merge
			erase "`NA'"
			tempfile NA
			save "`NA'",replace
		
		* Period 1970-2014
			use "$rawresultsB/gperc/gperc_19702014.dta",clear
			keep if sex==0
			keep year ytop n gperc thr b patmean pop yint
			* Threshold
				rename thr ythr
			* Percentile
				gen p =gperc
				replace p=p*10 if gperc<99990
				replace p=p*10 if gperc<9990
				replace p=p*10 if gperc<990
				drop gperc		
			tempfile temp19702014
			save "`temp19702014'",replace

		* Period 1820-1969
			use "$rawresultsC/gperc_wealth_1800_1970.dta",clear
			merge m:1 year using "`NA'"
			drop if _merge==2
			drop _merge
			* Number of adults
				rename f n
				replace n=pop*n/100000
			* top average
				rename ytop_hweal_j ytop
			* Threshold
				rename ythr_hweal_j  ythr  
			* Pareto coefficient
				rename b_hweal_j b
			* Intermediate average
				rename yint_hweal_j  yint
				
			bys year :egen patmean=sum(ytop*(p==0))
			drop ythr_hweal_j_d yint_hweal_j_d ytop_hweal_j_d
			append using "`temp19702014'"
			erase "`temp19702014'"
		* Check
			sort year p
			gen prob=0
			replace prob=1 if ythr>ythr[_n+1] & year==year[_n+1]
			replace prob=1 if yint>ythr[_n+1] & year==year[_n+1]
			replace prob=1 if yint<ythr & year==year[_n+1]
			replace prob=1 if yint>yint[_n+1] & year==year[_n+1]
			tab year if prob==1
			drop prob	
			
		sort year p
		save "$rawresultsA/gpercwealth18002014.dta",  replace
		
* II) Total cumulated growth and average growh rate
******************************************************

	* Import GDP deflator index
		insheet using "$projdir/GGP2016Wealth/WID_export/inyixx999i_FR.csv",clear  delimiter(";")
		keep year inyixx999i
		rename inyixx999i priceindex
		
	* Series of wealth among equal-split adults by gperc 1800-2014
		merge 1:m year using "$rawresultsA/gpercwealth18002014.dta"
		sum priceindex if year==1820
		replace priceindex=r(mean) if year<1820
		drop if _merge==1
		drop _merge
		* convert in 2014 euros
			foreach var of varlist yint ytop {
				replace `var'=`var'*100*6.55957 if year==1950 | year==1949
				replace `var'=`var'/priceindex
			}
		keep yint ytop year p  n pop
		save "$rawresultsA/temp/tempgrowth.dta", replace
				
				
	* A) By wealth groups (Bottom 50, Middle 40, Top 10...) and time periods (1900-1950, 1950-1983, 1983-2014, 1900-2014, 1950-2014)
	*******************************************************************************************************************************
		use "$rawresultsA/temp/tempgrowth.dta",clear
		gsort + year - p
		bys year : gen npop =sum(n)
		drop n
		gen n=round(npop/pop*100000)/1000
		keep if p==0 | p==50000 | p==90000 | p==99000 | p==99900 | p==99990 
		keep if year==1807 | year==1902 | year==1950 | year==1983 | year==2014
		replace year=1900 if year==1902
		replace year=1800 if year==1807
		sort year p
		replace n=(p[_n+1]-p)/1000 if p<90000


		* Intermediate average income
			replace yint=(ytop*npop-ytop[_n+1]*npop[_n+1])/(npop-npop[_n+1]) if p<=90000 
			* P90-99 
				expand 2 if p==90000
				sort year p
				replace p=90990 if p[_n-1]==90000 & p==90000
				replace n=9 if p==90990
			* P90-100
				replace yint=ytop if p==90000 |  p>=99000
			* For Full population
				expand 2 if p==0
				sort year p
				replace p=-1 if p[_n+1]==0 & p==0
				replace n=100 if p==-1
				replace yint=ytop if p==-1
				keep year p yint n
		reshape wide yint, i(p n) j(year)

		* Cumulative growth 
			forval loop=1/7 {
				if `loop'==1 {
					local i =1800
					local j =1900
				}
				if `loop'==2 {
					local i =1900
					local j =1950
				}
				if `loop'==3 {
					local i =1950
					local j =1983
				}
				if `loop'==4 {
					local i =1983
					local j =2014
				}
				if `loop'==5 {
					local i =1800
					local j =2014
				}
				if `loop'==6 {
					local i =1900
					local j =2014
				}
				if `loop'==7 {
					local i =1950
					local j =2014
				}
				gen agrowth_`i'`j'=(yint`j'/yint`i')^(1/(`j'-`i'))-1
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
				egen temp=sum((yint`j'-yint`i')*(p==-1))
				gen sharegrowth_`i'`j'=(yint`j'-yint`i')*n/100/temp
				drop temp
			}
		
		keep p agrowth* cgrowth* sharegrowth*
		export excel using "$rawresultsA/exportresults_Wealth_A.xlsx", sheet("TA3")   sheetmodify cell(A1) firstrow(variables)

	
	* B) By detailed percentiles (gperc) and time periods (1800-1900, 1900-1950, 1950-1983, 1983-2014) 
	**************************************************************************************************
		use "$rawresultsA/temp/tempgrowth.dta",clear
		keep if (p>=20000 & p<=99990)
		keep if year==1807 | year==1902 | year==1950 | year==1983 | year==2014
		replace year=1900 if year==1902
		replace year=1800 if year==1807
		replace yint=ytop if p==99990 	
		keep year p yint
		reshape wide yint, i(p) j(year)
		* Cumulative growth 
			forval loop=1/5 {
				if `loop'==1 {
					local i =1800
					local j =2014
				}
				if `loop'==2 {
					local i =1800
					local j =1900
				}
				if `loop'==3 {
					local i =1900
					local j =1950
				}
				if `loop'==4 {
					local i =1950
					local j =1983
				}
				if `loop'==5 {
					local i =1983
					local j =2014
				}
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
				gen agrowth_`i'`j'=(yint`j'/yint`i')^(1/(`j'-`i'))-1
			}
		
		keep p agrowth* cgrowth*
		order p cgrowth*
		export excel using "$rawresultsA/exportresults_Wealth_A.xlsx", sheet("growthFR")   sheetmodify cell(A7) firstrow(variables)

		
	* C) Robustness checks for period around 1983-2014
	*****************************************************
		use "$rawresultsA/temp/tempgrowth.dta",clear
		keep if (p>=20000 & p<=99990)	
		keep if (year>=1982 & year <=1984) | (year>=2012 & year <=2014)
		replace yint=ytop if p==99990 	
		keep year p yint
		reshape wide yint, i(p) j(year)
		* Cumulative growth 
			forval loop=1/3 {
				if `loop'==1 {
					local i =1984
					local j =2012
				}
				if `loop'==2 {
					local i =1983
					local j =2012
				}
				if `loop'==3 {
					local i =1984
					local j =2014
				}
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
			}
		keep cgrowth*
		export excel using "$rawresultsA/exportresults_Wealth_A.xlsx", sheet("growthFR")   sheetmodify cell(M7) firstrow(variables)

	
	
		
		
		


