****************************************
* Exportation of wealth share for WID
****************************************

global projdir "C:/Users/John/Dropbox/WIDFrance/Papers"
global rawresultsB "$projdir/GGP2016Wealth/GGP2016WealthAppendixB/DataFiles/Exportation/Results"
global rawresultsA "$projdir/GGP2016Wealth/GGP2016WealthAppendixA/DataFiles"

/**************************
Relevant Notations
	a) Prefix
		o Top average 
		t threshold
		s share
		n number of the given units
		b betacoefficient
		a average between two percentiles
	*b) Sufix
		j equal split
		992 adults 
		hweal : personal wealth
************************************/

***************************
* I) Exportation of gperc *
***************************	
	 use "$rawresultsA/gpercwealth18002014.dta",clear
		* top average
			rename ytop o
		* Threshold
			rename ythr  t  
		* Intermediate average
			rename yint  a
		* Percentile
			rename p p2
		drop patmean
		bys year :egen patmean=sum(o*(p2==0))
		* Pop above threshold
			gsort + year - p2
			bys year : gen npop =sum(n)
			bys year : egen ytot=sum(npop*o*(p2==0))
		* wealth share above threshold
			gen s=o*npop/ytot
		* Harmonization of percentile name
			gen ptemp=p2
			tostring ptemp,gen(ptemp2)
			drop p2
			gen p2="p"+substr(ptemp2,1,1) if ptemp<=9000
			replace p2="p"+substr(ptemp2,1,2) if ptemp<=99000 & p2==""
			replace p2="p"+substr(ptemp2,1,2)+"."+substr(ptemp2,3,1) if ptemp<=99900 & p2==""
			replace p2="p"+substr(ptemp2,1,2)+"."+substr(ptemp2,3,2) if ptemp<=99990 & p2==""
			replace p2="p"+substr(ptemp2,1,2)+"."+substr(ptemp2,3,3) if ptemp>99990 & p2==""

		* Check
			sort year ptemp
			gen prob=0
			replace prob=1 if t>t[_n+1] & year==year[_n+1]
			replace prob=1 if a>t[_n+1] & year==year[_n+1]
			replace prob=1 if a<t & year==year[_n+1]
			replace prob=1 if a>a[_n+1] & year==year[_n+1]
			tab year if prob==1
			drop prob	
			
		gen alpha2="FR"
		foreach var of varlist o t s b a n {
			rename `var' `var'hweal992j
		}
		sort year ptemp
		keep alpha2 year p2  *hweal992j ptemp
		order alpha2 year p2  *hweal992j ptemp
		save "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.dta",  replace
		
		insheet using "$projdir/GGP2016Wealth/WID_export/inyixx999i_FR.csv",clear  delimiter(";")
		drop p2
		merge 1:m year using "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.dta"
		sum inyixx999i if year==1820
		replace inyixx999i=r(mean) if year<1820
		drop if _merge==1
		
		foreach var of varlist thweal992j ahweal992j ohweal992j {
			replace `var'=`var'*100*6.55957 if year==1950 | year==1949
			replace `var'=`var'/inyixx999i
		}
		sort  ptemp year
		drop ptemp _merge inyixx999i
		outsheet using "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.csv",    delimiter(";") replace
		save "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.dta",  replace


****************************************
* I) Exportation of wealth composition *
****************************************
	import excel using "$rawresultsB/exportresults_wealthcap.xlsx", first clear sheet("comptanat") cellrange(A7:D52) 
	merge 1:m year using "$rawresultsB/dperc/dperc_w.dta"
	keep if sex==0
	drop sex
	gen n=0.1 if dperc<=90
	replace n=0.05 if dperc==95
	replace n=0.01 if dperc==99
	replace n=0.005 if dperc==995
	replace n=0.001 if dperc==999
	
	* Wealth composition in % total wealth
		foreach var of varlist sh_patnonfi-sh_patfinhorsliqu {
			replace `var'=`var'*share_dperc
		}
	* Cumulative above P90
		gsort + year -dperc
		foreach var of varlist share_dperc-sh_patfinhorsliqu {
			bys year : gen `var'temp=sum(`var') 
			replace `var'=`var'temp if dperc>=90
			drop `var'temp
		}
		
	* Average wealth and its components by wealth group
		gen ahweal=share_dperc*wealth*1000000/(n*pop)
		foreach var of varlist sh_patnonfi-sh_patfinhorsliqu {
			replace `var'=`var'/share_dperc*ahweal
		}
	* Verif
		gen verif=ahweal-sh_patnonfi- sh_patfin+ sh_passif
		sum verif,d
		drop verif
	
	rename sh_patnonfi ahwnfa
	rename sh_patfon_brut ahwhou
	rename sh_patpro ahwbus
	rename sh_patfin ahwfin
	rename sh_patfin_liquint ahwfix
	rename sh_patfin_liqu ahwcud
	rename sh_patfin_int ahwbol
	rename sh_patfin_div ahwequ
	rename sh_patfin_av ahwpen
	rename sh_passif ahwdeb
	rename sh_patfinhorsliqu ahwfie
	keep year dperc a*
	
	sort year dperc
	gen dperctemp=dperc
	tostring dperc,replace
	gen alpha2="FR"
	gen p2="p"+dperc+"p"+dperc[_n+1] if dperctemp<90
	replace p2= "p"+dperc+"p100" if dperctemp>=90 & dperctemp<=99
	replace p2="p"+substr(dperc,1,2)+"."+substr(dperc,3,1)+"p100"  if dperctemp>99 & p2==""
	drop  dperc
	order alpha2 year p2 ahweal
	foreach var of varlist ahweal-ahwfie  {
			rename `var' `var'992j
	}
	sort year dperctemp
	save "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.dta",  replace
	
	insheet using "$projdir/GGP2016Wealth/WID_export/inyixx999i_FR.csv",clear  delimiter(";")
	drop p2
	merge 1:m year using "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.dta"
	drop if _merge==1
	drop _merge
	
	foreach var of varlist ahweal992j-ahwfie992j {
		replace `var'=`var'/inyixx999i
	}
	sort alpha2 dperctemp year
	drop inyixx999i dperctemp
	save "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.dta",  replace
	outsheet using "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.csv",    delimiter(";") replace
